/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.comp;

import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentAdapter;
import cib.cad.db.feature.AngleFeature;
import cib.cad.db.feature.BooleanFeature;
import cib.cad.db.feature.DistanceFeature;
import cib.cad.db.feature.Feature;
import cib.cad.db.feature.Point2DFeature;
import cib.util.AttributedImage;
import cib.util.CoordSpace;
import cib.util.coll.NamedListIterator;
import cib.util.coll.NamedListIteratorAdapter;
import cib.util.geo.Geo2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ComponentImage
extends ComponentAdapter {
    private transient Point2D[] t_changedControlPoints = new Point2D[8];
    private transient AffineTransform t_trfInv = null;
    private static final long serialVersionUID = 0L;
    private AttributedImage m_image = new AttributedImage();
    private static final String[] FEATURE_NAMES = new String[]{"GEOMETRY.POINT_2D", "GEOMETRY.WIDTH", "GEOMETRY.HEIGHT", "GEOMETRY.ANGLE", "GEOMETRY.FLIP_X_AXIS", "GEOMETRY.FLIP_Y_AXIS"};

    public ComponentImage() {
        this(1.0, 1.0, new AffineTransform());
    }

    public ComponentImage(double width, double height, AffineTransform trf) {
        this.setTransform(trf);
        this.setImageSize(width, height);
    }

    @Override
    public Object clone() {
        ComponentImage comp = (ComponentImage)super.clone();
        comp.m_image = (AttributedImage)this.m_image.clone();
        return comp;
    }

    @Override
    public void assign(Component rhs) {
        ComponentImage rhsComp = (ComponentImage)rhs;
        this.m_image = (AttributedImage)rhsComp.m_image.clone();
        super.assign(rhs);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.t_changedControlPoints = new Point2D[8];
        this.t_trfInv = null;
    }

    public AffineTransform getTransform() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        AffineTransform trf = this.m_image.getTransform();
        trf.preConcatenate(w2u);
        double[] d_ = new double[6];
        trf.getMatrix(d_);
        double angle = this._getAngle(w2u);
        trf = this.m_image.getTransform();
        trf.rotate(angle);
        double[] d = new double[4];
        trf.getMatrix(d);
        trf.setTransform(d[0], d[1], d[2], d[3], d_[4], d_[5]);
        return trf;
    }

    public void setTransform(AffineTransform _trf) {
        AffineTransform trf = new AffineTransform(_trf);
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        _trf.preConcatenate(u2w);
        double[] d_ = new double[6];
        _trf.getMatrix(d_);
        double angle = this._getAngle(u2w);
        trf.rotate(angle);
        double[] d = new double[4];
        trf.getMatrix(d);
        trf.setTransform(d[0], d[1], d[2], d[3], d_[4], d_[5]);
        this.m_image.setTransform(trf);
        this._notifyWasChanged();
    }

    private double _getAngle(AffineTransform mat) {
        Point2D.Double origin = new Point2D.Double();
        Point2D.Double xAxis = new Point2D.Double(1.0, 0.0);
        mat.transform(origin, origin);
        mat.transform(xAxis, xAxis);
        double dx = ((Point2D)xAxis).getX() - ((Point2D)origin).getX();
        double dy = ((Point2D)xAxis).getY() - ((Point2D)origin).getY();
        double angle = Math.atan2(dy, dx);
        return angle;
    }

    public BufferedImage getImage() {
        return this.m_image.getImage();
    }

    public void setImageFile(File file) throws IOException {
        this.m_image.setImageFile(file);
        this._notifyWasChanged();
    }

    public File getOriginalImageFile() {
        return this.m_image.getOriginalImageFile();
    }

    public File getPhysicalImageFile() {
        return this.m_image.getPhysicalImageFile();
    }

    public void setImageSize(double width, double height) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        double scale = this._getScale(cs.getUserToWorldTransform());
        this.m_image.setImageSize(width * scale, height * scale);
        this._notifyWasChanged();
    }

    public double getWidth() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        double scale = this._getScale(cs.getWorldToUserTransform());
        return this.m_image.getWidth() * scale;
    }

    public double getHeight() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        double scale = this._getScale(cs.getWorldToUserTransform());
        return this.m_image.getHeight() * scale;
    }

    private double _getScale(AffineTransform mat) {
        Point2D.Double po = new Point2D.Double(0.0, 0.0);
        Point2D.Double px = new Point2D.Double(1.0, 0.0);
        mat.transform(po, po);
        mat.transform(px, px);
        return Geo2D.distance((Point2D)po, px);
    }

    @Override
    public void transformBy(AffineTransform _trf) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform trf = cs.getWorldToUserTransform();
        trf.preConcatenate(_trf);
        trf.preConcatenate(cs.getUserToWorldTransform());
        this.m_image.transformBy(trf);
        this._notifyWasChanged();
    }

    private AttributedImage getAttributedImage() {
        AttributedImage image = (AttributedImage)this.m_image.clone();
        image.setTransform(this.getTransform());
        image.setImageSize(this.getWidth(), this.getHeight());
        return image;
    }

    @Override
    public NamedListIterator<AttributedImage> imageIterator() {
        return NamedListIteratorAdapter.singletonNamedListIterator(this.getAttributedImage());
    }

    @Override
    public boolean hasControlPoint(int name) {
        return name >= 0 && name < 8;
    }

    @Override
    public Point2D getControlPoint(int name) throws IllegalArgumentException {
        double w = this.getWidth();
        double h = this.getHeight();
        AffineTransform trf = this.getTransform();
        switch (name) {
            case 0: {
                Point2D.Double p = new Point2D.Double(0.0, 0.0);
                return trf.transform(p, p);
            }
            case 1: {
                Point2D.Double p = new Point2D.Double(0.5 * w, 0.0);
                return trf.transform(p, p);
            }
            case 2: {
                Point2D.Double p = new Point2D.Double(w, 0.0);
                return trf.transform(p, p);
            }
            case 3: {
                Point2D.Double p = new Point2D.Double(w, 0.5 * h);
                return trf.transform(p, p);
            }
            case 4: {
                Point2D.Double p = new Point2D.Double(w, h);
                return trf.transform(p, p);
            }
            case 5: {
                Point2D.Double p = new Point2D.Double(0.5 * w, h);
                return trf.transform(p, p);
            }
            case 6: {
                Point2D.Double p = new Point2D.Double(0.0, h);
                return trf.transform(p, p);
            }
            case 7: {
                Point2D.Double p = new Point2D.Double(0.0, 0.5 * h);
                return trf.transform(p, p);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setControlPointStarts() {
        int i = 0;
        while (i < this.t_changedControlPoints.length) {
            this.t_changedControlPoints[i] = null;
            ++i;
        }
        try {
            this.t_trfInv = null;
            this.t_trfInv = this.getTransform().createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    @Override
    public void setControlPointEnds() {
        double w = this.getWidth();
        double h = this.getHeight();
        double[] x = new double[]{0.0, w, w, 0.0};
        double[] y = new double[]{0.0, 0.0, h, h};
        int nChangedCornerPoints = 0;
        if (this.t_changedControlPoints[0] != null) {
            ++nChangedCornerPoints;
            x[0] = this.t_changedControlPoints[0].getX();
            y[0] = this.t_changedControlPoints[0].getY();
            x[3] = x[0];
            y[1] = y[0];
        }
        if (this.t_changedControlPoints[2] != null) {
            ++nChangedCornerPoints;
            x[1] = this.t_changedControlPoints[2].getX();
            y[1] = this.t_changedControlPoints[2].getY();
            x[2] = x[1];
            y[0] = y[1];
        }
        if (this.t_changedControlPoints[4] != null) {
            ++nChangedCornerPoints;
            x[2] = this.t_changedControlPoints[4].getX();
            y[2] = this.t_changedControlPoints[4].getY();
            x[1] = x[2];
            y[3] = y[2];
        }
        if (this.t_changedControlPoints[6] != null) {
            ++nChangedCornerPoints;
            x[3] = this.t_changedControlPoints[6].getX();
            y[3] = this.t_changedControlPoints[6].getY();
            x[0] = x[3];
            y[2] = y[3];
        }
        int nChangedSidePoints = 0;
        if (this.t_changedControlPoints[1] != null) {
            ++nChangedSidePoints;
            y[0] = this.t_changedControlPoints[1].getY();
            y[1] = this.t_changedControlPoints[1].getY();
        }
        if (this.t_changedControlPoints[3] != null) {
            ++nChangedSidePoints;
            x[1] = this.t_changedControlPoints[3].getX();
            x[2] = this.t_changedControlPoints[3].getX();
        }
        if (this.t_changedControlPoints[5] != null) {
            ++nChangedSidePoints;
            y[2] = this.t_changedControlPoints[5].getY();
            y[3] = this.t_changedControlPoints[5].getY();
        }
        if (this.t_changedControlPoints[7] != null) {
            ++nChangedSidePoints;
            x[3] = this.t_changedControlPoints[7].getX();
            x[0] = this.t_changedControlPoints[7].getX();
        }
        w = x[1] - x[0];
        h = y[3] - y[0];
        this.setImageSize(w, h);
        AffineTransform trf = this.getTransform();
        trf.translate(x[0], y[0]);
        this.setTransform(trf);
    }

    @Override
    public void setControlPoint(Point2D pnt, int name) throws UnsupportedOperationException {
        if (this.t_trfInv == null) {
            throw new UnsupportedOperationException();
        }
        this.t_changedControlPoints[name] = this.t_trfInv.transform(pnt, new Point2D.Double());
    }

    @Override
    public NamedListIterator<Point2D> controlPointIterator() {
        return new NamedListIteratorAdapter<Point2D>(){

            @Override
            protected int _size() {
                return 8;
            }

            @Override
            protected Point2D _get(int index) {
                return ComponentImage.this.getControlPoint(index);
            }

            @Override
            protected void _set(int index, Point2D p) {
                ComponentImage.this.setControlPoint(p, index);
            }
        };
    }

    @Override
    public boolean hasFeature(String name) {
        int i = 0;
        while (i < FEATURE_NAMES.length) {
            if (name.equals(FEATURE_NAMES[i])) {
                return true;
            }
            ++i;
        }
        return super.hasFeature(name);
    }

    @Override
    public Feature getFeature(String name) {
        if (name.equals(FEATURE_NAMES[0])) {
            return new Point2DFeature(FEATURE_NAMES[0], this.getControlPoint(0));
        }
        if (name.equals(FEATURE_NAMES[1])) {
            return new DistanceFeature(FEATURE_NAMES[1], Math.abs(this.getWidth()));
        }
        if (name.equals(FEATURE_NAMES[2])) {
            return new DistanceFeature(FEATURE_NAMES[2], Math.abs(this.getHeight()));
        }
        if (name.equals(FEATURE_NAMES[3])) {
            AffineTransform trf = this.getTransform();
            Point2D.Double origin = new Point2D.Double();
            Point2D.Double xAxis = new Point2D.Double(1.0, 0.0);
            trf.transform(origin, origin);
            trf.transform(xAxis, xAxis);
            double dx = ((Point2D)xAxis).getX() - ((Point2D)origin).getX();
            double dy = ((Point2D)xAxis).getY() - ((Point2D)origin).getY();
            double angle = Math.atan2(dy, dx);
            return new AngleFeature(FEATURE_NAMES[3], angle);
        }
        if (name.equals(FEATURE_NAMES[4])) {
            return new BooleanFeature(FEATURE_NAMES[4], this.getHeight() < 0.0);
        }
        if (name.equals(FEATURE_NAMES[5])) {
            return new BooleanFeature(FEATURE_NAMES[5], this.getWidth() < 0.0);
        }
        return super.getFeature(name);
    }

    @Override
    public void setFeature(Feature feature) {
        if (feature.getName().equals(FEATURE_NAMES[0])) {
            Point2D pnt = this.getControlPoint(0);
            Point2D pntT = (Point2D)feature.getValue();
            AffineTransform trf = AffineTransform.getTranslateInstance(pntT.getX() - pnt.getX(), pntT.getY() - pnt.getY());
            this.transformBy(trf);
        } else if (feature.getName().equals(FEATURE_NAMES[1])) {
            double width = ((DistanceFeature)feature).getDistance();
            this.setImageSize(width, this.getHeight());
        } else if (feature.getName().equals(FEATURE_NAMES[2])) {
            double height = ((DistanceFeature)feature).getDistance();
            this.setImageSize(this.getWidth(), height);
        } else if (feature.getName().equals(FEATURE_NAMES[3])) {
            double angle = ((AngleFeature)this.getFeature("GEOMETRY.ANGLE")).getAngle();
            double angleT = ((AngleFeature)feature).getAngle();
            Point2D pnt = this.getControlPoint(0);
            AffineTransform trf = AffineTransform.getRotateInstance(angleT - angle, pnt.getX(), pnt.getY());
            this.transformBy(trf);
        } else if (feature.getName().equals(FEATURE_NAMES[4])) {
            boolean flip = ((BooleanFeature)feature).getBoolean();
            double height = Math.abs(this.getHeight());
            if (flip) {
                height = -height;
            }
            this.setImageSize(this.getWidth(), height);
        } else if (feature.getName().equals(FEATURE_NAMES[5])) {
            boolean flip = ((BooleanFeature)feature).getBoolean();
            double width = Math.abs(this.getWidth());
            if (flip) {
                width = -width;
            }
            this.setImageSize(width, this.getHeight());
        } else {
            super.setFeature(feature);
        }
    }

    @Override
    public Iterator<Feature> featureIterator() {
        final Iterator<Feature> itThis = new Iterator<Feature>(){
            private int m_index = 0;

            @Override
            public boolean hasNext() {
                return this.m_index < FEATURE_NAMES.length;
            }

            @Override
            public Feature next() {
                if (this.hasNext()) {
                    return ComponentImage.this.getFeature(FEATURE_NAMES[this.m_index++]);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        final Iterator<Feature> itBase = super.featureIterator();
        return new Iterator<Feature>(){

            @Override
            public boolean hasNext() {
                return itBase.hasNext() | itThis.hasNext();
            }

            @Override
            public Feature next() {
                if (itBase.hasNext()) {
                    return (Feature)itBase.next();
                }
                if (itThis.hasNext()) {
                    return (Feature)itThis.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

