/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.feature;

import cib.cad.db.feature.FeatureAdapter;
import cib.util.geo.Geo2D;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DoubleFeature
extends FeatureAdapter {
    private static final long serialVersionUID = 1L;
    private String m_format = null;

    public DoubleFeature(String name) {
        this(name, 0.0);
    }

    public DoubleFeature(String name, double value) {
        super(name);
        this.m_value = new Double(value);
    }

    public double getDoubleValue() {
        return (Double)this.m_value;
    }

    @Override
    public void valueFromString(String value) {
        double val = s_interpreter.getNumber(value).doubleValue();
        this.m_value = new Double(val);
    }

    @Override
    public String valueToString() {
        double val = (Double)this.m_value;
        if (this.m_format == null) {
            return Geo2D.formatDouble(val);
        }
        DecimalFormat nf = new DecimalFormat();
        nf.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        nf.applyLocalizedPattern(this.getFormat());
        return nf.format(val);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public void setFormat(String format) {
        this.m_format = format;
    }

    public String getFormat() {
        return this.m_format;
    }
}

