/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.layer;

import cib.cad.db.Database;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.Component;
import cib.cad.db.layer.Layer;
import cib.cad.db.layer.LayerSet;
import cib.cad.db.layer._LayerMap;
import cib.cad.db.layer._LayerSet;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.NameSpace;
import cib.util.coll.ObservableSet;
import cib.util.coll.ReverseAccessMap;
import java.util.HashSet;
import java.util.Set;

public class LayerManager {
    private static transient LayerManager s_instance = null;

    public static LayerSet createLayerSet(ObservableSet<Layer> set) {
        return new _LayerSet(set);
    }

    public static ReverseAccessMap<Component, Layer> createLayerMap(LayerSet layers, ReverseAccessMap<Component, Layer> map) {
        return new _LayerMap(layers, map);
    }

    public LayerManager(Database db) {
        s_instance = this;
    }

    public static LayerManager getLayerManager() {
        return s_instance;
    }

    public Layer addLayer(String name, Attributes att) {
        Database db = Kernel.getInstance().getDatabase();
        LayerSet layerSet = db.getLayerSet();
        if (name.equals("NULL_LAYER")) {
            return layerSet.getNullLayer();
        }
        Layer layer = null;
        NameSpace ns = db.getNameSpace();
        if (ns.containsName(name)) {
            Object obj = ns.getObject(name);
            if (!(obj instanceof Layer)) {
                return layerSet.getNullLayer();
            }
            if (!layerSet.contains(obj)) {
                return layerSet.getNullLayer();
            }
            layer = (Layer)obj;
        } else {
            layer = new Layer();
            ns.put(layer, name);
            layerSet.add(layer);
        }
        layer.setAttributes(att);
        return layer;
    }

    public Layer getLayer(String name) {
        Database db = Kernel.getInstance().getDatabase();
        LayerSet layerSet = db.getLayerSet();
        if (name.equals("NULL_LAYER")) {
            return layerSet.getNullLayer();
        }
        NameSpace ns = db.getNameSpace();
        if (ns.containsName(name)) {
            Object obj = ns.getObject(name);
            if (!(obj instanceof Layer)) {
                return layerSet.getNullLayer();
            }
            if (!layerSet.contains(obj)) {
                return layerSet.getNullLayer();
            }
            return (Layer)obj;
        }
        return layerSet.getNullLayer();
    }

    public String getDefaultLayer() {
        Database db = Kernel.getInstance().getDatabase();
        LayerSet layerSet = db.getLayerSet();
        Layer layer = layerSet.getDefaultLayer();
        return this.getLayerName(layer);
    }

    public Layer setDefaultLayer(String name) {
        Database db = Kernel.getInstance().getDatabase();
        LayerSet layerSet = db.getLayerSet();
        Layer layer = this.getLayer(name);
        layerSet.setDefaultLayer(layer);
        return layer;
    }

    public Layer getComponentLayer(Component comp) {
        Database db = Kernel.getInstance().getDatabase();
        ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
        return (Layer)layerMap.get(comp);
    }

    public void setComponentLayer(Component comp, Layer layer) {
        Database db = Kernel.getInstance().getDatabase();
        ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
        layerMap.put(comp, layer);
    }

    public String getLayerName(Layer layer) {
        Database db = Kernel.getInstance().getDatabase();
        LayerSet layerSet = db.getLayerSet();
        if (!layerSet.contains(layer)) {
            return "NULL_LAYER";
        }
        NameSpace ns = db.getNameSpace();
        if (!ns.containsObject(layer)) {
            return "NULL_LAYER";
        }
        return ns.getName(layer);
    }

    public Set<String> getLayers() {
        Database db = Kernel.getInstance().getDatabase();
        HashSet<String> set = new HashSet<String>();
        LayerSet layerSet = db.getLayerSet();
        NameSpace ns = db.getNameSpace();
        for (Layer layer : layerSet) {
            set.add(ns.getName(layer));
        }
        return set;
    }

    public boolean removeLayer(String name) {
        if (name.equals("NULL_LAYER")) {
            return false;
        }
        Database db = Kernel.getInstance().getDatabase();
        LayerSet layerSet = db.getLayerSet();
        Layer layer = this.getLayer(name);
        if (layer == null) {
            return false;
        }
        return layerSet.remove(layer);
    }

    public boolean containsLayer(String name) {
        if (name.equals("NULL_LAYER")) {
            return true;
        }
        Database db = Kernel.getInstance().getDatabase();
        NameSpace ns = db.getNameSpace();
        LayerSet layerSet = db.getLayerSet();
        if (ns.containsName(name)) {
            Object obj = ns.getObject(name);
            if (!(obj instanceof Layer)) {
                return false;
            }
            return layerSet.contains(obj);
        }
        return false;
    }

    public String getLocalizedLayerName(String name) {
        if (!this.containsLayer(name)) {
            return Messages.getString("db.layer.Layer.Name.NULL_LAYER");
        }
        String key = "db.layer.Layer.Name." + name;
        String locName = Messages.getString(key);
        return locName.startsWith("!") && !Messages.containsKey(key) ? name : locName;
    }

    public String getLocalizedLayerSemantics(String name) {
        if (!this.containsLayer(name)) {
            return Messages.getString("db.layer.Layer.Semantics.NULL_LAYER");
        }
        String key = "db.layer.Layer.Semantics." + name;
        String semantics = Messages.getString(key);
        return semantics.startsWith("!") && !Messages.containsKey(key) ? "?" : semantics;
    }
}

