/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.layer;

import cib.cad.db.Database;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.Component;
import cib.cad.db.layer.Layer;
import cib.cad.db.layer.LayerSelector;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.NameSpace;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.coll.ReverseAccessMap;
import java.util.HashMap;
import java.util.Map;

public class SetLayer
implements Cmd {
    private String m_toString = null;
    protected Map<Component, Layer> m_layerMap = new HashMap<Component, Layer>();
    protected Map<Component, Attributes> m_attMap = new HashMap<Component, Attributes>();

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        NameSpace ns = db.getNameSpace();
        ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
        if (selSet.isEmpty()) {
            System.out.println(Messages.getString("db.layer.SetLayer.0"));
            return;
        }
        LayerSelector layerSelector = LayerSelector.getLayerSelector(krnl);
        String name = layerSelector.select(Messages.getString("db.layer.SetLayer.1"));
        Layer layer = (Layer)ns.getObject(name);
        boolean inheritLayerAttributes = krnl.readYesNo(Messages.getString("db.layer.SetLayer.2"), 18);
        for (Component comp : selSet) {
            this.m_layerMap.put(comp, (Layer)layerMap.get(comp));
            layerMap.put(comp, layer);
            this.m_attMap.put(comp, comp.getAttributes());
            if (!inheritLayerAttributes) continue;
            comp.setAttributes(layer.getAttributes());
        }
        this.m_toString = String.valueOf(Messages.getString("db.layer.SetLayer.3")) + selSet.size() + Messages.getString("db.layer.SetLayer.4");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = krnl.getDatabase().getSelectSet();
        ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
        if (selSet.isEmpty()) {
            System.out.println(Messages.getString("db.layer.SetLayer.5"));
            return;
        }
        for (Component comp : selSet) {
            Layer old = (Layer)layerMap.get(comp);
            layerMap.put(comp, this.m_layerMap.get(comp));
            this.m_layerMap.put(comp, old);
            Attributes att = this.m_attMap.get(comp);
            this.m_attMap.put(comp, comp.getAttributes());
            if (comp.getAttributes() == att) continue;
            comp.setAttributes(att);
        }
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return !this.m_layerMap.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

