/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.ext.dxf.ExportEntityHeader;
import cib.util.dxf.DXFWriter;
import cib.util.dxf.GroupCode;
import java.io.IOException;

public class ExportCircle
extends ExportEntityHeader {
    private double m_centerX = 0.0;
    private double m_centerY = 0.0;
    private double m_radius = 0.0;

    public ExportCircle(double centerX, double centerY, double radius) {
        this.m_centerX = centerX;
        this.m_centerY = centerY;
        this.m_radius = radius;
    }

    @Override
    public boolean commit(DXFWriter writer) throws IOException {
        if (this._isNaN()) {
            return false;
        }
        writer.writeGroup(GroupCode.GC0, "CIRCLE");
        writer.writeGroup(GroupCode.GC5, writer.nextHandle());
        writer.writeGroup(GroupCode.GC100, "AcDbEntity");
        super.commit(writer);
        writer.writeGroup(GroupCode.GC100, "AcDbCircle");
        writer.writeGroup(GroupCode.GC10, this.m_centerX);
        writer.writeGroup(GroupCode.GC20, this.m_centerY);
        writer.writeGroup(GroupCode.GC40, this.m_radius);
        return true;
    }

    private boolean _isNaN() {
        return Double.isNaN(this.m_centerX) || Double.isNaN(this.m_centerY) || Double.isNaN(this.m_radius);
    }
}

