/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.Database;
import cib.cad.ext.dxf.ExportEntityHeader;
import cib.cad.kernel.Kernel;
import cib.cad.view.TextView;
import cib.util.AttributedText;
import cib.util.CoordSpace;
import cib.util.dxf.DXFWriter;
import cib.util.dxf.GroupCode;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public class ExportText
extends ExportEntityHeader {
    private static final double PT_PER_IN = 72.0;
    private static final double IN_PER_M = 39.37;
    private AttributedText m_attributedText = null;
    private TextView m_textView = null;

    public ExportText(AttributedText at, TextView tv) {
        this.m_attributedText = at;
        this.m_textView = tv;
    }

    @Override
    public boolean commit(DXFWriter writer) throws IOException {
        AttributedCharacterIterator cit = this.m_attributedText.getAttributedString().getIterator();
        char chr = cit.first();
        while (chr != '\uffff') {
            if (chr == '\n') {
                return this.commitMText(writer);
            }
            chr = cit.next();
        }
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        CoordSpace cs = db.getCoordSpace();
        writer.writeGroup(GroupCode.GC0, "TEXT");
        writer.writeGroup(GroupCode.GC5, writer.nextHandle());
        writer.writeGroup(GroupCode.GC100, "AcDbEntity");
        super.commit(writer);
        writer.writeGroup(GroupCode.GC100, "AcDbText");
        AttributedCharacterIterator acit = this.m_attributedText.getAttributedString().getIterator();
        double hMax = 1.0E-4;
        String fontFamily = null;
        int runLimit = 0;
        while (acit.setIndex(runLimit) != '\uffff') {
            runLimit = acit.getRunLimit();
            Map<AttributedCharacterIterator.Attribute, Object> map = acit.getAttributes();
            for (AttributedCharacterIterator.Attribute attr : map.keySet()) {
                Object value = map.get(attr);
                if (attr.equals(TextAttribute.SIZE) && value instanceof Number) {
                    double h = ((Number)value).doubleValue() / 72.0 / 39.37;
                    if (!(hMax < h)) continue;
                    hMax = h;
                    continue;
                }
                if (!attr.equals(TextAttribute.FAMILY) || fontFamily != null) continue;
                fontFamily = (String)value;
            }
        }
        writer.writeGroup(GroupCode.GC40, hMax);
        StringBuffer buf = new StringBuffer();
        char chr2 = acit.first();
        while (chr2 != '\uffff') {
            buf.append(chr2);
            chr2 = acit.next();
        }
        writer.writeGroup(GroupCode.GC1, buf.toString());
        int hJust = 0;
        int vJust = 0;
        switch (this.m_attributedText.getJustification()) {
            case 0: {
                hJust = 0;
                vJust = 0;
                break;
            }
            case 9: {
                hJust = 0;
                vJust = 1;
                break;
            }
            case 1: {
                hJust = 0;
                vJust = 2;
                break;
            }
            case 2: {
                hJust = 0;
                vJust = 3;
                break;
            }
            case 3: {
                hJust = 1;
                vJust = 0;
                break;
            }
            case 10: {
                hJust = 1;
                vJust = 1;
                break;
            }
            case 4: {
                hJust = 1;
                vJust = 2;
                break;
            }
            case 5: {
                hJust = 1;
                vJust = 3;
                break;
            }
            case 6: {
                hJust = 2;
                vJust = 0;
                break;
            }
            case 11: {
                hJust = 2;
                vJust = 1;
                break;
            }
            case 7: {
                hJust = 2;
                vJust = 2;
                break;
            }
            case 8: {
                hJust = 2;
                vJust = 3;
            }
        }
        writer.writeGroup(GroupCode.GC7, fontFamily);
        AffineTransform trf = this.m_attributedText.getTransform();
        Point2D.Double origin = new Point2D.Double(0.0, 0.0);
        Point2D.Double pointX = new Point2D.Double(1.0, 0.0);
        Point2D originDash = trf.transform(origin, new Point2D.Double());
        Point2D pointXDash = trf.transform(pointX, new Point2D.Double());
        double angle = Math.atan2(pointXDash.getY() - originDash.getY(), pointXDash.getX() - originDash.getX());
        writer.writeGroup(GroupCode.GC50, Math.toDegrees(angle));
        if (hJust == 0 && vJust == 0) {
            writer.writeGroup(GroupCode.GC10, originDash.getX());
            writer.writeGroup(GroupCode.GC20, originDash.getY());
            writer.writeGroup(GroupCode.GC30, 0);
        } else {
            writer.writeGroup(GroupCode.GC11, originDash.getX());
            writer.writeGroup(GroupCode.GC21, originDash.getY());
            writer.writeGroup(GroupCode.GC31, 0);
            double dx = this.m_textView.getOffsetX() / 2834.64;
            double dy = this.m_textView.getOffsetY() / 2834.64;
            writer.writeGroup(GroupCode.GC10, originDash.getX() + (dx *= cs.getMillimetersPerNaturalUnit() / 1000.0));
            writer.writeGroup(GroupCode.GC20, originDash.getY() - (dy *= cs.getMillimetersPerNaturalUnit() / 1000.0));
            writer.writeGroup(GroupCode.GC30, 0);
        }
        double scaleText = this.m_attributedText.getScaleInTextDirection();
        writer.writeGroup(GroupCode.GC41, scaleText);
        if ((trf.getType() & 0x40) != 0) {
            writer.writeGroup(GroupCode.GC71, 4);
        }
        writer.writeGroup(GroupCode.GC72, hJust);
        writer.writeGroup(GroupCode.GC100, "AcDbText");
        writer.writeGroup(GroupCode.GC73, vJust);
        return true;
    }

    public boolean commitMText(DXFWriter writer) throws IOException {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        CoordSpace cs = db.getCoordSpace();
        writer.writeGroup(GroupCode.GC0, "MTEXT");
        writer.writeGroup(GroupCode.GC5, writer.nextHandle());
        writer.writeGroup(GroupCode.GC100, "AcDbEntity");
        super.commit(writer);
        writer.writeGroup(GroupCode.GC100, "AcDbMText");
        AffineTransform trf = this.m_attributedText.getTransform();
        Point2D.Double origin = new Point2D.Double(0.0, 0.0);
        Point2D.Double pointX = new Point2D.Double(1.0, 0.0);
        Point2D originDash = trf.transform(origin, new Point2D.Double());
        Point2D pointXDash = trf.transform(pointX, new Point2D.Double());
        writer.writeGroup(GroupCode.GC10, originDash.getX());
        writer.writeGroup(GroupCode.GC20, originDash.getY());
        writer.writeGroup(GroupCode.GC30, 0);
        double angle = Math.atan2(pointXDash.getY() - originDash.getY(), pointXDash.getX() - originDash.getX());
        writer.writeGroup(GroupCode.GC50, Math.toDegrees(angle));
        AttributedCharacterIterator acit = this.m_attributedText.getAttributedString().getIterator();
        double hMax = 1.0E-4;
        String fontFamily = null;
        int runLimit = 0;
        while (acit.setIndex(runLimit) != '\uffff') {
            runLimit = acit.getRunLimit();
            Map<AttributedCharacterIterator.Attribute, Object> map = acit.getAttributes();
            for (AttributedCharacterIterator.Attribute attr : map.keySet()) {
                Object value = map.get(attr);
                if (attr.equals(TextAttribute.SIZE) && value instanceof Number) {
                    double h = ((Number)value).doubleValue() / 72.0 / 39.37;
                    if (!(hMax < h)) continue;
                    hMax = h;
                    continue;
                }
                if (!attr.equals(TextAttribute.FAMILY) || fontFamily != null) continue;
                fontFamily = (String)value;
            }
        }
        writer.writeGroup(GroupCode.GC40, hMax);
        double width = this.m_textView.getBoundingWidth() / 72.0 / 39.37;
        writer.writeGroup(GroupCode.GC41, width *= cs.getMillimetersPerNaturalUnit() / 1000.0);
        int attachmentPoint = 0;
        switch (this.m_attributedText.getJustification()) {
            case 0: {
                attachmentPoint = -1;
                break;
            }
            case 9: {
                attachmentPoint = 7;
                break;
            }
            case 1: {
                attachmentPoint = 4;
                break;
            }
            case 2: {
                attachmentPoint = 1;
                break;
            }
            case 3: {
                attachmentPoint = -2;
                break;
            }
            case 10: {
                attachmentPoint = 8;
                break;
            }
            case 4: {
                attachmentPoint = 5;
                break;
            }
            case 5: {
                attachmentPoint = 2;
                break;
            }
            case 6: {
                attachmentPoint = -3;
                break;
            }
            case 11: {
                attachmentPoint = 9;
                break;
            }
            case 7: {
                attachmentPoint = 6;
                break;
            }
            case 8: {
                attachmentPoint = 3;
            }
        }
        writer.writeGroup(GroupCode.GC71, Math.abs(attachmentPoint));
        writer.writeGroup(GroupCode.GC72, 5);
        StringBuffer buf = new StringBuffer();
        char chr = acit.first();
        while (chr != '\uffff') {
            if (chr == '\n') {
                buf.append("\\P");
            } else {
                buf.append(chr);
            }
            chr = acit.next();
        }
        int i = 0;
        i = 0;
        while (i + 250 < buf.length()) {
            writer.writeGroup(GroupCode.GC3, buf.substring(i, i + 250));
            i += 250;
        }
        writer.writeGroup(GroupCode.GC1, buf.substring(i, buf.length()));
        writer.writeGroup(GroupCode.GC7, fontFamily);
        return true;
    }
}

