/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentArc2D;
import cib.cad.kernel.Kernel;
import cib.util.dxf.Attributes;
import cib.util.dxf.GroupCode;
import cib.util.dxf.ObjectCoordinateSystem;
import cib.util.geo.Vector2D;

public class ImportArc {
    public static Component create(Kernel krnl, Attributes atts) {
        double xc = atts.getDoubleValue(GroupCode.GC10);
        double yc = atts.getDoubleValue(GroupCode.GC20);
        double r = atts.getDoubleValue(GroupCode.GC40);
        double startAngle = Math.toRadians(atts.getDoubleValue(GroupCode.GC50));
        double endAngle = Math.toRadians(atts.getDoubleValue(GroupCode.GC51));
        double openAngle = endAngle - startAngle;
        if (openAngle < 0.0) {
            openAngle = openAngle + Math.PI + Math.PI;
        }
        ObjectCoordinateSystem ocs = new ObjectCoordinateSystem(atts);
        double x = ocs.getXinWCS(xc, yc, 0.0);
        double y = ocs.getYinWCS(xc, yc, 0.0);
        Vector2D vecStartOCS = new Vector2D(startAngle);
        Vector2D vecStartWCS = new Vector2D(ocs.getXinWCS(vecStartOCS.x, vecStartOCS.y, 0.0), ocs.getYinWCS(vecStartOCS.x, vecStartOCS.y, 0.0));
        double angleStartWCS = Vector2D.X_UNIT.getAngleCCW(vecStartWCS);
        Vector2D vecBiasOCS = new Vector2D(startAngle + 0.1);
        Vector2D vecBiasWCS = new Vector2D(ocs.getXinWCS(vecBiasOCS.x, vecBiasOCS.y, 0.0), ocs.getYinWCS(vecBiasOCS.x, vecBiasOCS.y, 0.0));
        double z = vecStartWCS.x * vecBiasWCS.y - vecStartWCS.y * vecBiasWCS.x;
        return new ComponentArc2D(x, y, r, angleStartWCS, openAngle *= Math.signum(z));
    }
}

