/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.ext.dxf.DXFImporter;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.WinFit;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPanel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.dxf.QuitDXFParserException;
import cib.util.dxf.interpreter.ParseException;
import cib.util.geo.Geo2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ImportDXF
implements Cmd {
    private Set<Component> m_cmpSet = new HashSet<Component>();
    private String m_toString = null;
    private static Object s_input = null;

    public static File openFileDialog() {
        Kernel krnl = Kernel.getInstance();
        final String[] EXT = new String[]{"dxf", "DXF"};
        return krnl.readFile(new Kernel.FileDialogConfiguration(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String fileName = f.getName();
                if (!fileName.endsWith("." + EXT[0]) && !fileName.endsWith("." + EXT[1])) {
                    return false;
                }
                if (!f.exists()) {
                    System.err.println(String.valueOf(f.getAbsolutePath()) + Messages.getString("ext.dxf.ImportDXF.4"));
                    return false;
                }
                if (!f.canRead()) {
                    System.err.println(String.valueOf(Messages.getString("ext.dxf.ImportDXF.5")) + f.getAbsolutePath());
                    return false;
                }
                return true;
            }

            @Override
            public String[] getExtensions() {
                return EXT;
            }

            @Override
            public String getPrompt() {
                return Messages.getString("ext.dxf.ImportDXF.6");
            }

            @Override
            public String getFileFormatDescription() {
                return String.valueOf(Messages.getString("ext.dxf.ImportDXF.7")) + " (*." + EXT[0] + ", *." + EXT[1] + ")";
            }
        });
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        this.m_cmpSet.addAll(cmpSet);
        double mm = ImportDXF.mmPerNaturalUnit();
        File file = ImportDXF.openFileDialog();
        DXFImporter importer = new DXFImporter();
        importer.setMillimetersPerNaturalUnit(mm);
        try {
            importer.importFromFile(file);
        }
        catch (IOException e) {
            System.err.println(e.getLocalizedMessage());
            cmpSet.retainAll(this.m_cmpSet);
            this.m_cmpSet.clear();
            throw new CmdAbortedException();
        }
        catch (QuitDXFParserException e) {
            System.err.println(e.getLocalizedMessage());
            cmpSet.retainAll(this.m_cmpSet);
            this.m_cmpSet.clear();
            throw new CmdAbortedException();
        }
        catch (ParseException e) {
            System.err.println(e.getLocalizedMessage());
            cmpSet.retainAll(this.m_cmpSet);
            this.m_cmpSet.clear();
            throw new CmdAbortedException();
        }
        krnl.getUserInterface().updateUserInterface();
        UserInterface ui = krnl.getUserInterface();
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            DrawPanel drawPanel = (DrawPanel)it.next();
            Rectangle2D rectangle = drawPanel.getViewBounds();
            if (rectangle == null) continue;
            WinFit.zoom(drawPanel, rectangle);
        }
        Map<String, Integer> transferredElements = importer.getImportedInstanceCounts();
        int nTransferred = ImportDXF.entityCount(transferredElements);
        String status = String.valueOf(ImportDXF.entityCount(transferredElements)) + Messages.getString("ext.dxf.ImportDXF.43");
        Set<String> keys = transferredElements.keySet();
        for (String type : keys) {
            Integer i = transferredElements.get(type);
            status = String.valueOf(status) + "\n\t" + i + " " + type + "s";
        }
        Map<String, Integer> notTransferredElements = importer.getUnimportableInstanceCounts();
        int nNotTransferred = ImportDXF.entityCount(notTransferredElements);
        status = String.valueOf(status) + "\n\n" + nNotTransferred + Messages.getString("ext.dxf.ImportDXF.48");
        keys = notTransferredElements.keySet();
        for (String type : keys) {
            Integer i = notTransferredElements.get(type);
            status = String.valueOf(status) + "\n\t" + i + " " + type + "s";
        }
        krnl.readOK(Messages.getString("ext.dxf.ImportDXF.52"), Messages.getString("ext.dxf.ImportDXF.53"), status, 6);
        this.m_toString = String.valueOf(Messages.getString("ext.dxf.ImportDXF.60")) + nTransferred + Messages.getString("ext.dxf.ImportDXF.61") + (nTransferred + nNotTransferred) + Messages.getString("ext.dxf.ImportDXF.62");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        HashSet<Component> dxfSet = new HashSet<Component>();
        dxfSet.addAll(cmpSet);
        dxfSet.removeAll(this.m_cmpSet);
        cmpSet.retainAll(this.m_cmpSet);
        this.m_cmpSet.clear();
        this.m_cmpSet.addAll(dxfSet);
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        HashSet<Component> orgSet = new HashSet<Component>();
        orgSet.addAll(cmpSet);
        orgSet.removeAll(this.m_cmpSet);
        cmpSet.addAll(this.m_cmpSet);
        this.m_cmpSet.clear();
        this.m_cmpSet.addAll(orgSet);
    }

    @Override
    public boolean changesState() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString != null ? this.m_toString : super.toString();
    }

    static int entityCount(Map<String, Integer> map) {
        int nEntities = 0;
        Set<String> keys = map.keySet();
        for (String type : keys) {
            Integer i = map.get(type);
            nEntities += i.intValue();
        }
        return nEntities;
    }

    static double mmPerNaturalUnit() {
        Kernel krnl = Kernel.getInstance();
        final UserInterface ui = krnl.getUserInterface();
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setUniqueName("ext.dxf.ImportDXF-menu0");
        dlg.setPrompt(Messages.getString("ext.dxf.ImportDXF.70"));
        dlg.setDefaultChoice(dlg.addChoice("Done"));
        dlg.addSeparator();
        dlg.addChoice("mm");
        dlg.addChoice("cm");
        dlg.addChoice("m");
        dlg.addChoice("km");
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void textEntered(String text) {
                double val;
                try {
                    val = Double.parseDouble(text);
                }
                catch (NumberFormatException e) {
                    return;
                }
                if (val <= Geo2D.getEps()) {
                    System.err.println(Messages.getString("ext.dxf.ImportDXF.75"));
                }
                s_input = new Double(val);
                ui.disposeCmdLineDialog();
            }

            @Override
            public void choiceSelected(int iChoice) {
                switch (iChoice) {
                    case 0: {
                        s_input = Double.NaN;
                        break;
                    }
                    case 1: {
                        s_input = new Double(1.0);
                        break;
                    }
                    case 2: {
                        s_input = new Double(10.0);
                        break;
                    }
                    case 3: {
                        s_input = new Double(1000.0);
                        break;
                    }
                    case 4: {
                        s_input = new Double(1000000.0);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                s_input = null;
                ui.disposeCmdLineDialog();
            }
        });
        ui.showCmdLineDialog(dlg);
        if (s_input == null) {
            throw new CmdAbortedException();
        }
        return (Double)s_input;
    }
}

