/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.kernel.Kernel;
import cib.util.CoordSpace;
import cib.util.cmd.CmdAbortedException;
import cib.util.dxf.Attributes;
import cib.util.dxf.GroupCode;

public class ImportLType {
    public static String create(Kernel krnl, Attributes atts, double linetypeScale) throws CmdAbortedException {
        Database db = krnl.getDatabase();
        CoordSpace cs = db.getCoordSpace();
        double scale = cs.getScale();
        String linetypeName = atts.getValue(GroupCode.GC2);
        double[] linetype = null;
        AttributeManager atm = AttributeManager.getAttributeManager();
        if (!atm.containsLinePattern(linetypeName)) {
            int n = atts.getIntValue(GroupCode.GC73, 0);
            double patternScale = atts.getDoubleValue(GroupCode.GC46, 1.0);
            patternScale *= linetypeScale;
            linetype = new double[n];
            int i = 0;
            while (i < n) {
                double dashLength = atts.getDoubleValue(i, GroupCode.GC49);
                int complexElement = atts.getIntValue(i, GroupCode.GC74, 0);
                if (complexElement != 0) {
                    linetype = null;
                    break;
                }
                linetype[i] = Math.abs(dashLength) * patternScale * cs.getMillimetersPerNaturalUnit() / scale;
                ++i;
            }
            try {
                atm.addLinePattern(linetypeName, linetype);
            }
            catch (IllegalArgumentException e) {
                atm.addLinePattern(linetypeName, null);
            }
        }
        return linetype == null ? "DEFAULT" : linetypeName;
    }
}

