/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.Database;
import cib.cad.db.att.Attributes;
import cib.cad.db.layer.Layer;
import cib.cad.db.layer.LayerSet;
import cib.cad.ext.dxf.ImportAttributes;
import cib.cad.kernel.Kernel;
import cib.util.NameSpace;
import cib.util.cmd.CmdAbortedException;
import cib.util.dxf.GroupCode;

public class ImportLayer {
    public static String create(Kernel krnl, cib.util.dxf.Attributes atts) throws CmdAbortedException {
        Database db = krnl.getDatabase();
        NameSpace ns = db.getNameSpace();
        String layerName = atts.getValue(GroupCode.GC2);
        Attributes at = new Attributes();
        String lineweightName = ImportAttributes.lineweightName(atts, true);
        at.setLineWidth(lineweightName != null ? lineweightName : "DEFAULT");
        String linetypeName = ImportAttributes.linetypeName(atts);
        at.setLinePattern(linetypeName != null ? linetypeName : "DEFAULT");
        String colorName = ImportAttributes.colorName(atts, true);
        at.setDrawPaint(colorName != null ? colorName : "DEFAULT");
        int colorNumber = atts.getIntValue(GroupCode.GC62, 0);
        String visibilityName = ImportAttributes.visibilityName(colorNumber >= 0, true);
        at.setVisibility(visibilityName != null ? visibilityName : "DEFAULT");
        at.setFillPaint("DEFAULT");
        at.setFontFamily("DEFAULT");
        at.setTextSize("DEFAULT");
        at.setMutability("DEFAULT");
        Layer layer = null;
        if (ns.containsName(layerName)) {
            Object o = ns.getObject(layerName);
            if (o instanceof Layer) {
                layer = (Layer)o;
            }
            layerName = ns.generateName(layerName);
        }
        if (layer == null) {
            layer = new Layer();
            ns.put(layer, layerName);
        }
        layer.setAttributes(at);
        LayerSet layerSet = db.getLayerSet();
        layerSet.add(layer);
        return layerName;
    }
}

