/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.Database;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentText2D;
import cib.cad.ext.dxf.ImportText;
import cib.cad.kernel.Kernel;
import cib.util.CoordSpace;
import cib.util.dxf.GroupCode;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import java.util.Map;

public class ImportMText {
    public static Component create(Kernel krnl, cib.util.dxf.Attributes atts, Map<String, cib.util.dxf.Attributes> styles) {
        int justification;
        Database db = krnl.getDatabase();
        CoordSpace cs = db.getCoordSpace();
        double scale = cs.getScale();
        String text = "";
        int nAdditionalText = atts.getValueSize(GroupCode.GC3);
        int i = 0;
        while (i < nAdditionalText) {
            text = String.valueOf(text) + atts.getValue(i, GroupCode.GC3);
            ++i;
        }
        text = String.valueOf(text) + atts.getValue(GroupCode.GC1);
        text = text.replace("\\P", "\n");
        text = ImportText.replaceCtrlSequences(text);
        double encodedScale = ImportText.getEncodedScale(text);
        text = ImportText.removeBackslashSequences(text);
        AttributedString as = new AttributedString(text);
        double x = atts.getDoubleValue(GroupCode.GC10);
        double y = atts.getDoubleValue(GroupCode.GC20);
        double xx = atts.getDoubleValue(GroupCode.GC11, 1.0);
        double xy = atts.getDoubleValue(GroupCode.GC21, 0.0);
        double angle = Math.atan2(xy, xx);
        AffineTransform at = AffineTransform.getTranslateInstance(x, y);
        at.rotate(angle += atts.getDoubleValue(GroupCode.GC50, 0.0));
        Attributes attr = new Attributes();
        double height = atts.getDoubleValue(GroupCode.GC40) * encodedScale;
        double paperHeightInMm = height * cs.getMillimetersPerNaturalUnit() / scale;
        String textSizeName = ImportText.findOrCreateTextSize(paperHeightInMm);
        attr.setTextSize(textSizeName);
        String textStyle = atts.getValue(GroupCode.GC7, "STANDARD");
        cib.util.dxf.Attributes fontAttributes = styles.get(textStyle);
        String fontFamilyName = "DEFAULT";
        if (fontAttributes != null) {
            fontFamilyName = fontAttributes.getValue(GroupCode.GC2, "DEFAULT");
        }
        attr.setFontFamily(fontFamilyName);
        ComponentText2D comp = new ComponentText2D(as, at);
        comp.setAttributes(attr);
        int attachmentPoint = atts.getIntValue(GroupCode.GC71, 1);
        switch (attachmentPoint) {
            case 1: {
                justification = 2;
                break;
            }
            case 2: {
                justification = 5;
                break;
            }
            case 3: {
                justification = 8;
                break;
            }
            case 4: {
                justification = 1;
                break;
            }
            case 5: {
                justification = 4;
                break;
            }
            case 6: {
                justification = 7;
                break;
            }
            case 7: {
                justification = 9;
                break;
            }
            case 8: {
                justification = 10;
                break;
            }
            case 9: {
                justification = 11;
                break;
            }
            default: {
                justification = 2;
            }
        }
        comp.setJustification(justification);
        return comp;
    }
}

