/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.Group;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import java.util.HashSet;
import java.util.Set;

public class CloseGroup
implements Cmd {
    private Group m_group = null;
    private Set<Component> m_selSet = new HashSet<Component>();

    public static boolean isDoable() {
        Kernel krnl = Kernel.getInstance();
        return krnl.getOpenGroupCount() > 0;
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        this.m_group = krnl.getOpenGroup();
        if (this.m_group == null) {
            return;
        }
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        this.m_selSet.addAll(selSet);
        krnl.closeGroup();
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        if (this.m_group != null) {
            Kernel krnl = (Kernel)context;
            krnl.openGroup(this.m_group, false);
            Database db = krnl.getDatabase();
            ObservableSet<Component> selSet = db.getSelectSet();
            selSet.clear();
            selSet.addAll(this.m_selSet);
        }
    }

    @Override
    public void redoCmd(Object context) {
        if (this.m_group != null) {
            Kernel krnl = (Kernel)context;
            krnl.closeGroup();
        }
    }

    @Override
    public boolean changesState() {
        return this.m_group != null;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    public String toString() {
        return Messages.getString("ext.mod.CloseGroup.0");
    }
}

