/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.db.Database;
import cib.cad.db.MarkerMap;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.ext.mod.Mod;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.UndoableCmd;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.kernel.constr.Construction;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import cib.util.geo.Geo2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class Extend
extends UndoableCmd {
    protected int m_controlPointsExtended = 0;
    private transient Object m_input = null;

    public static boolean isDoable() {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        double[] crds = new double[8];
        for (Component comp : selSet) {
            if (!mm.hasMarkedPrimitives(comp, 2) || !(comp instanceof CtrlSegments)) continue;
            CtrlSegments ctrlSeg = (CtrlSegments)comp;
            NamedListIterator<Point2D> pit = comp.controlPointIterator();
            while (pit.hasNext()) {
                pit.next();
                int index = pit.previousIndex();
                int name = pit.previousName();
                if (!mm.primitiveMarked(comp, 2, index) || ctrlSeg.getCtrlType(name) != 2) continue;
                int nUsableSegs = 0;
                int nSegs = ctrlSeg.getVertexSegmentCount(name);
                int iSeg = 0;
                while (iSeg < nSegs) {
                    int segName = ctrlSeg.getVertexSegmentAt(name, iSeg);
                    int segType = ctrlSeg.getSegmentCrds(segName, crds);
                    if (segType != 4 && segType != 128) {
                        ++nUsableSegs;
                    }
                    ++iSeg;
                }
                if (nUsableSegs != true) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        final Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setUniqueName("ext.mod.Extend-menu0");
        dlg.enableTextInput(true);
        dlg.enableDigitize(-1);
        dlg.setPrompt(this._isExtending() ? Messages.getString("ext.mod.Extend.0") : Messages.getString("ext.mod.Extend.1"));
        dlg.setPromptHints(Messages.getString("ext.mod.Extend.2"));
        dlg.addChoice("By distance");
        dlg.setChoiceChecked(dlg.addChoice("To point"));
        dlg.addChoice("To line");
        dlg.addChoice("To circle");
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void textEntered(String text) {
                Extend.this.m_input = new Integer(0);
                krnl.pushBackArguments(new CmdLineToken[]{new TextToken(text)});
                ui.disposeCmdLineDialog();
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                Extend.this.m_input = new Integer(1);
                krnl.pushBackArguments(new CmdLineToken[]{new DigitizeToken(x, y, gp.getId())});
                ui.disposeCmdLineDialog();
            }

            @Override
            public void choiceSelected(int iChoice) {
                Extend.this.m_input = iChoice;
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                Extend.this.m_input = new CmdAbortedException();
                ui.disposeCmdLineDialog();
            }
        });
        ConPoint2D conPoint = new ConPoint2D(krnl);
        conPoint.setDigitizeCursor(true);
        ui.showCmdLineDialog(dlg);
        conPoint.setDigitizeCursor(false);
        if (this.m_input instanceof CmdAbortedException) {
            throw (CmdAbortedException)this.m_input;
        }
        Construction con = Construction.getConstruction(krnl);
        Serializable extensionGeometry = null;
        if (this.m_input instanceof Integer) {
            int iChoice = (Integer)this.m_input;
            if (iChoice == 0) {
                double dist = con.distance2D(this._isExtending() ? Messages.getString("ext.mod.Extend.7") : Messages.getString("ext.mod.Extend.8"));
                if (!this._isExtending()) {
                    dist = -dist;
                }
                extensionGeometry = new Double(dist);
            } else if (iChoice == 1) {
                Point2D.Double pnt = new Point2D.Double();
                con.point2D(this._isExtending() ? Messages.getString("ext.mod.Extend.9") : Messages.getString("ext.mod.Extend.10"), pnt);
                extensionGeometry = pnt;
            } else if (iChoice == 2) {
                Line2D.Double line = new Line2D.Double();
                con.line2D(this._isExtending() ? Messages.getString("ext.mod.Extend.11") : Messages.getString("ext.mod.Extend.12"), line);
                extensionGeometry = line;
            } else if (iChoice == 3) {
                Ellipse2D.Double ell = new Ellipse2D.Double();
                con.circle2D(this._isExtending() ? Messages.getString("ext.mod.Extend.13") : Messages.getString("ext.mod.Extend.14"), ell);
                extensionGeometry = ell;
            }
        } else {
            throw new InternalError();
        }
        this.m_controlPointsExtended = this._apply(extensionGeometry);
        if (this.m_controlPointsExtended == 0) {
            System.err.println(this._isExtending() ? Messages.getString("ext.mod.Extend.15") : Messages.getString("ext.mod.Extend.16"));
            return;
        }
        System.out.println(this);
    }

    public String toString() {
        return String.valueOf(Messages.getString("ext.mod.Extend.17")) + this.m_controlPointsExtended + Messages.getString("ext.mod.Extend.18");
    }

    protected boolean _isExtending() {
        return true;
    }

    private int _apply(Object extGeometry) {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        int controlPointsExtended = 0;
        for (Component comp : selSet) {
            if (!(comp instanceof CtrlSegments) || !mm.hasMarkedPrimitives(comp, 2)) continue;
            comp.setControlPointStarts();
            CtrlSegments ctrlSegments = (CtrlSegments)comp;
            try {
                NamedListIterator<Point2D> pit = comp.controlPointIterator();
                while (pit.hasNext()) {
                    int segType;
                    int segName;
                    pit.next();
                    int index = pit.previousIndex();
                    int name = pit.previousName();
                    if (!mm.primitiveMarked(comp, 2, index)) continue;
                    double[] crds = new double[8];
                    int type = ctrlSegments.getCtrlType(name);
                    if (type != 2) continue;
                    int nSegs = ctrlSegments.getVertexSegmentCount(name);
                    int nUsableSegs = 0;
                    int iSeg = 0;
                    while (iSeg < nSegs) {
                        segName = ctrlSegments.getVertexSegmentAt(name, iSeg);
                        segType = ctrlSegments.getSegmentCrds(segName, crds);
                        if (segType != 4 && segType != 128) {
                            ++nUsableSegs;
                        }
                        ++iSeg;
                    }
                    if (nUsableSegs != 1) {
                        System.out.println(Messages.getString("ext.mod.Extend.19"));
                        continue;
                    }
                    iSeg = 0;
                    while (iSeg < nSegs) {
                        segName = ctrlSegments.getVertexSegmentAt(name, iSeg);
                        segType = ctrlSegments.getSegmentCrds(segName, crds);
                        if (segType != 4 && segType != 128) {
                            double ext2;
                            if (name == ctrlSegments.getSegmentVertex1(segName)) {
                                double ext1 = Extend.calculateStartExtent(segType, crds, extGeometry, this._isExtending());
                                if (this._checkDistSign(ext1)) {
                                    if (!this._hasSavedObjectState(comp)) {
                                        this._saveObjectState(comp);
                                    }
                                    Mod.extendBy(segType, crds, ext1, 0.0);
                                    ++controlPointsExtended;
                                }
                            } else if (name == ctrlSegments.getSegmentVertex2(segName) && this._checkDistSign(ext2 = Extend.calculateEndExtent(segType, crds, extGeometry, this._isExtending()))) {
                                if (!this._hasSavedObjectState(comp)) {
                                    this._saveObjectState(comp);
                                }
                                Mod.extendBy(segType, crds, 0.0, ext2);
                                ++controlPointsExtended;
                            }
                            ctrlSegments.setSegmentCrds(segName, crds);
                        }
                        ++iSeg;
                    }
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            comp.setControlPointEnds();
        }
        return controlPointsExtended;
    }

    private boolean _checkDistSign(double d) {
        if (Double.isNaN(d)) {
            return false;
        }
        if (this._isExtending()) {
            return d > Geo2D.getEps();
        }
        return d < -Geo2D.getEps();
    }

    private static double calculateStartExtent(int type, double[] crds, Object geo, boolean ext) {
        if (geo instanceof Double) {
            return (Double)geo;
        }
        if (geo instanceof Point2D) {
            return Mod.calculateStartExtent(type, crds, (Point2D)geo, ext);
        }
        if (geo instanceof Line2D) {
            return Mod.calculateStartExtent(type, crds, (Line2D)geo, ext);
        }
        if (geo instanceof Ellipse2D) {
            return Mod.calculateStartExtent(type, crds, (Ellipse2D)geo, ext);
        }
        throw new IllegalArgumentException();
    }

    private static double calculateEndExtent(int type, double[] crds, Object geo, boolean ext) {
        if (geo instanceof Double) {
            return (Double)geo;
        }
        if (geo instanceof Point2D) {
            return Mod.calculateEndExtent(type, crds, (Point2D)geo, ext);
        }
        if (geo instanceof Line2D) {
            return Mod.calculateEndExtent(type, crds, (Line2D)geo, ext);
        }
        if (geo instanceof Ellipse2D) {
            return Mod.calculateEndExtent(type, crds, (Ellipse2D)geo, ext);
        }
        throw new IllegalArgumentException();
    }
}

