/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.lang.Messages;
import cib.util.geo.Geo2D;
import cib.util.geo.NoIntersectionException;
import cib.util.geo.NullVectorException;
import cib.util.geo.Vector2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;

public class Mod {
    public static boolean extendBy(int type, double[] crds, double ext1, double ext2) {
        if (Math.abs(ext1) < Geo2D.getEps() && Math.abs(ext2) < Geo2D.getEps()) {
            return true;
        }
        switch (type) {
            case 8: {
                Line2D.Double line = new Line2D.Double(crds[0], crds[1], crds[2], crds[3]);
                if (!Mod.extendBy(line, ext1, ext2)) {
                    return false;
                }
                crds[0] = ((Line2D)line).getX1();
                crds[1] = ((Line2D)line).getY1();
                crds[2] = ((Line2D)line).getX2();
                crds[3] = ((Line2D)line).getY2();
                return true;
            }
            case 64: {
                Point2D.Double sp = new Point2D.Double(crds[0], crds[1]);
                Point2D.Double ap = new Point2D.Double(crds[2], crds[3]);
                Point2D.Double ep = new Point2D.Double(crds[4], crds[5]);
                if (!Mod.extendBy(sp, ap, ep, ext1, ext2)) {
                    return false;
                }
                crds[0] = ((Point2D)sp).getX();
                crds[1] = ((Point2D)sp).getY();
                crds[2] = ((Point2D)ap).getX();
                crds[3] = ((Point2D)ap).getY();
                crds[4] = ((Point2D)ep).getX();
                crds[5] = ((Point2D)ep).getY();
                return true;
            }
            case 16: {
                Line2D.Double lineP1P2 = new Line2D.Double(crds[0], crds[1], crds[4], crds[5]);
                if (!Mod.extendBy(lineP1P2, ext1, ext2)) {
                    return false;
                }
                crds[0] = ((Line2D)lineP1P2).getX1();
                crds[1] = ((Line2D)lineP1P2).getY1();
                crds[4] = ((Line2D)lineP1P2).getX2();
                crds[5] = ((Line2D)lineP1P2).getY2();
                return true;
            }
            case 32: {
                Line2D.Double lineP1P2 = new Line2D.Double(crds[0], crds[1], crds[6], crds[7]);
                if (!Mod.extendBy(lineP1P2, ext1, ext2)) {
                    return false;
                }
                crds[0] = ((Line2D)lineP1P2).getX1();
                crds[1] = ((Line2D)lineP1P2).getY1();
                crds[6] = ((Line2D)lineP1P2).getX2();
                crds[7] = ((Line2D)lineP1P2).getY2();
                return true;
            }
        }
        throw new InternalError(String.valueOf(Messages.getString("ext.mod.Mod.0")) + type);
    }

    public static double calculateStartExtent(int type, double[] crds, Point2D p, boolean close) {
        if (Geo2D.equality(crds[0], crds[1], p.getX(), p.getY())) {
            return 0.0;
        }
        switch (type) {
            case 8: {
                return Mod.calculateStartExtent(new Line2D.Double(crds[0], crds[1], crds[2], crds[3]), p);
            }
            case 64: {
                return Mod.calculateStartExtent(new Point2D.Double(crds[0], crds[1]), new Point2D.Double(crds[2], crds[3]), new Point2D.Double(crds[4], crds[5]), p, close);
            }
            case 16: {
                return Mod.calculateStartExtent(new Line2D.Double(crds[0], crds[1], crds[4], crds[5]), p);
            }
            case 32: {
                return Mod.calculateStartExtent(new Line2D.Double(crds[0], crds[1], crds[6], crds[7]), p);
            }
        }
        throw new InternalError(String.valueOf(Messages.getString("ext.mod.Mod.1")) + type);
    }

    public static double calculateEndExtent(int type, double[] crds, Point2D p, boolean close) {
        double[] _crds = new double[8];
        switch (type) {
            case 8: {
                _crds[0] = crds[2];
                _crds[1] = crds[3];
                _crds[2] = crds[0];
                _crds[3] = crds[1];
                break;
            }
            case 16: 
            case 64: {
                _crds[0] = crds[4];
                _crds[1] = crds[5];
                _crds[2] = crds[2];
                _crds[3] = crds[3];
                _crds[4] = crds[0];
                _crds[5] = crds[1];
                break;
            }
            case 32: {
                _crds[0] = crds[6];
                _crds[1] = crds[7];
                _crds[2] = crds[4];
                _crds[3] = crds[5];
                _crds[4] = crds[2];
                _crds[5] = crds[3];
                _crds[6] = crds[0];
                _crds[7] = crds[1];
                break;
            }
            default: {
                throw new InternalError(String.valueOf(Messages.getString("ext.mod.Mod.2")) + type);
            }
        }
        return Mod.calculateStartExtent(type, _crds, p, close);
    }

    public static double calculateStartExtent(int type, double[] crds, Line2D l, boolean ext) {
        try {
            switch (type) {
                case 8: {
                    return Mod.signedDist((Line2D)new Line2D.Double(crds[0], crds[1], crds[2], crds[3]), l, ext);
                }
                case 64: {
                    Point2D.Double sp = new Point2D.Double(crds[0], crds[1]);
                    Point2D.Double ap = new Point2D.Double(crds[2], crds[3]);
                    Point2D.Double ep = new Point2D.Double(crds[4], crds[5]);
                    return Mod.signedDist((Point2D)sp, (Point2D)ap, (Point2D)ep, l, ext);
                }
                case 16: {
                    return Mod.signedDist((Line2D)new Line2D.Double(crds[0], crds[1], crds[4], crds[5]), l, ext);
                }
                case 32: {
                    return Mod.signedDist((Line2D)new Line2D.Double(crds[0], crds[1], crds[6], crds[7]), l, ext);
                }
            }
            throw new InternalError(String.valueOf(Messages.getString("ext.mod.Mod.3")) + type);
        }
        catch (NoIntersectionException e) {
            return Double.NaN;
        }
    }

    public static double calculateEndExtent(int type, double[] crds, Line2D l, boolean ext) {
        double[] _crds = new double[8];
        switch (type) {
            case 8: {
                _crds[0] = crds[2];
                _crds[1] = crds[3];
                _crds[2] = crds[0];
                _crds[3] = crds[1];
                break;
            }
            case 16: 
            case 64: {
                _crds[0] = crds[4];
                _crds[1] = crds[5];
                _crds[2] = crds[2];
                _crds[3] = crds[3];
                _crds[4] = crds[0];
                _crds[5] = crds[1];
                break;
            }
            case 32: {
                _crds[0] = crds[6];
                _crds[1] = crds[7];
                _crds[2] = crds[4];
                _crds[3] = crds[5];
                _crds[4] = crds[2];
                _crds[5] = crds[3];
                _crds[6] = crds[0];
                _crds[7] = crds[1];
                break;
            }
            default: {
                throw new InternalError(String.valueOf(Messages.getString("ext.mod.Mod.4")) + type);
            }
        }
        return Mod.calculateStartExtent(type, _crds, l, ext);
    }

    public static double calculateStartExtent(int type, double[] crds, Ellipse2D e, boolean ext) {
        try {
            switch (type) {
                case 8: {
                    return Mod.signedDist((Line2D)new Line2D.Double(crds[0], crds[1], crds[2], crds[3]), e, ext);
                }
                case 64: {
                    Point2D.Double sp = new Point2D.Double(crds[0], crds[1]);
                    Point2D.Double ap = new Point2D.Double(crds[2], crds[3]);
                    Point2D.Double ep = new Point2D.Double(crds[4], crds[5]);
                    return Mod.signedDist((Point2D)sp, (Point2D)ap, (Point2D)ep, e, ext);
                }
                case 16: {
                    return Mod.signedDist((Line2D)new Line2D.Double(crds[0], crds[1], crds[4], crds[5]), e, ext);
                }
                case 32: {
                    return Mod.signedDist((Line2D)new Line2D.Double(crds[0], crds[1], crds[6], crds[7]), e, ext);
                }
            }
            throw new InternalError(String.valueOf(Messages.getString("ext.mod.Mod.5")) + type);
        }
        catch (NoIntersectionException x) {
            return Double.NaN;
        }
    }

    public static double calculateEndExtent(int type, double[] crds, Ellipse2D e, boolean ext) {
        double[] _crds = new double[8];
        switch (type) {
            case 8: {
                _crds[0] = crds[2];
                _crds[1] = crds[3];
                _crds[2] = crds[0];
                _crds[3] = crds[1];
                break;
            }
            case 16: 
            case 64: {
                _crds[0] = crds[4];
                _crds[1] = crds[5];
                _crds[2] = crds[2];
                _crds[3] = crds[3];
                _crds[4] = crds[0];
                _crds[5] = crds[1];
                break;
            }
            case 32: {
                _crds[0] = crds[6];
                _crds[1] = crds[7];
                _crds[2] = crds[4];
                _crds[3] = crds[5];
                _crds[4] = crds[2];
                _crds[5] = crds[3];
                _crds[6] = crds[0];
                _crds[7] = crds[1];
                break;
            }
            default: {
                throw new InternalError(String.valueOf(Messages.getString("ext.mod.Mod.6")) + type);
            }
        }
        return Mod.calculateStartExtent(type, _crds, e, ext);
    }

    public static Point2D getStartPoint(int type, double[] crds) {
        switch (type) {
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                return new Point2D.Double(crds[0], crds[1]);
            }
        }
        throw new InternalError(String.valueOf(Messages.getString("ext.mod.Mod.7")) + type);
    }

    public static Point2D getEndPoint(int type, double[] crds) {
        switch (type) {
            case 8: {
                return new Point2D.Double(crds[2], crds[3]);
            }
            case 16: 
            case 64: {
                return new Point2D.Double(crds[4], crds[5]);
            }
            case 32: {
                return new Point2D.Double(crds[6], crds[7]);
            }
        }
        throw new InternalError(String.valueOf(Messages.getString("ext.mod.Mod.8")) + type);
    }

    private static double signedDist(Line2D lineSeg, Line2D toLine, boolean ext) {
        HashSet<Point2D> pnts = new HashSet<Point2D>();
        if (Geo2D.containment(lineSeg, true, toLine.getP1())) {
            pnts.add(toLine.getP1());
        }
        if (Geo2D.containment(lineSeg, true, toLine.getP2())) {
            pnts.add(toLine.getP2());
        }
        try {
            pnts.add(Geo2D.intersection(lineSeg, true, toLine, true, new Point2D.Double()));
        }
        catch (NoIntersectionException noIntersectionException) {
            // empty catch block
        }
        Iterator it = pnts.iterator();
        double dist = Double.POSITIVE_INFINITY;
        while (it.hasNext()) {
            double _dist = Mod.calculateStartExtent(lineSeg, (Point2D)it.next());
            if (!(!Double.isNaN(_dist) && ext && _dist > Geo2D.getEps()) && (ext || !(_dist < -Geo2D.getEps()))) continue;
            dist = Math.min(dist, Math.abs(_dist));
        }
        if (Double.isInfinite(dist)) {
            return Double.NaN;
        }
        return ext ? dist : -dist;
    }

    private static double signedDist(Line2D lineSeg, Ellipse2D toEllipse, boolean ext) {
        double dist;
        block4: {
            try {
                Iterator<Point2D> it = Geo2D.intersection(lineSeg, true, toEllipse);
                dist = Double.POSITIVE_INFINITY;
                while (it.hasNext()) {
                    double _dist = Mod.calculateStartExtent(lineSeg, it.next());
                    if (!(!Double.isNaN(_dist) && ext && _dist > Geo2D.getEps()) && (ext || !(_dist < -Geo2D.getEps()))) continue;
                    dist = Math.min(dist, Math.abs(_dist));
                }
                if (!Double.isInfinite(dist)) break block4;
                return Double.NaN;
            }
            catch (NoIntersectionException x) {
                return Double.NaN;
            }
        }
        return ext ? dist : -dist;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static double signedDist(Point2D sp, Point2D ap, Point2D ep, Line2D toLine, boolean ext) {
        double dist;
        block4: {
            try {
                Ellipse2D ell = Geo2D.calculateEllipse2D(sp, ap, ep, new Ellipse2D.Double());
                if (ell == null) return Mod.signedDist((Line2D)new Line2D.Double(sp, ep), toLine, ext);
                Iterator<Point2D> it = Geo2D.intersection(toLine, true, ell);
                dist = Double.POSITIVE_INFINITY;
                while (it.hasNext()) {
                    double _dist = Mod.calculateStartExtent(sp, ap, ep, it.next(), ext);
                    if (!(!Double.isNaN(_dist) && ext && _dist > Geo2D.getEps()) && (ext || !(_dist < -Geo2D.getEps()))) continue;
                    dist = Math.min(dist, Math.abs(_dist));
                }
                if (!Double.isInfinite(dist)) break block4;
                return Double.NaN;
            }
            catch (NoIntersectionException x) {
                return Double.NaN;
            }
        }
        return ext ? dist : -dist;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static double signedDist(Point2D sp, Point2D ap, Point2D ep, Ellipse2D toEllipse, boolean ext) {
        double dist;
        block4: {
            try {
                Ellipse2D ellSeg = Geo2D.calculateEllipse2D(sp, ap, ep, new Ellipse2D.Double());
                if (ellSeg == null) return Mod.signedDist((Line2D)new Line2D.Double(sp, ep), toEllipse, ext);
                Iterator<Point2D> it = Geo2D.intersection(ellSeg, toEllipse);
                dist = Double.POSITIVE_INFINITY;
                while (it.hasNext()) {
                    double _dist = Mod.calculateStartExtent(sp, ap, ep, it.next(), ext);
                    if (!(!Double.isNaN(_dist) && ext && _dist > Geo2D.getEps()) && (ext || !(_dist < -Geo2D.getEps()))) continue;
                    dist = Math.min(dist, Math.abs(_dist));
                }
                if (!Double.isInfinite(dist)) break block4;
                return Double.NaN;
            }
            catch (NoIntersectionException x) {
                return Double.NaN;
            }
        }
        return ext ? dist : -dist;
    }

    private static boolean extendBy(Line2D line, double ext1, double ext2) {
        if (Math.abs(ext1) < Geo2D.getEps() && Math.abs(ext2) < Geo2D.getEps()) {
            return true;
        }
        double len = Geo2D.length(line);
        if (len > Geo2D.getEps() && len + ext1 + ext2 > -Geo2D.getEps()) {
            Point2D p1 = line.getP1();
            Point2D p2 = line.getP2();
            Vector2D v = new Vector2D(p1, p2);
            v.normalize();
            p1.setLocation(p1.getX() - v.x * ext1, p1.getY() - v.y * ext1);
            p2.setLocation(p2.getX() + v.x * ext2, p2.getY() + v.y * ext2);
            line.setLine(p1, p2);
            return true;
        }
        return false;
    }

    private static double calculateStartExtent(Line2D line, Point2D p) {
        double signedDist;
        block4: {
            if (Geo2D.equality(line.getP1(), p)) {
                return 0.0;
            }
            try {
                Point2D extPnt = line.getP1();
                Vector2D extVec = new Vector2D(line.getP2(), line.getP1()).normalize();
                Vector2D vec = new Vector2D(extPnt, p);
                signedDist = vec.getScalarProduct(extVec);
                if (!(Geo2D.length(line) + signedDist < -Geo2D.getEps())) break block4;
                return Double.NaN;
            }
            catch (NullVectorException e) {
                return Double.NaN;
            }
        }
        return signedDist;
    }

    private static boolean extendBy(Point2D sp, Point2D ap, Point2D ep, double ext1, double ext2) {
        if (Math.abs(ext1) < Geo2D.getEps() && Math.abs(ext2) < Geo2D.getEps()) {
            return true;
        }
        Arc2D arc = Geo2D.calculateArc2D(sp, ap, ep, new Arc2D.Double());
        if (arc != null) {
            double r = 0.5 * arc.getWidth();
            if (Double.isNaN(r) || r < Geo2D.getEps()) {
                return false;
            }
            double startAngleExtent = ext1 / r;
            double endAngleExtent = ext2 / r;
            double sweepAngle = -Math.toRadians(arc.getAngleExtent());
            Point2D.Double cp = new Point2D.Double(arc.getCenterX(), arc.getCenterY());
            double newAbsSweepAngle = Math.abs(sweepAngle) + startAngleExtent + endAngleExtent;
            if (newAbsSweepAngle >= -Geo2D.getEps() && newAbsSweepAngle <= Math.PI * 2 + Geo2D.getEps()) {
                Vector2D cpsp = new Vector2D(cp, sp);
                double spAngle = -Math.signum(sweepAngle) * startAngleExtent;
                cpsp.rotate(spAngle);
                sp.setLocation(((Point2D)cp).getX() + cpsp.x, ((Point2D)cp).getY() + cpsp.y);
                Vector2D cpep = new Vector2D(cp, ep);
                double epAngle = Math.signum(sweepAngle) * endAngleExtent;
                cpep.rotate(epAngle);
                ep.setLocation(((Point2D)cp).getX() + cpep.x, ((Point2D)cp).getY() + cpep.y);
                Vector2D cpap = new Vector2D(cp, ap);
                double apAngle = 0.5 * (spAngle + epAngle);
                cpap.rotate(apAngle);
                ap.setLocation(((Point2D)cp).getX() + cpap.x, ((Point2D)cp).getY() + cpap.y);
                return true;
            }
        } else {
            double len = Geo2D.distance(sp, ep);
            if (len > Geo2D.getEps() && len + ext1 + ext2 > -Geo2D.getEps()) {
                Vector2D v = new Vector2D(sp, ep);
                v.normalize();
                sp.setLocation(sp.getX() - v.x * ext1, sp.getY() - v.y * ext1);
                ep.setLocation(ep.getX() + v.x * ext2, ep.getY() + v.y * ext2);
                ap.setLocation(0.5 * (sp.getX() + ep.getX()), 0.5 * (sp.getY() + ep.getY()));
                return true;
            }
        }
        return false;
    }

    private static double calculateStartExtent(Point2D sp, Point2D ap, Point2D ep, Point2D p, boolean ext) {
        if (Geo2D.equality(sp, p)) {
            return 0.0;
        }
        Arc2D arc = Geo2D.calculateArc2D(sp, ap, ep, new Arc2D.Double());
        if (arc != null) {
            double sweepAngle = -Math.toRadians(arc.getAngleExtent());
            double r = 0.5 * arc.getWidth();
            Vector2D radVec = new Vector2D(arc.getCenterX(), arc.getCenterY(), p.getX(), p.getY());
            if (Geo2D.isNull(radVec)) {
                return Double.NaN;
            }
            radVec.normalize().scaleBy(r);
            radVec.add(arc.getCenterX(), arc.getCenterY());
            if (Geo2D.equality(ep, (Point2D)radVec)) {
                return ext ? r * (Math.PI * 2 - Math.abs(sweepAngle)) : -r * Math.abs(sweepAngle);
            }
            Point2D.Double cp = new Point2D.Double(arc.getCenterX(), arc.getCenterY());
            Vector2D cpsp = new Vector2D(cp, sp);
            Vector2D cpp = new Vector2D(cp, p);
            if (Geo2D.isNull(cpsp) || Geo2D.isNull(cpp)) {
                return Double.NaN;
            }
            double angCCW = cpsp.getAngleCCW(cpp);
            double angle = sweepAngle < 0.0 ? (angCCW - sweepAngle + Geo2D.getEps() > Math.PI * 2 ? -(Math.PI * 2 - angCCW) : angCCW) : (sweepAngle - angCCW > Geo2D.getEps() ? -angCCW : Math.PI * 2 - angCCW);
            return r * angle;
        }
        return Mod.calculateStartExtent(new Line2D.Double(sp, ep), p);
    }
}

