/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentGroup;
import cib.cad.db.comp.Group;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;

public class NewGroup
implements Cmd {
    private Group m_group = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        this.m_group = new ComponentGroup(2);
        cmpSet.add(this.m_group);
        krnl.openGroup(this.m_group, false);
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        if (this.m_group != null) {
            krnl.closeGroup();
            Database db = krnl.getDatabase();
            ObservableSet<Component> cmpSet = db.getComponentSet();
            cmpSet.remove(this.m_group);
        }
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        if (this.m_group != null) {
            Database db = krnl.getDatabase();
            ObservableSet<Component> cmpSet = db.getComponentSet();
            cmpSet.add(this.m_group);
            krnl.openGroup(this.m_group, false);
        }
    }

    @Override
    public boolean changesState() {
        return this.m_group != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return Messages.getString("ext.mod.NewGroup.0");
    }
}

