/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel;

import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.InterruptToken;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.WindowToken;
import cib.cad.kernel.interpreter.CmdLineInterpreter;
import cib.cad.kernel.interpreter.ParseException;
import cib.cad.kernel.interpreter.TokenInterpreter;
import cib.cad.kernel.interpreter.TokenMgrError;
import cib.util.ExtendedMouseAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class MouseStroke
extends ExtendedMouseAdapter
implements MouseWheelListener {
    private Kernel m_krnl = null;
    private Map<JPanel, Graphics> m_panelToGfx = new HashMap<JPanel, Graphics>();
    private List<List<MouseEvent>> m_stroke = new ArrayList<List<MouseEvent>>();
    private boolean m_disabled = true;
    private boolean m_isStroking = false;
    private int m_lastEvent = -1;
    private Set<Listener> m_listeners = new HashSet<Listener>();
    private GlassPane m_glassPane = new GlassPane();
    public static int LEFT_BUTTON = -1;
    public static int MIDDLE_BUTTON = 0;
    public static int RIGHT_BUTTON = 1;
    public static int UNSUPPORTED_BUTTON = 2;

    public boolean addListener(Listener l) {
        return this.m_listeners.add(l);
    }

    public boolean removeListener(Listener l) {
        return this.m_listeners.remove(l);
    }

    public MouseStroke(Kernel krnl) {
        super(1);
        this.m_krnl = krnl;
        UserInterface ui = this.m_krnl.getUserInterface();
        JFrame frame = (JFrame)((Object)ui);
        frame.setGlassPane(this.m_glassPane);
        GlassPaneMouseListener mmil = new GlassPaneMouseListener(this.m_glassPane, frame.getContentPane());
        this.m_glassPane.addMouseListener(mmil);
        this.m_glassPane.addMouseMotionListener(mmil);
        this.m_glassPane.addMouseWheelListener(mmil);
    }

    public void setEnabled(boolean enable) {
        if (enable) {
            this._enable();
        } else {
            this._disable();
        }
    }

    private void _enable() {
        this._disable();
        this.m_disabled = false;
        UserInterface ui = this.m_krnl.getUserInterface();
        JFrame frame = (JFrame)((Object)ui);
        frame.setGlassPane(this.m_glassPane);
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            JPanel panel = (JPanel)((Object)gp);
            panel.addMouseListener(this.asMouseInputListener());
            panel.addMouseMotionListener(this.asMouseInputListener());
            panel.addMouseWheelListener(this);
            Graphics gfx = panel.getGraphics();
            gfx.setColor(panel.getForeground());
            gfx.setXORMode(panel.getBackground());
            this.m_panelToGfx.put(panel, gfx);
        }
    }

    private void _disable() {
        if (this.m_disabled) {
            return;
        }
        this.m_disabled = true;
        this._setGlassPaneVisible(false);
        UserInterface ui = this.m_krnl.getUserInterface();
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            JPanel panel = (JPanel)((Object)it.next());
            panel.removeMouseListener(this.asMouseInputListener());
            panel.removeMouseMotionListener(this.asMouseInputListener());
            panel.removeMouseWheelListener(this);
            Graphics gfx = this.m_panelToGfx.get(panel);
            if (gfx == null) continue;
            gfx.dispose();
        }
        this.m_stroke.clear();
        this.m_panelToGfx.clear();
    }

    public static int getLogicalMouseButton(MouseEvent e) {
        int modifiers = e.getModifiers();
        if ((modifiers & 0x10) != 0) {
            if (e.isAltDown()) {
                return MIDDLE_BUTTON;
            }
            if (e.isMetaDown()) {
                return RIGHT_BUTTON;
            }
            if (e.isControlDown()) {
                return RIGHT_BUTTON;
            }
            return LEFT_BUTTON;
        }
        if ((modifiers & 8) != 0) {
            return MIDDLE_BUTTON;
        }
        if ((modifiers & 4) != 0) {
            return RIGHT_BUTTON;
        }
        return UNSUPPORTED_BUTTON;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.m_lastEvent = 501;
        if (MouseStroke.getLogicalMouseButton(e) == RIGHT_BUTTON) {
            this._setStroking(true);
            ArrayList<MouseEvent> segment = new ArrayList<MouseEvent>();
            segment.add(e);
            this.m_stroke.add(segment);
            this._setGlassPaneVisible(true);
            return;
        }
    }

    @Override
    public void mouseHolding(MouseEvent e) {
        if (this._isStroking()) {
            this._setStroking(false);
            this.m_stroke.clear();
            this.m_panelToGfx.clear();
            this._setGlassPaneVisible(false);
        }
        String mouseButton = "";
        if (MouseStroke.getLogicalMouseButton(e) == LEFT_BUTTON) {
            mouseButton = "L";
        } else if (MouseStroke.getLogicalMouseButton(e) == MIDDLE_BUTTON) {
            mouseButton = "M";
        } else if (MouseStroke.getLogicalMouseButton(e) == RIGHT_BUTTON) {
            mouseButton = "R";
        } else {
            return;
        }
        ArrayList<MouseEvent> segment = new ArrayList<MouseEvent>();
        segment.add(e);
        this.m_stroke.add(segment);
        this.notifyListeners("MouseStroke-" + mouseButton + "H");
        this._setGlassPaneVisible(false);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int lastEvent = this.m_lastEvent;
        this.m_lastEvent = 506;
        if (this._isStroking()) {
            if (MouseStroke.getLogicalMouseButton(e) == RIGHT_BUTTON && this.m_stroke.size() > 0) {
                List<MouseEvent> segment = this.m_stroke.get(this.m_stroke.size() - 1);
                segment.add(e);
                this._setGlassPaneVisible(true);
            }
            return;
        }
        if (lastEvent != 501) {
            return;
        }
        String mouseButton = "";
        if (MouseStroke.getLogicalMouseButton(e) == LEFT_BUTTON) {
            mouseButton = "L";
        } else if (MouseStroke.getLogicalMouseButton(e) == MIDDLE_BUTTON) {
            mouseButton = "M";
        } else if (MouseStroke.getLogicalMouseButton(e) == RIGHT_BUTTON) {
            mouseButton = "R";
        } else {
            return;
        }
        ArrayList<MouseEvent> segment = new ArrayList<MouseEvent>();
        segment.add(e);
        this.m_stroke.add(segment);
        String code = "MouseStroke-" + mouseButton + "D";
        this.notifyListeners(code);
        this._setGlassPaneVisible(false);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.m_lastEvent = 502;
        if (this._isStroking()) {
            if (MouseStroke.getLogicalMouseButton(e) == RIGHT_BUTTON && this.m_stroke.size() > 0) {
                List<MouseEvent> segment = this.m_stroke.get(this.m_stroke.size() - 1);
                segment.add(e);
                this._setGlassPaneVisible(true);
            }
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.m_lastEvent = 500;
        if (this._isStroking()) {
            if (MouseStroke.getLogicalMouseButton(e) == LEFT_BUTTON) {
                ArrayList<MouseEvent> segment = new ArrayList<MouseEvent>();
                segment.add(e);
                this.m_stroke.add(segment);
                this._setStroking(false);
                String code = this.encode();
                if (e.isShiftDown()) {
                    code = String.valueOf(code) + "+SHFT";
                }
                if (e.isControlDown()) {
                    code = String.valueOf(code) + "+CTRL";
                }
                if (e.isAltDown()) {
                    code = String.valueOf(code) + "+ALT";
                }
                if (e.isMetaDown()) {
                    code = String.valueOf(code) + "+META";
                }
                this.notifyListeners(code);
                this._setGlassPaneVisible(false);
            }
            return;
        }
        String mouseButton = "";
        if (MouseStroke.getLogicalMouseButton(e) == LEFT_BUTTON) {
            mouseButton = "L";
        } else if (MouseStroke.getLogicalMouseButton(e) == MIDDLE_BUTTON) {
            mouseButton = "M";
        } else if (MouseStroke.getLogicalMouseButton(e) == RIGHT_BUTTON) {
            mouseButton = "R";
        } else {
            return;
        }
        this.m_stroke.clear();
        ArrayList<MouseEvent> segment = new ArrayList<MouseEvent>();
        segment.add(e);
        this.m_stroke.add(segment);
        String event = "MouseStroke-";
        int clickCount = e.getClickCount();
        if (clickCount == 0 || clickCount == 1) {
            event = String.valueOf(event) + mouseButton + "C";
        } else if (clickCount > 1) {
            event = String.valueOf(event) + mouseButton + clickCount;
        }
        if (e.isShiftDown()) {
            event = String.valueOf(event) + "+SHFT";
        }
        if (e.isControlDown()) {
            event = String.valueOf(event) + "+CTRL";
        }
        if (e.isAltDown()) {
            event = String.valueOf(event) + "+ALT";
        }
        if (e.isMetaDown()) {
            event = String.valueOf(event) + "+META";
        }
        this.notifyListeners(event);
        this._setGlassPaneVisible(false);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.m_lastEvent = 504;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.m_lastEvent = 505;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.m_lastEvent = 503;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.m_lastEvent = 507;
        if (this._isStroking()) {
            return;
        }
        ArrayList<MouseWheelEvent> segment = new ArrayList<MouseWheelEvent>();
        segment.add(e);
        this.m_stroke.add(segment);
        if (e.isControlDown()) {
            this.notifyListeners("MouseStroke-MW+CTRL");
        } else {
            this.notifyListeners("MouseStroke-MW");
        }
        this._setGlassPaneVisible(false);
    }

    private void _setStroking(boolean on) {
        if (on && !this.m_isStroking) {
            JFrame frame = (JFrame)((Object)this.m_krnl.getUserInterface());
            frame.setCursor(Cursor.getPredefinedCursor(12));
            this.m_stroke.clear();
        } else if (!on && this.m_isStroking) {
            JFrame frame = (JFrame)((Object)this.m_krnl.getUserInterface());
            frame.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.m_isStroking = on;
    }

    private boolean _isStroking() {
        return this.m_isStroking;
    }

    private String expandCommand(String cmd) {
        boolean isInterrupt;
        try {
            cmd = TokenInterpreter.getInterrupt(cmd);
            cmd = TextToken.literalToString(cmd);
            isInterrupt = true;
        }
        catch (IllegalArgumentException e) {
            isInterrupt = false;
        }
        final StringBuffer expCmd = new StringBuffer();
        CmdLineInterpreter interpreter = new CmdLineInterpreter(new StringReader(String.valueOf(cmd) + ";"));
        interpreter.addListener(new CmdLineInterpreter.Listener(){

            @Override
            public void parsingCommand(String cmdName) {
                expCmd.append(cmdName);
            }

            @Override
            public void parsingArgument(String arg) {
                expCmd.append(" " + MouseStroke.this.expandArg(arg));
            }

            @Override
            public void parsingEndOfCommand() {
                expCmd.append(";");
            }
        });
        try {
            interpreter.start();
        }
        catch (TokenMgrError e) {
            System.err.println(e);
        }
        catch (ParseException e) {
            System.err.println(e);
        }
        cmd = expCmd.toString();
        return isInterrupt ? new InterruptToken(cmd).toString() : cmd;
    }

    private String expandArg(String _arg) {
        int iSeg;
        String arg = _arg.toLowerCase();
        if (arg.startsWith("#strokestart")) {
            int iSeg2 = Integer.parseInt(arg.substring(12));
            if (iSeg2 < this.m_stroke.size()) {
                List<MouseEvent> seg = this.m_stroke.get(iSeg2);
                MouseEvent e = seg.get(0);
                DigitizeToken token = new DigitizeToken(e.getX(), e.getY(), ((GeometryPanel)((Object)e.getComponent())).getId());
                return token.toString();
            }
        } else if (arg.startsWith("#strokeend")) {
            int iSeg3 = Integer.parseInt(arg.substring(10));
            if (iSeg3 < this.m_stroke.size()) {
                List<MouseEvent> seg = this.m_stroke.get(iSeg3);
                MouseEvent e = seg.get(seg.size() - 1);
                DigitizeToken token = new DigitizeToken(e.getX(), e.getY(), ((GeometryPanel)((Object)e.getComponent())).getId());
                return token.toString();
            }
        } else if (arg.startsWith("#strokewin") && (iSeg = Integer.parseInt(arg.substring(10))) < this.m_stroke.size()) {
            List<MouseEvent> seg = this.m_stroke.get(iSeg);
            MouseEvent e = seg.get(seg.size() - 1);
            WindowToken token = new WindowToken(((GeometryPanel)((Object)e.getComponent())).getId());
            return token.toString();
        }
        return _arg;
    }

    private void notifyListeners(String code) {
        String cmd = this.m_krnl.getProperty(code);
        String expCmd = cmd == null ? null : this.expandCommand(cmd);
        for (Listener l : this.m_listeners) {
            l.gotMouseStroke(code, cmd, expCmd);
        }
        this.m_stroke.clear();
        this.m_panelToGfx.clear();
    }

    private String encode() {
        String code = "MouseStroke-";
        int nSegs = this.m_stroke.size() == 1 ? this.m_stroke.size() : this.m_stroke.size() - 1;
        code = String.valueOf(code) + this.encodeSegment(this.m_stroke.get(0));
        int iSeg = 1;
        while (iSeg < nSegs) {
            code = String.valueOf(code) + '-' + this.encodeSegment(this.m_stroke.get(iSeg));
            ++iSeg;
        }
        return code;
    }

    private String encodeSegment(List<MouseEvent> seg) {
        if (seg.isEmpty()) {
            return null;
        }
        MouseEvent e = seg.get(0);
        Rectangle bounds = new Rectangle(e.getPoint());
        int i = 1;
        while (i < seg.size()) {
            e = seg.get(i);
            bounds.add(e.getPoint());
            ++i;
        }
        int left = bounds.x + bounds.width / 3;
        int right = bounds.x + 2 * bounds.width / 3;
        int top = bounds.y + bounds.height / 3;
        int bottom = bounds.y + 2 * bounds.height / 3;
        e = seg.get(0);
        int x = e.getX();
        int y = e.getY();
        int field = 0;
        field = x < left ? 0 : (x > right ? 2 : 1);
        field = y < top ? (field += 0) : (y > bottom ? (field += 6) : (field += 3));
        int nleft = 0;
        int nright = 0;
        int ntop = 0;
        int nbottom = 0;
        int i2 = 1;
        while (i2 < seg.size()) {
            MouseEvent e0 = seg.get(i2 - 1);
            MouseEvent e1 = seg.get(i2);
            int minx = Math.min(e0.getX(), e1.getX());
            int miny = Math.min(e0.getY(), e1.getY());
            int maxx = Math.max(e0.getX(), e1.getX());
            int maxy = Math.max(e0.getY(), e1.getY());
            if (minx < left && maxx >= left) {
                ++nleft;
            } else if (minx < right && maxx >= right) {
                ++nright;
            }
            if (miny < top && maxy >= top) {
                ++ntop;
            } else if (miny < bottom && maxy >= bottom) {
                ++nbottom;
            }
            ++i2;
        }
        if (bounds.width < 3 && bounds.height < 3) {
            field = 0;
            nleft = 0;
            nright = 0;
            ntop = 0;
            nbottom = 0;
        } else if (bounds.height == 0 || bounds.getHeight() / bounds.getWidth() < 0.2) {
            field %= 3;
            ntop = 0;
            nbottom = 0;
        } else if (bounds.width == 0 || bounds.getWidth() / bounds.getHeight() < 0.2) {
            field /= 3;
            nleft = 0;
            nright = 0;
        }
        return "" + Integer.toHexString(field).charAt(0) + Integer.toHexString(nleft).charAt(0) + Integer.toHexString(nright).charAt(0) + Integer.toHexString(ntop).charAt(0) + Integer.toHexString(nbottom).charAt(0);
    }

    private void _setGlassPaneVisible(boolean on) {
        if (on != this.m_glassPane.isVisible()) {
            this.m_glassPane.setVisible(on);
        }
    }

    private class GlassPane
    extends JComponent {
        private static final long serialVersionUID = 1L;

        private GlassPane() {
        }

        @Override
        protected synchronized void paintComponent(Graphics _g) {
            Graphics2D g = (Graphics2D)_g;
            super.paintComponent(g);
            g.setColor(Color.RED);
            g.setClip(null);
            int iSeg = 0;
            while (iSeg < MouseStroke.this.m_stroke.size()) {
                List seg = (List)MouseStroke.this.m_stroke.get(iSeg);
                int iEvent = 0;
                while (iEvent < seg.size()) {
                    MouseEvent e = (MouseEvent)seg.get(iEvent);
                    Point glassPanePoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this);
                    g.fillRect(glassPanePoint.x, glassPanePoint.y, 2, 2);
                    this.repaint(glassPanePoint.x, glassPanePoint.y, 2, 2);
                    ++iEvent;
                }
                ++iSeg;
            }
        }
    }

    private static class GlassPaneMouseListener
    implements MouseInputListener,
    MouseWheelListener {
        private Component m_glassPane;
        private Container m_contentPane;

        public GlassPaneMouseListener(Component glassPane, Container contentPane) {
            this.m_glassPane = glassPane;
            this.m_contentPane = contentPane;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this._redispatchMouseEvent(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this._redispatchMouseEvent(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this._redispatchMouseEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this._redispatchMouseEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this._redispatchMouseEvent(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this._redispatchMouseEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this._redispatchMouseEvent(e);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this._redispatchMouseWheelEvent(e);
        }

        private void _redispatchMouseEvent(MouseEvent e) {
            Point containerPoint = SwingUtilities.convertPoint(this.m_glassPane, e.getPoint(), this.m_contentPane);
            Component component = SwingUtilities.getDeepestComponentAt(this.m_contentPane, containerPoint.x, containerPoint.y);
            if (component != null) {
                Point componentPoint = SwingUtilities.convertPoint(this.m_glassPane, e.getPoint(), component);
                component.dispatchEvent(new _MouseEvent(component, e.getID(), e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger()));
            }
        }

        private void _redispatchMouseWheelEvent(MouseWheelEvent e) {
            Point containerPoint = SwingUtilities.convertPoint(this.m_glassPane, e.getPoint(), this.m_contentPane);
            Component component = SwingUtilities.getDeepestComponentAt(this.m_contentPane, containerPoint.x, containerPoint.y);
            if (component != null) {
                Point componentPoint = SwingUtilities.convertPoint(this.m_glassPane, e.getPoint(), component);
                component.dispatchEvent(new MouseWheelEvent(component, e.getID(), e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation()));
            }
        }

        private static class _MouseEvent
        extends MouseEvent {
            private static final long serialVersionUID = 1L;
            private int m_modifiers = 0;

            private _MouseEvent(Component source, int id, long when, int modifiers, int x, int y, int clickCount, boolean popupTrigger) {
                super(source, id, when, modifiers, x, y, clickCount, popupTrigger);
                this.m_modifiers = modifiers;
            }

            @Override
            public int getModifiers() {
                return this.m_modifiers;
            }
        }
    }

    public static interface Listener {
        public void gotMouseStroke(String var1, String var2, String var3);
    }
}

