/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentArc2D;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.geo.Geo2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class AddArc
implements Cmd {
    private ComponentArc2D m_comp = null;
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Arc2D.Double arc = new Arc2D.Double();
        Line2D degeneratedArc = krnl.getConstruction().arc2D(Messages.getString("kernel.cmds.AddArc.0"), arc);
        if (degeneratedArc != null) {
            Point2D sp = degeneratedArc.getP1();
            Point2D ep = degeneratedArc.getP2();
            Point2D.Double ap = new Point2D.Double(0.5 * (sp.getX() + ep.getX()), 0.5 * (sp.getY() + ep.getY()));
            this.m_comp = new ComponentArc2D(sp, ap, ep);
        } else {
            this.m_comp = new ComponentArc2D(arc);
        }
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.add(this.m_comp);
        Point2D ctr = this.m_comp.centerPoint(new Point2D.Double());
        this.m_toString = degeneratedArc != null ? String.valueOf(Messages.getString("kernel.cmds.AddArc.1")) + Geo2D.formatCoordinate(degeneratedArc.getX1()) + Messages.getString("kernel.cmds.AddArc.2") + Geo2D.formatCoordinate(degeneratedArc.getY1()) + Messages.getString("kernel.cmds.AddArc.3") + Geo2D.formatCoordinate(degeneratedArc.getX2()) + Messages.getString("kernel.cmds.AddArc.4") + Geo2D.formatCoordinate(degeneratedArc.getY2()) + Messages.getString("kernel.cmds.AddArc.5") : String.valueOf(Messages.getString("kernel.cmds.AddArc.6")) + Geo2D.formatCoordinate(ctr.getX()) + Messages.getString("kernel.cmds.AddArc.7") + Geo2D.formatCoordinate(ctr.getY()) + Messages.getString("kernel.cmds.AddArc.8") + Geo2D.formatCoordinate(this.m_comp.radius()) + Messages.getString("kernel.cmds.AddArc.9") + Geo2D.formatDegrees(Math.toDegrees(this.m_comp.startAngle())) + Messages.getString("kernel.cmds.AddArc.10") + Geo2D.formatDegrees(Math.toDegrees(this.m_comp.sweepAngle())) + Messages.getString("kernel.cmds.AddArc.11");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.remove(this.m_comp);
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.add(this.m_comp);
    }

    @Override
    public boolean changesState() {
        return this.m_comp != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

