/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentCircle2D;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.constr.ConCircle2D;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.geo.Geo2D;
import java.awt.geom.Ellipse2D;

public class AddCircle
implements Cmd {
    private ComponentCircle2D m_comp = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Ellipse2D.Double circle = new Ellipse2D.Double();
        krnl.getConstruction().circle2D(Messages.getString("kernel.cmds.AddCircle.0"), circle);
        double rad = ConCircle2D.getRadius(circle);
        if (Double.isNaN(rad)) {
            System.err.println(Messages.getString("kernel.cmds.AddCircle.1"));
            throw new CmdAbortedException();
        }
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        this.m_comp = new ComponentCircle2D(circle.getCenterX(), circle.getCenterY(), rad);
        cmpSet.add(this.m_comp);
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.remove(this.m_comp);
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.add(this.m_comp);
    }

    @Override
    public boolean changesState() {
        return this.m_comp != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_comp == null ? super.toString() : String.valueOf(Messages.getString("kernel.cmds.AddCircle.2")) + Geo2D.formatCoordinate(this.m_comp.getCenterX()) + Messages.getString("kernel.cmds.AddCircle.3") + Geo2D.formatCoordinate(this.m_comp.getCenterY()) + Messages.getString("kernel.cmds.AddCircle.4") + Geo2D.formatCoordinate(this.m_comp.getRadius()) + Messages.getString("kernel.cmds.AddCircle.5");
    }
}

