/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.InputDeviceAdapter;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.MouseStroke;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;

public class AddMouseStrokeInputDevice
extends InputDeviceAdapter
implements Cmd {
    private UserInterface m_userInterface = null;
    private MouseStroke m_mouseStroke = null;
    private static AddMouseStrokeInputDevice s_instance = null;

    public static AddMouseStrokeInputDevice getInstance() {
        return s_instance;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_mouseStroke.setEnabled(enabled);
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        if (s_instance != null) {
            throw new CmdAbortedException(Messages.getString("kernel.cmds.AddMouseStrokeInputDevice.0"));
        }
        s_instance = this;
        Kernel krnl = (Kernel)context;
        this.m_mouseStroke = new MouseStroke(krnl);
        this.m_mouseStroke.addListener(new MouseStroke.Listener(){

            @Override
            public void gotMouseStroke(String code, String cmd, String expCmd) {
                if (cmd == null) {
                    return;
                }
                AddMouseStrokeInputDevice.this.fireInput(expCmd);
            }
        });
        this.m_userInterface = krnl.getUserInterface();
        this.m_userInterface.addInputDevice(this);
        this.setEnabled(true);
    }

    @Override
    public void undoCmd(Object context) {
        this.m_mouseStroke.setEnabled(false);
    }

    @Override
    public void redoCmd(Object context) {
        this.m_mouseStroke.setEnabled(true);
    }

    @Override
    public boolean changesState() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }
}

