/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentPath2D;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.MenuItemToken;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.util.CubicCurveRubberBand;
import cib.cad.kernel.cmds.util.LineRubberBand;
import cib.cad.kernel.cmds.util.OrthoConstraintIndicator;
import cib.cad.kernel.cmds.util.QuadCurveRubberBand;
import cib.cad.kernel.constr.ConLineSeg2D;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.geo.Geo2D;
import cib.util.geo.Vector2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class AddPath
implements Cmd {
    public static final int MOVE = 0;
    public static final int LINE = 1;
    public static final int QUAD = 2;
    public static final int CUBIC = 3;
    public static final int ARC = 4;
    public static final int CLOSE = 5;
    private static final int PATH_EXTENDED = 0;
    private static final int DONE = 1;
    private static final int UNDO_SEGMENT = 2;
    private static final int CHANGE_SEGMENT = 3;
    protected ComponentPath2D m_comp = null;
    private transient Kernel m_krnl = null;
    private transient Object m_input = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        this.m_krnl = (Kernel)context;
        UserInterface ui = this.m_krnl.getUserInterface();
        Database db = this.m_krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        this.m_comp = new ComponentPath2D();
        this.m_comp.setAutoCleaning(false);
        cmpSet.add(this.m_comp);
        try {
            Point2D pnt = this.m_krnl.readPoint(Messages.getString("kernel.cmds.AddPath.0"));
            ui.draw(pnt);
            this.m_comp.moveTo(pnt.getX(), pnt.getY());
            this.addSegments(this.m_comp);
            System.out.println(this);
        }
        catch (CmdAbortedException e) {
            cmpSet.remove(this.m_comp);
            this.m_comp = null;
            throw e;
        }
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.remove(this.m_comp);
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.add(this.m_comp);
    }

    @Override
    public boolean changesState() {
        return this.m_comp != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        if (this.m_comp == null) {
            return super.toString();
        }
        Point2D sp = this.m_comp.getStartVertexLocation();
        return String.valueOf(Messages.getString("kernel.cmds.AddPath.1")) + Geo2D.formatCoordinate(sp.getX()) + Messages.getString("kernel.cmds.AddPath.2") + Geo2D.formatCoordinate(sp.getY()) + Messages.getString("kernel.cmds.AddPath.3");
    }

    protected void addSegments(ComponentPath2D comp) throws CmdAbortedException {
        this.m_krnl = Kernel.getInstance();
        UserInterface ui = this.m_krnl.getUserInterface();
        int segType = 1;
        while (true) {
            if (ConPoint2D.getRelCoordFlag()) {
                ConPoint2D.setRelCoord(comp.getEndVertexLocation());
            }
            int status = -1;
            switch (segType) {
                case 0: {
                    status = this.addMoveSegment(comp);
                    segType = 1;
                    break;
                }
                case 5: {
                    status = this.addCloseSegment(comp);
                    segType = 0;
                    break;
                }
                case 1: {
                    status = this.addLineSegment(comp);
                    break;
                }
                case 2: {
                    status = this.addQuadraticSegment(comp);
                    break;
                }
                case 3: {
                    status = this.addCubicSegment(comp);
                    break;
                }
                case 4: {
                    status = this.addArcSegment(comp);
                    break;
                }
                default: {
                    System.err.println(Messages.getString("kernel.cmds.AddPath.4"));
                }
            }
            switch (status) {
                case 1: {
                    comp.setAutoCleaning(true);
                    return;
                }
                case 2: {
                    int n = comp.getPath().getVertexCount();
                    int name = comp.getPath().getVertexName(n - 1);
                    comp.removeVertex(name);
                    break;
                }
                case 3: {
                    segType = this.showSegmentDialog();
                }
            }
            ui.updateUserInterface();
        }
    }

    private void addContextMenu(CmdLineDialog dlg, final int segType, final boolean canUndoSegment) {
        dlg.addListener(new CmdLineDialog.ContextMenuListener(){

            @Override
            public void extendContextMenu(JPopupMenu m) {
                boolean allowSegment = true;
                if (allowSegment) {
                    m.addSeparator();
                    JRadioButtonMenuItem moveRB = new JRadioButtonMenuItem(Messages.getString("kernel.cmds.AddPath.5"));
                    JRadioButtonMenuItem lineRB = new JRadioButtonMenuItem(Messages.getString("kernel.cmds.AddPath.6"));
                    JRadioButtonMenuItem quadRB = new JRadioButtonMenuItem(Messages.getString("kernel.cmds.AddPath.7"));
                    JRadioButtonMenuItem cubicRB = new JRadioButtonMenuItem(Messages.getString("kernel.cmds.AddPath.8"));
                    JRadioButtonMenuItem arcRB = new JRadioButtonMenuItem(Messages.getString("kernel.cmds.AddPath.9"));
                    JRadioButtonMenuItem closeRB = new JRadioButtonMenuItem(Messages.getString("kernel.cmds.AddPath.10"));
                    m.add(moveRB);
                    m.add(lineRB);
                    m.add(quadRB);
                    m.add(cubicRB);
                    m.add(arcRB);
                    m.add(closeRB);
                    switch (segType) {
                        case 0: {
                            moveRB.setSelected(true);
                            break;
                        }
                        case 1: {
                            lineRB.setSelected(true);
                            break;
                        }
                        case 2: {
                            quadRB.setSelected(true);
                            break;
                        }
                        case 3: {
                            cubicRB.setSelected(true);
                            break;
                        }
                        case 4: {
                            arcRB.setSelected(true);
                            break;
                        }
                        case 5: {
                            closeRB.setSelected(true);
                        }
                    }
                    moveRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AddPath.this.m_krnl.addArgument(new MenuItemToken("Segment"));
                            AddPath.this.m_krnl.addArgument(new MenuItemToken("Move"));
                            AddPath.this.m_krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    lineRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AddPath.this.m_krnl.addArgument(new MenuItemToken("Segment"));
                            AddPath.this.m_krnl.addArgument(new MenuItemToken("Line"));
                            AddPath.this.m_krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    quadRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AddPath.this.m_krnl.addArgument(new MenuItemToken("Segment"));
                            AddPath.this.m_krnl.addArgument(new MenuItemToken("Quad"));
                            AddPath.this.m_krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    cubicRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AddPath.this.m_krnl.addArgument(new MenuItemToken("Segment"));
                            AddPath.this.m_krnl.addArgument(new MenuItemToken("Cubic"));
                            AddPath.this.m_krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    arcRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AddPath.this.m_krnl.addArgument(new MenuItemToken("Segment"));
                            AddPath.this.m_krnl.addArgument(new MenuItemToken("Arc"));
                            AddPath.this.m_krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    closeRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AddPath.this.m_krnl.addArgument(new MenuItemToken("Segment"));
                            AddPath.this.m_krnl.addArgument(new MenuItemToken("Close"));
                            AddPath.this.m_krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                }
                m.addSeparator();
                JMenuItem doneItem = new JMenuItem(Messages.getString("kernel.cmds.AddPath.23"));
                m.add(doneItem);
                doneItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AddPath.this.m_krnl.addArgument(new MenuItemToken("Done"));
                        AddPath.this.m_krnl.getUserInterface().consumeArgsByCmdLineDialog();
                    }
                });
                if (canUndoSegment) {
                    JMenuItem undoSegmentItem = new JMenuItem(Messages.getString("kernel.cmds.AddPath.25"));
                    m.add(undoSegmentItem);
                    undoSegmentItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AddPath.this.m_krnl.addArgument(new MenuItemToken("Undo segment"));
                            AddPath.this.m_krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                }
            }
        });
    }

    private int addMoveSegment(ComponentPath2D path) throws CmdAbortedException {
        final UserInterface ui = this.m_krnl.getUserInterface();
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setUniqueName("kernel.cmds.AddPath-menu0");
        ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
        String prompt = Messages.getString("kernel.cmds.AddPath.28");
        dlg.setPrompt(String.valueOf(prompt) + (ConPoint2D.getRelCoordFlag() ? Messages.getString("kernel.cmds.AddPath.29") : ""));
        dlg.enableTextInput(true);
        dlg.enableDigitize(-1);
        dlg.setChoiceChecked(dlg.addChoice("End point"));
        dlg.addSeparator();
        dlg.addChoice("Segment");
        dlg.addChoice("Done");
        if (path.getPath().getSegmentCount() > 0) {
            dlg.addChoice("Undo segment");
        }
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                AddPath.this.m_input = new Integer(iChoice);
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                AddPath.this.m_input = new CmdAbortedException();
                ui.disposeCmdLineDialog();
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                AddPath.this.m_input = new DigitizeToken(x, y, gp.getId());
                ui.disposeCmdLineDialog();
            }

            @Override
            public void textEntered(String text) {
                AddPath.this.m_input = new TextToken(text);
                ui.disposeCmdLineDialog();
            }
        });
        this.addContextMenu(dlg, 0, path.getPath().getSegmentCount() > 0);
        conPoint.setDigitizeCursor(true);
        conPoint.showRelativeCoordinatesAid(true);
        Point2D sp = path.getEndVertexLocation();
        LineRubberBand rb = new LineRubberBand(this.m_krnl, sp);
        ui.showCmdLineDialog(dlg);
        conPoint.setDigitizeCursor(false);
        conPoint.showRelativeCoordinatesAid(false);
        try {
            if (this.m_input instanceof Integer) {
                int iChoice = (Integer)this.m_input;
                switch (iChoice) {
                    case 0: {
                        this.m_krnl.pushBackArguments(new CmdLineToken[]{new TextToken("!" + sp.getX()), new TextToken("!" + sp.getY())});
                        break;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 2;
                    }
                    default: {
                        System.err.println(Messages.getString("kernel.cmds.AddPath.37"));
                        break;
                    }
                }
            } else {
                if (this.m_input instanceof CmdAbortedException) {
                    throw (CmdAbortedException)this.m_input;
                }
                if (this.m_input instanceof DigitizeToken) {
                    this.m_krnl.pushBackArguments(new CmdLineToken[]{new TextToken("!" + sp.getX()), new TextToken("!" + sp.getY()), (DigitizeToken)this.m_input});
                } else if (this.m_input instanceof TextToken) {
                    this.m_krnl.pushBackArguments(new CmdLineToken[]{new TextToken("!" + sp.getX()), new TextToken("!" + sp.getY()), (TextToken)this.m_input});
                }
            }
            rb.close();
            Line2D.Double lineSeg = new Line2D.Double();
            this.m_krnl.getConstruction().lineSeg2D(prompt, lineSeg);
            path.moveTo(((Line2D)lineSeg).getX2(), ((Line2D)lineSeg).getY2());
            return 0;
        }
        finally {
            rb.close();
        }
    }

    private int addCloseSegment(ComponentPath2D path) throws CmdAbortedException {
        int sIndex = path.getPath().getSegmentCount();
        double[] crds = new double[8];
        int i = sIndex - 1;
        while (i >= 0) {
            int sName = path.getPath().getSegmentName(i);
            int sType = path.getPath().getSegment(sName, crds);
            if (i == 0) {
                path.lineTo(crds[0], crds[1]);
                break;
            }
            if (sType == 0) {
                path.lineTo(crds[2], crds[3]);
                break;
            }
            --i;
        }
        return 0;
    }

    private int addLineSegment(ComponentPath2D path) throws CmdAbortedException {
        final UserInterface ui = this.m_krnl.getUserInterface();
        Point2D sp = path.getEndVertexLocation();
        final LineRubberBand rb = new LineRubberBand(this.m_krnl, sp);
        rb.setOrthogonalMode(ConLineSeg2D.isOrthogonalMode());
        final OrthoConstraintIndicator orthoIndicator = new OrthoConstraintIndicator(sp.getX(), sp.getY(), 0.0);
        if (ConLineSeg2D.isOrthogonalMode()) {
            orthoIndicator.addToAllPanels();
        }
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setUniqueName("kernel.cmds.AddPath-menu1");
        final ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
        String prompt = Messages.getString("kernel.cmds.AddPath.43");
        dlg.setPrompt(String.valueOf(prompt) + (ConPoint2D.getRelCoordFlag() ? Messages.getString("kernel.cmds.AddPath.44") : ""));
        dlg.enableTextInput(true);
        dlg.enableDigitize(-1);
        dlg.setChoiceChecked(dlg.addChoice("End point"));
        dlg.addSeparator();
        dlg.addChoice("Segment");
        dlg.addChoice("Done");
        if (path.getPath().getSegmentCount() > 0) {
            dlg.addChoice("Undo segment");
        }
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                AddPath.this.m_input = new Integer(iChoice);
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                AddPath.this.m_input = new CmdAbortedException();
                ui.disposeCmdLineDialog();
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                AddPath.this.m_input = new DigitizeToken(x, y, gp.getId());
                ui.disposeCmdLineDialog();
            }

            @Override
            public void textEntered(String text) {
                AddPath.this.m_input = new TextToken(text);
                ui.disposeCmdLineDialog();
            }

            @Override
            public void interruptStarts(String argList) {
                conPoint.setDigitizeCursor(false);
                conPoint.showRelativeCoordinatesAid(false);
            }

            @Override
            public void interruptEnds() {
                conPoint.setDigitizeCursor(true);
                conPoint.showRelativeCoordinatesAid(true);
                rb.setOrthogonalMode(ConLineSeg2D.isOrthogonalMode());
                if (ConLineSeg2D.isOrthogonalMode()) {
                    orthoIndicator.addToAllPanels();
                } else {
                    orthoIndicator.removeFromAllPanels();
                }
            }
        });
        this.addContextMenu(dlg, 1, path.getPath().getSegmentCount() > 0);
        conPoint.setDigitizeCursor(true);
        conPoint.showRelativeCoordinatesAid(true);
        ui.showCmdLineDialog(dlg);
        conPoint.setDigitizeCursor(false);
        conPoint.showRelativeCoordinatesAid(false);
        try {
            if (this.m_input instanceof Integer) {
                int iChoice = (Integer)this.m_input;
                switch (iChoice) {
                    case 0: {
                        this.m_krnl.pushBackArguments(new CmdLineToken[]{new TextToken("!" + sp.getX()), new TextToken("!" + sp.getY())});
                        break;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 2;
                    }
                    default: {
                        System.err.println(Messages.getString("kernel.cmds.AddPath.52"));
                        break;
                    }
                }
            } else {
                if (this.m_input instanceof CmdAbortedException) {
                    throw (CmdAbortedException)this.m_input;
                }
                if (this.m_input instanceof DigitizeToken) {
                    this.m_krnl.pushBackArguments(new CmdLineToken[]{new TextToken("!" + sp.getX()), new TextToken("!" + sp.getY()), (DigitizeToken)this.m_input});
                } else if (this.m_input instanceof TextToken) {
                    this.m_krnl.pushBackArguments(new CmdLineToken[]{new TextToken("!" + sp.getX()), new TextToken("!" + sp.getY()), (TextToken)this.m_input});
                }
            }
            rb.close();
            Line2D.Double lineSeg = new Line2D.Double();
            this.m_krnl.getConstruction().lineSeg2D(prompt, lineSeg);
            path.lineTo(((Line2D)lineSeg).getX2(), ((Line2D)lineSeg).getY2());
            return 0;
        }
        finally {
            rb.close();
            orthoIndicator.removeFromAllPanels();
        }
    }

    private int addQuadraticSegment(ComponentPath2D path) throws CmdAbortedException {
        final UserInterface ui = this.m_krnl.getUserInterface();
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setUniqueName("kernel.cmds.AddPath-menu2");
        final ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
        String prompt = Messages.getString("kernel.cmds.AddPath.58");
        dlg.setPrompt(String.valueOf(prompt) + (ConPoint2D.getRelCoordFlag() ? Messages.getString("kernel.cmds.AddPath.59") : ""));
        dlg.enableTextInput(true);
        dlg.enableDigitize(-1);
        dlg.setChoiceChecked(dlg.addChoice("End point"));
        dlg.addSeparator();
        dlg.addChoice("Segment");
        dlg.addChoice("Done");
        if (path.getPath().getSegmentCount() > 0) {
            dlg.addChoice("Undo segment");
        }
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                AddPath.this.m_input = new Integer(iChoice);
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                AddPath.this.m_input = new CmdAbortedException();
                ui.disposeCmdLineDialog();
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                AddPath.this.m_input = new DigitizeToken(x, y, gp.getId());
                ui.disposeCmdLineDialog();
            }

            @Override
            public void textEntered(String text) {
                AddPath.this.m_input = new TextToken(text);
                ui.disposeCmdLineDialog();
            }

            @Override
            public void interruptStarts(String argList) {
                conPoint.setDigitizeCursor(false);
                conPoint.showRelativeCoordinatesAid(false);
            }

            @Override
            public void interruptEnds() {
                conPoint.setDigitizeCursor(true);
                conPoint.showRelativeCoordinatesAid(true);
            }
        });
        this.addContextMenu(dlg, 2, path.getPath().getSegmentCount() > 0);
        conPoint.setDigitizeCursor(true);
        conPoint.showRelativeCoordinatesAid(true);
        Point2D sp = path.getEndVertexLocation();
        QuadCurveRubberBand rb = new QuadCurveRubberBand(this.m_krnl, sp);
        ui.showCmdLineDialog(dlg);
        conPoint.setDigitizeCursor(false);
        conPoint.showRelativeCoordinatesAid(false);
        try {
            if (this.m_input instanceof Integer) {
                int iChoice = (Integer)this.m_input;
                switch (iChoice) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 2;
                    }
                    default: {
                        System.err.println(Messages.getString("kernel.cmds.AddPath.65"));
                        break;
                    }
                }
            } else {
                if (this.m_input instanceof CmdAbortedException) {
                    throw (CmdAbortedException)this.m_input;
                }
                if (this.m_input instanceof DigitizeToken) {
                    this.m_krnl.pushBackArguments(new CmdLineToken[]{(DigitizeToken)this.m_input});
                } else if (this.m_input instanceof TextToken) {
                    this.m_krnl.pushBackArguments(new CmdLineToken[]{(TextToken)this.m_input});
                }
            }
            Point2D.Double ep = new Point2D.Double();
            this.m_krnl.getConstruction().point2D(Messages.getString("kernel.cmds.AddPath.66"), ep);
            rb.setP3(ep);
            if (ConPoint2D.getRelCoordFlag()) {
                ConPoint2D.setRelCoord(sp);
            }
            Point2D.Double ctrl = new Point2D.Double();
            this.m_krnl.getConstruction().point2D(Messages.getString("kernel.cmds.AddPath.67"), ctrl);
            rb.close();
            path.quadTo(((Point2D)ctrl).getX(), ((Point2D)ctrl).getY(), ((Point2D)ep).getX(), ((Point2D)ep).getY());
            return 0;
        }
        finally {
            rb.close();
        }
    }

    private int addCubicSegment(ComponentPath2D path) throws CmdAbortedException {
        final UserInterface ui = this.m_krnl.getUserInterface();
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setUniqueName("kernel.cmds.AddPath-menu3");
        final ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
        String prompt = Messages.getString("kernel.cmds.AddPath.69");
        dlg.setPrompt(String.valueOf(prompt) + (ConPoint2D.getRelCoordFlag() ? Messages.getString("kernel.cmds.AddPath.70") : ""));
        dlg.enableTextInput(true);
        dlg.enableDigitize(-1);
        dlg.setChoiceChecked(dlg.addChoice("End point"));
        dlg.addSeparator();
        dlg.addChoice("Segment");
        dlg.addChoice("Done");
        if (path.getPath().getSegmentCount() > 0) {
            dlg.addChoice("Undo segment");
        }
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                AddPath.this.m_input = new Integer(iChoice);
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                AddPath.this.m_input = new CmdAbortedException();
                ui.disposeCmdLineDialog();
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                AddPath.this.m_input = new DigitizeToken(x, y, gp.getId());
                ui.disposeCmdLineDialog();
            }

            @Override
            public void textEntered(String text) {
                AddPath.this.m_input = new TextToken(text);
                ui.disposeCmdLineDialog();
            }

            @Override
            public void interruptStarts(String argList) {
                conPoint.setDigitizeCursor(false);
                conPoint.showRelativeCoordinatesAid(false);
            }

            @Override
            public void interruptEnds() {
                conPoint.setDigitizeCursor(true);
                conPoint.showRelativeCoordinatesAid(true);
            }
        });
        this.addContextMenu(dlg, 3, path.getPath().getSegmentCount() > 0);
        conPoint.setDigitizeCursor(true);
        conPoint.showRelativeCoordinatesAid(true);
        Point2D sp = path.getEndVertexLocation();
        CubicCurveRubberBand rb = new CubicCurveRubberBand(this.m_krnl, sp);
        ui.showCmdLineDialog(dlg);
        conPoint.setDigitizeCursor(false);
        conPoint.showRelativeCoordinatesAid(false);
        try {
            if (this.m_input instanceof Integer) {
                int iChoice = (Integer)this.m_input;
                switch (iChoice) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 2;
                    }
                    default: {
                        System.err.println(Messages.getString("kernel.cmds.AddPath.76"));
                        break;
                    }
                }
            } else {
                if (this.m_input instanceof CmdAbortedException) {
                    throw (CmdAbortedException)this.m_input;
                }
                if (this.m_input instanceof DigitizeToken) {
                    this.m_krnl.pushBackArguments(new CmdLineToken[]{(DigitizeToken)this.m_input});
                } else if (this.m_input instanceof TextToken) {
                    this.m_krnl.pushBackArguments(new CmdLineToken[]{(TextToken)this.m_input});
                }
            }
            Point2D.Double ep = new Point2D.Double();
            this.m_krnl.getConstruction().point2D(Messages.getString("kernel.cmds.AddPath.77"), ep);
            rb.setP4(ep);
            if (ConPoint2D.getRelCoordFlag()) {
                ConPoint2D.setRelCoord(sp);
            }
            Point2D.Double ctrl1 = new Point2D.Double();
            this.m_krnl.getConstruction().point2D(Messages.getString("kernel.cmds.AddPath.78"), ctrl1);
            rb.setP2(ctrl1);
            if (ConPoint2D.getRelCoordFlag()) {
                ConPoint2D.setRelCoord(sp);
            }
            Point2D.Double ctrl2 = new Point2D.Double();
            this.m_krnl.getConstruction().point2D(Messages.getString("kernel.cmds.AddPath.79"), ctrl2);
            rb.close();
            path.cubicTo(((Point2D)ctrl1).getX(), ((Point2D)ctrl1).getY(), ((Point2D)ctrl2).getX(), ((Point2D)ctrl2).getY(), ((Point2D)ep).getX(), ((Point2D)ep).getY());
            return 0;
        }
        finally {
            rb.close();
        }
    }

    private int addArcSegment(ComponentPath2D path) throws CmdAbortedException {
        final UserInterface ui = this.m_krnl.getUserInterface();
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setUniqueName("kernel.cmds.AddPath-menu4");
        final ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
        String prompt = Messages.getString("kernel.cmds.AddPath.81");
        dlg.setPrompt(String.valueOf(prompt) + (ConPoint2D.getRelCoordFlag() ? Messages.getString("kernel.cmds.AddPath.82") : ""));
        dlg.enableTextInput(true);
        dlg.enableDigitize(-1);
        dlg.setChoiceChecked(dlg.addChoice("End point"));
        dlg.addChoice("Center point");
        dlg.addSeparator();
        dlg.addChoice("Segment");
        dlg.addChoice("Done");
        if (path.getPath().getSegmentCount() > 0) {
            dlg.addChoice("Undo segment");
        }
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                AddPath.this.m_input = new Integer(iChoice);
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                AddPath.this.m_input = new CmdAbortedException();
                ui.disposeCmdLineDialog();
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                AddPath.this.m_input = new DigitizeToken(x, y, gp.getId());
                ui.disposeCmdLineDialog();
            }

            @Override
            public void textEntered(String text) {
                AddPath.this.m_input = new TextToken(text);
                ui.disposeCmdLineDialog();
            }

            @Override
            public void interruptStarts(String argList) {
                conPoint.setDigitizeCursor(false);
                conPoint.showRelativeCoordinatesAid(false);
            }

            @Override
            public void interruptEnds() {
                conPoint.setDigitizeCursor(true);
                conPoint.showRelativeCoordinatesAid(true);
            }
        });
        this.addContextMenu(dlg, 4, path.getPath().getSegmentCount() > 0);
        conPoint.setDigitizeCursor(true);
        conPoint.showRelativeCoordinatesAid(true);
        Point2D sp = path.getEndVertexLocation();
        LineRubberBand rb = new LineRubberBand(this.m_krnl, sp);
        ui.showCmdLineDialog(dlg);
        conPoint.setDigitizeCursor(false);
        conPoint.showRelativeCoordinatesAid(false);
        try {
            if (this.m_input instanceof Integer) {
                int iChoice = (Integer)this.m_input;
                switch (iChoice) {
                    case 0: {
                        this.m_krnl.pushBackArguments(new CmdLineToken[]{new MenuItemToken("Circumference"), new TextToken("!" + sp.getX()), new TextToken("!" + sp.getY())});
                        break;
                    }
                    case 1: {
                        Point2D.Double center = new Point2D.Double();
                        this.m_krnl.getConstruction().point2D(Messages.getString("kernel.cmds.AddPath.92"), center);
                        this.m_krnl.pushBackArguments(new CmdLineToken[]{new MenuItemToken("Circle and angles"), new TextToken("!" + ((Point2D)center).getX()), new TextToken("!" + ((Point2D)center).getY()), new MenuItemToken("Circumference"), new TextToken("!" + sp.getX()), new TextToken("!" + sp.getY())});
                        break;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 1;
                    }
                    case 4: {
                        return 2;
                    }
                    default: {
                        System.err.println(Messages.getString("kernel.cmds.AddPath.99"));
                        break;
                    }
                }
            } else {
                if (this.m_input instanceof CmdAbortedException) {
                    throw (CmdAbortedException)this.m_input;
                }
                if (this.m_input instanceof DigitizeToken) {
                    this.m_krnl.pushBackArguments(new CmdLineToken[]{new MenuItemToken("Circumference"), new TextToken("!" + sp.getX()), new TextToken("!" + sp.getY()), (DigitizeToken)this.m_input});
                } else if (this.m_input instanceof TextToken) {
                    this.m_krnl.pushBackArguments(new CmdLineToken[]{new MenuItemToken("Circumference"), new TextToken("!" + sp.getX()), new TextToken("!" + sp.getY()), (TextToken)this.m_input});
                }
            }
            rb.close();
            Arc2D.Double arc = new Arc2D.Double();
            this.m_krnl.getConstruction().arc2D(prompt, arc);
            if (Geo2D.isNull(arc)) {
                System.err.println(Messages.getString("kernel.cmds.AddPath.106"));
                return 0;
            }
            double angle = -Math.toRadians(((Arc2D)arc).getAngleStart() + 0.5 * ((Arc2D)arc).getAngleExtent());
            double radius = 0.5 * ((RectangularShape)arc).getWidth();
            Vector2D ap = new Vector2D(angle);
            ap.scaleBy(radius);
            ap.add(arc.getCenterX(), arc.getCenterY());
            Point2D ep = arc.getEndPoint();
            path.arcTo(ap.getX(), ap.getY(), ep.getX(), ep.getY());
            return 0;
        }
        finally {
            rb.close();
        }
    }

    private int showSegmentDialog() throws CmdAbortedException {
        final UserInterface ui = this.m_krnl.getUserInterface();
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setUniqueName("kernel.cmds.AddPath-menu5");
        dlg.setPrompt(Messages.getString("kernel.cmds.AddPath.108"));
        dlg.enableTextInput(false);
        dlg.addChoice("Move");
        dlg.setChoiceHints(0, Messages.getString("kernel.cmds.AddPath.110"));
        dlg.addSeparator();
        dlg.addChoice("Line");
        dlg.setChoiceHints(1, Messages.getString("kernel.cmds.AddPath.112"));
        dlg.addChoice("Quad");
        dlg.setChoiceHints(2, Messages.getString("kernel.cmds.AddPath.114"));
        dlg.addChoice("Cubic");
        dlg.setChoiceHints(3, Messages.getString("kernel.cmds.AddPath.116"));
        dlg.addChoice("Arc");
        dlg.setChoiceHints(4, Messages.getString("kernel.cmds.AddPath.118"));
        dlg.addSeparator();
        dlg.addChoice("Close");
        dlg.setChoiceHints(5, Messages.getString("kernel.cmds.AddPath.120"));
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                AddPath.this.m_input = new Integer(iChoice);
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                AddPath.this.m_input = new CmdAbortedException();
                ui.disposeCmdLineDialog();
            }
        });
        ui.showCmdLineDialog(dlg);
        if (this.m_input instanceof CmdAbortedException) {
            throw (CmdAbortedException)this.m_input;
        }
        return (Integer)this.m_input;
    }
}

