/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.AddableFeatures;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.Group;
import cib.cad.db.feature.Feature;
import cib.cad.db.feature.StringFeature;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import java.util.HashSet;
import java.util.Set;

public class AddStringFeature
implements Cmd {
    public static final String FEATURE_NAME_PREFIX = "USER_DATA.";
    private Feature m_feature = null;
    private Set<AddableFeatures> m_operands = new HashSet<AddableFeatures>();

    public static boolean isDoable() {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        if (selSet.isEmpty()) {
            Group comp = krnl.getOpenGroup();
            return comp instanceof AddableFeatures;
        }
        for (Component comp : selSet) {
            if (comp instanceof AddableFeatures) continue;
            return false;
        }
        return true;
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Group group;
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        for (Component comp : selSet) {
            if (!(comp instanceof AddableFeatures)) {
                krnl.readOK(Messages.getString("kernel.cmds.AddStringFeature.3"), Messages.getString("kernel.cmds.AddStringFeature.4"), Messages.getString("kernel.cmds.AddStringFeature.5"), 6);
                return;
            }
            this.m_operands.add((AddableFeatures)comp);
        }
        if (this.m_operands.isEmpty() && (group = krnl.getOpenGroup()) instanceof AddableFeatures) {
            this.m_operands.add((AddableFeatures)((Object)group));
        }
        if (this.m_operands.isEmpty()) {
            krnl.readOK(Messages.getString("kernel.cmds.AddStringFeature.0"), Messages.getString("kernel.cmds.AddStringFeature.1"), Messages.getString("kernel.cmds.AddStringFeature.2"), 6);
            return;
        }
        String name = FEATURE_NAME_PREFIX + krnl.readString(Messages.getString("kernel.cmds.AddStringFeature.6"));
        for (Component component : this.m_operands) {
            if (!component.hasFeature(name)) continue;
            krnl.readOK(Messages.getString("kernel.cmds.AddStringFeature.7"), Messages.getString("kernel.cmds.AddStringFeature.8"), Messages.getString("kernel.cmds.AddStringFeature.9"), 6);
            return;
        }
        boolean bl = krnl.readYesNo(Messages.getString("kernel.cmds.AddStringFeature.10"), 2);
        String value = krnl.readString(Messages.getString("kernel.cmds.AddStringFeature.11"), "");
        this.m_feature = new StringFeature(name, value);
        this.m_feature.setChangeable(bl);
        for (Component component : this.m_operands) {
            ((AddableFeatures)component).addFeature(this.m_feature);
        }
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        String name = this.m_feature.getName();
        for (AddableFeatures comp : this.m_operands) {
            comp.removeFeature(name);
        }
    }

    @Override
    public void redoCmd(Object context) {
        for (AddableFeatures comp : this.m_operands) {
            comp.addFeature(this.m_feature);
        }
    }

    @Override
    public boolean changesState() {
        return this.m_feature != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return Messages.getString("kernel.cmds.AddStringFeature.12");
    }
}

