/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentText2D;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.geo.Geo2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.AttributedString;

public class AddText
implements Cmd {
    private ComponentText2D m_comp = null;
    private String m_toString = null;
    private String m_text = null;
    private double m_angle = 0.0;
    private int m_justification = 0;
    private double m_scaleX = 1.0;
    private boolean m_abort = false;
    private static int s_tjust;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        Point2D plp = krnl.readPoint(Messages.getString("kernel.cmds.AddText.0"));
        do {
            CmdLineDialog dlg = ui.getCmdLineDialog();
            dlg.setUniqueName("kernel.cmds.AddText-menu0");
            dlg.setPrompt(Messages.getString("kernel.cmds.AddText.2"));
            dlg.addChoice("Angle");
            dlg.addChoice("Justificaton");
            dlg.addChoice("Scale");
            dlg.setDefaultText(TextToken.stringToLiteral(""));
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void textEntered(String text) {
                    AddText.this.m_text = text;
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void choiceSelected(int iChoice) {
                    if (iChoice == 0) {
                        AddText.this.m_angle = Double.NaN;
                    } else if (iChoice == 1) {
                        AddText.this.m_justification = Integer.MIN_VALUE;
                    } else if (iChoice == 2) {
                        AddText.this.m_scaleX = Double.NaN;
                    } else {
                        return;
                    }
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    AddText.this.m_abort = true;
                    ui.disposeCmdLineDialog();
                }
            });
            ui.showCmdLineDialog(dlg);
            if (Double.isNaN(this.m_angle)) {
                this.m_angle = krnl.getConstruction().angle2D(Messages.getString("kernel.cmds.AddText.6"), 0.0);
                continue;
            }
            if (this.m_justification == Integer.MIN_VALUE) {
                this.m_justification = AddText.textJustificationDialog();
                continue;
            }
            if (Double.isNaN(this.m_scaleX)) {
                this.m_scaleX = krnl.readDouble(Messages.getString("kernel.cmds.AddText.7"), 1.0);
                continue;
            }
            if (!this.m_abort) continue;
            throw new CmdAbortedException();
        } while (this.m_text == null);
        AffineTransform at = AffineTransform.getTranslateInstance(plp.getX(), plp.getY());
        at.rotate(this.m_angle);
        AttributedString as = new AttributedString(this.m_text);
        this.m_comp = new ComponentText2D(as, at);
        this.m_comp.setJustification(this.m_justification);
        this.m_comp.setScaleInTextDirection(this.m_scaleX);
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.add(this.m_comp);
        String outText = this.m_text;
        int posNewLine = this.m_text.indexOf("\n");
        if (posNewLine != -1) {
            outText = String.valueOf(this.m_text.substring(0, posNewLine)) + "...";
        }
        this.m_toString = String.valueOf(Messages.getString("kernel.cmds.AddText.9")) + outText + Messages.getString("kernel.cmds.AddText.10") + Geo2D.formatCoordinate(plp.getX()) + Messages.getString("kernel.cmds.AddText.11") + Geo2D.formatCoordinate(plp.getY()) + Messages.getString("kernel.cmds.AddText.12");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.remove(this.m_comp);
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.add(this.m_comp);
    }

    @Override
    public boolean changesState() {
        return this.m_comp != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    public ComponentText2D getComponent() {
        return this.m_comp;
    }

    public static int textJustificationDialog() throws CmdAbortedException {
        Kernel krnl = Kernel.getInstance();
        UserInterface ui = krnl.getUserInterface();
        switch (AddText._hJust(ui)) {
            case 0: {
                switch (AddText._vJust(ui)) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 9;
                    }
                    case 2: {
                        return 1;
                    }
                }
                return 2;
            }
            case 1: {
                switch (AddText._vJust(ui)) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 10;
                    }
                    case 2: {
                        return 4;
                    }
                }
                return 5;
            }
        }
        switch (AddText._vJust(ui)) {
            case 0: {
                return 6;
            }
            case 1: {
                return 11;
            }
            case 2: {
                return 7;
            }
        }
        return 8;
    }

    private static int _hJust(final UserInterface ui) throws CmdAbortedException {
        s_tjust = -1;
        do {
            CmdLineDialog dlg = ui.getCmdLineDialog();
            dlg.setUniqueName("kernel.cmds.AddText-menu1");
            dlg.setPrompt(Messages.getString("kernel.cmds.AddText.14"));
            dlg.addChoice("Left");
            dlg.addChoice("Center");
            dlg.addChoice("Right");
            dlg.enableTextInput(false);
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    s_tjust = iChoice;
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    ui.disposeCmdLineDialog();
                }
            });
            ui.showCmdLineDialog(dlg);
            if (s_tjust != -1) continue;
            throw new CmdAbortedException();
        } while (s_tjust == -1);
        return s_tjust;
    }

    private static int _vJust(final UserInterface ui) throws CmdAbortedException {
        s_tjust = -1;
        do {
            CmdLineDialog dlg = ui.getCmdLineDialog();
            dlg.setUniqueName("kernel.cmds.AddText-menu2");
            dlg.setPrompt(Messages.getString("kernel.cmds.AddText.19"));
            dlg.addChoice("Baseline");
            dlg.addChoice("Bottom");
            dlg.addChoice("Center");
            dlg.addChoice("Top");
            dlg.enableTextInput(false);
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    s_tjust = iChoice;
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    ui.disposeCmdLineDialog();
                }
            });
            ui.showCmdLineDialog(dlg);
            if (s_tjust != -1) continue;
            throw new CmdAbortedException();
        } while (s_tjust == -1);
        return s_tjust;
    }
}

