/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.ComponentDimSingle;
import cib.cad.db.comp.ComponentImage;
import cib.cad.db.comp.ComponentPath2D;
import cib.cad.ext.mod.Chamfer;
import cib.cad.ext.mod.CloseAllGroups;
import cib.cad.ext.mod.CloseGroup;
import cib.cad.ext.mod.Extend;
import cib.cad.ext.mod.Fillet;
import cib.cad.ext.mod.GroupComponents;
import cib.cad.ext.mod.Join;
import cib.cad.ext.mod.Offset;
import cib.cad.ext.mod.OpenGroup;
import cib.cad.ext.mod.Smash;
import cib.cad.ext.mod.SplitSegments;
import cib.cad.ext.mod.UngroupComponents;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.InputDeviceAdapter;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.WindowToken;
import cib.cad.kernel.cmds.AddStringFeature;
import cib.cad.kernel.cmds.AddTextFeature;
import cib.cad.kernel.cmds.ChangeFeatures;
import cib.cad.kernel.cmds.RemoveFeature;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import cib.util.coll.ObservableSet;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class ContextMenu
extends CmdAdapter {
    public static final int INPUT = 0;
    public static final int COMMAND = 1;
    public static final int INTERRUPTING_COMMAND = 2;
    private static InputDeviceAdapter s_inputDevice = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        final Kernel krnl = (Kernel)context;
        UserInterface ui = krnl.getUserInterface();
        if (s_inputDevice == null) {
            s_inputDevice = new InputDeviceAdapter();
            ui.addInputDevice(s_inputDevice);
            s_inputDevice.setEnabled(true);
        }
        Database db = krnl.getDatabase();
        ObservableSet<cib.cad.db.comp.Component> cmpSet = db.getComponentSet();
        ObservableSet<cib.cad.db.comp.Component> selSet = db.getSelectSet();
        DigitizeObject dig = krnl.readDigitizeObject(Messages.getString("kernel.cmds.ContextMenu.0"));
        final GeometryPanel drawPanel = dig.getGeometryPanel();
        final Point pos = dig.getPoint();
        final JPopupMenu popupMenu = new JPopupMenu();
        if (krnl.getCmdExecutionStatus() == 1) {
            JMenu menu;
            String againCmd = krnl.getLastCmd();
            String againText = "";
            if (againCmd != null) {
                againText = ": ";
                String locText = Messages.getString(againCmd);
                againText = String.valueOf(againText) + (locText.startsWith("!") && !Messages.containsKey(againCmd) ? againCmd : locText);
            }
            JMenuItem menuItem = new JMenuItem(String.valueOf(Messages.getString("kernel.cmds.ContextMenu.3")) + againText);
            menuItem.addActionListener(new _CmdListener("again"));
            menuItem.setEnabled(againCmd != null && !againCmd.equals(""));
            popupMenu.add(menuItem);
            menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.6"));
            menuItem.addActionListener(new _CmdListener("undo"));
            menuItem.setEnabled(krnl.canUndoMore());
            popupMenu.add(menuItem);
            menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.8"));
            menuItem.addActionListener(new _CmdListener("redo"));
            menuItem.setEnabled(krnl.canRedoMore());
            popupMenu.add(menuItem);
            popupMenu.addSeparator();
            menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.10"));
            menuItem.addActionListener(new _CmdListener("winfit " + drawPanel.getId()));
            popupMenu.add(menuItem);
            menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.12"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Kernel.Listener l = new Kernel.Listener(){
                        int m_i = 0;

                        @Override
                        public void tokenConsumed(CmdLineToken token) {
                            if (++this.m_i == 2) {
                                krnl.addArgument(new WindowToken(drawPanel.getId()));
                            }
                        }

                        @Override
                        public void cmdEnds(String cmdName) {
                            krnl.removeListener(this);
                        }
                    };
                    krnl.addListener(l);
                    if (s_inputDevice.isEnabled()) {
                        s_inputDevice.fireInterruptingInput("winzoom;setagain winzoom");
                    }
                }
            });
            popupMenu.add(menuItem);
            if (!selSet.isEmpty() && cmpSet.size() > 1) {
                menu = new JMenu(Messages.getString("kernel.cmds.ContextMenu.14"));
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.15"));
                menuItem.addActionListener(new _CmdListener("posBack"));
                menu.add(menuItem);
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.17"));
                menuItem.addActionListener(new _CmdListener("posBackward"));
                menu.add(menuItem);
                if (selSet.size() == 2) {
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.19"));
                    menuItem.addActionListener(new _CmdListener("posSwap"));
                    menu.add(menuItem);
                }
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.21"));
                menuItem.addActionListener(new _CmdListener("posForward"));
                menu.add(menuItem);
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.23"));
                menuItem.addActionListener(new _CmdListener("posFront"));
                menu.add(menuItem);
                popupMenu.add(menu);
            }
            if (!cmpSet.isEmpty()) {
                popupMenu.addSeparator();
                menu = new JMenu(Messages.getString("kernel.cmds.ContextMenu.25"));
                if (cmpSet.size() != selSet.size()) {
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.26"));
                    menuItem.addActionListener(new _CmdListener("selectAll #menu(Done)"));
                    menu.add(menuItem);
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.28"));
                    menuItem.addActionListener(new _CmdListener("selectByName"));
                    menu.add(menuItem);
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.30"));
                    menuItem.addActionListener(new _CmdListener("selectByPick"));
                    menu.add(menuItem);
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.32"));
                    menuItem.addActionListener(new _CmdListener("selectByPickInside"));
                    menu.add(menuItem);
                }
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.34"));
                menuItem.addActionListener(new _CmdListener("selectPoints"));
                menu.add(menuItem);
                popupMenu.add(menu);
            }
            if (!selSet.isEmpty()) {
                menu = new JMenu(Messages.getString("kernel.cmds.ContextMenu.36"));
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.37"));
                menuItem.addActionListener(new _CmdListener("unselectAll  #menu(Done)"));
                menu.add(menuItem);
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.39"));
                menuItem.addActionListener(new _CmdListener("unselectByName"));
                menu.add(menuItem);
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.41"));
                menuItem.addActionListener(new _CmdListener("unselectByPick"));
                menu.add(menuItem);
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.43"));
                menuItem.addActionListener(new _CmdListener("unselectByPickInside"));
                menu.add(menuItem);
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.45"));
                menuItem.addActionListener(new _CmdListener("unselectPoints"));
                menu.add(menuItem);
                popupMenu.add(menu);
            }
            if (krnl.getCmdExecutionStatus() == 1 && (GroupComponents.isDoable() || UngroupComponents.isDoable() || OpenGroup.isDoable() || CloseGroup.isDoable())) {
                popupMenu.addSeparator();
                if (GroupComponents.isDoable()) {
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.46a"));
                    menuItem.addActionListener(new _CmdListener("group"));
                    popupMenu.add(menuItem);
                }
                if (UngroupComponents.isDoable()) {
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.46b"));
                    menuItem.addActionListener(new _CmdListener("ungroup"));
                    popupMenu.add(menuItem);
                }
                if (OpenGroup.isDoable()) {
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.46c"));
                    menuItem.addActionListener(new _CmdListener("opengroup"));
                    popupMenu.add(menuItem);
                }
                if (CloseGroup.isDoable()) {
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.46d"));
                    menuItem.addActionListener(new _CmdListener("closegroup"));
                    popupMenu.add(menuItem);
                }
                if (CloseAllGroups.isDoable()) {
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.46e"));
                    menuItem.addActionListener(new _CmdListener("closeallgroups"));
                    popupMenu.add(menuItem);
                }
            }
            if (krnl.getCmdExecutionStatus() == 1 && !selSet.isEmpty()) {
                popupMenu.addSeparator();
                menu = new JMenu(Messages.getString("kernel.cmds.ContextMenu.47"));
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.48"));
                menuItem.addActionListener(new _CmdListener("translate"));
                menu.add(menuItem);
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.50"));
                menuItem.addActionListener(new _CmdListener("rotate"));
                menu.add(menuItem);
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.52"));
                menuItem.addActionListener(new _CmdListener("scale"));
                menu.add(menuItem);
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.54"));
                menuItem.addActionListener(new _CmdListener("mirror"));
                menu.add(menuItem);
                popupMenu.add(menu);
                menu = new JMenu(Messages.getString("kernel.cmds.ContextMenu.56"));
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.57"));
                menuItem.addActionListener(new _CmdListener("copyTranslate"));
                menu.add(menuItem);
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.59"));
                menuItem.addActionListener(new _CmdListener("copyRotate"));
                menu.add(menuItem);
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.61"));
                menuItem.addActionListener(new _CmdListener("copyScale"));
                menu.add(menuItem);
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.63"));
                menuItem.addActionListener(new _CmdListener("copyMirror"));
                menu.add(menuItem);
                menu.addSeparator();
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.65"));
                menuItem.addActionListener(new _CmdListener("copyRectArray"));
                menu.add(menuItem);
                popupMenu.add(menu);
                if (selSet.size() == 1 && selSet.iterator().next() instanceof ComponentPath2D) {
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.67"));
                    menuItem.addActionListener(new _CmdListener("continuePath"));
                    popupMenu.add(menuItem);
                }
                for (cib.cad.db.comp.Component comp : selSet) {
                    if (!(comp instanceof ComponentImage)) continue;
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.69"));
                    menuItem.addActionListener(new _CmdListener("modifyImages"));
                    popupMenu.add(menuItem);
                    break;
                }
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.71"));
                menuItem.addActionListener(new _CmdListener("remove"));
                popupMenu.add(menuItem);
                if (selSet.size() == 1 && selSet.iterator().next() instanceof ComponentDimSingle) {
                    popupMenu.addSeparator();
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.73"));
                    menuItem.addActionListener(new _CmdListener("setDimMaster"));
                    popupMenu.add(menuItem);
                }
                boolean toJoin = Join.isDoable();
                boolean toSmash = Smash.isDoable();
                if (toSmash || toJoin) {
                    popupMenu.addSeparator();
                }
                if (toJoin) {
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.75"));
                    menuItem.addActionListener(new _CmdListener("join"));
                    popupMenu.add(menuItem);
                }
                if (toSmash) {
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.77"));
                    menuItem.addActionListener(new _CmdListener("smash"));
                    popupMenu.add(menuItem);
                }
                boolean toExtend = Extend.isDoable();
                boolean toOffset = Offset.isDoable();
                if (toExtend || toOffset) {
                    popupMenu.addSeparator();
                    if (toExtend) {
                        menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.79"));
                        menuItem.addActionListener(new _CmdListener("extend"));
                        popupMenu.add(menuItem);
                        menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.81"));
                        menuItem.addActionListener(new _CmdListener("trim"));
                        popupMenu.add(menuItem);
                    }
                    if (toOffset) {
                        menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.83"));
                        menuItem.addActionListener(new _CmdListener("offset"));
                        popupMenu.add(menuItem);
                    }
                }
                boolean toFillet = Fillet.isDoable();
                boolean toChamfer = Chamfer.isDoable();
                if (toFillet || toChamfer) {
                    popupMenu.addSeparator();
                    if (toFillet) {
                        menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.85"));
                        menuItem.addActionListener(new _CmdListener("fillet 0"));
                        popupMenu.add(menuItem);
                        menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.87"));
                        menuItem.addActionListener(new _CmdListener("fillet"));
                        popupMenu.add(menuItem);
                    }
                    if (toChamfer) {
                        menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.89"));
                        menuItem.addActionListener(new _CmdListener("chamfer"));
                        popupMenu.add(menuItem);
                    }
                }
                if (SplitSegments.isDoable()) {
                    popupMenu.addSeparator();
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.91"));
                    menuItem.addActionListener(new _CmdListener("split"));
                    popupMenu.add(menuItem);
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.93"));
                    menuItem.addActionListener(new _CmdListener("break"));
                    popupMenu.add(menuItem);
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.95"));
                    menuItem.addActionListener(new _CmdListener("changeType"));
                    popupMenu.add(menuItem);
                }
            }
            boolean addStringFeature = AddStringFeature.isDoable();
            boolean addTextFeature = AddTextFeature.isDoable();
            boolean removeFeature = RemoveFeature.isDoable();
            if (addStringFeature || addTextFeature || removeFeature) {
                popupMenu.addSeparator();
                if (addStringFeature) {
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.96a"));
                    menuItem.addActionListener(new _CmdListener("addstringfeature"));
                    popupMenu.add(menuItem);
                }
                if (addTextFeature) {
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.96b"));
                    menuItem.addActionListener(new _CmdListener("addtextfeature"));
                    popupMenu.add(menuItem);
                }
                if (removeFeature) {
                    menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.96c"));
                    menuItem.addActionListener(new _CmdListener("removefeature"));
                    popupMenu.add(menuItem);
                }
            }
            if (ChangeFeatures.isDoable()) {
                popupMenu.addSeparator();
                menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.97"));
                menuItem.addActionListener(new _CmdListener("changeFeatures"));
                popupMenu.add(menuItem);
            }
        } else if (krnl.getCmdExecutionStatus() > 1) {
            JMenuItem menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.99"));
            menuItem.addActionListener(new _CmdListener("#cancel()", 0));
            popupMenu.add(menuItem);
            menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.101"));
            menuItem.addActionListener(new _CmdListener("#interrupt()", 0));
            popupMenu.add(menuItem);
            popupMenu.addSeparator();
            menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.103"));
            menuItem.addActionListener(new _CmdListener("winfit " + drawPanel.getId()));
            popupMenu.add(menuItem);
            menuItem = new JMenuItem(Messages.getString("kernel.cmds.ContextMenu.105"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Kernel.Listener l = new Kernel.Listener(){
                        int m_i = 0;

                        @Override
                        public void tokenConsumed(CmdLineToken token) {
                            if (++this.m_i == 2) {
                                krnl.addArgument(new WindowToken(drawPanel.getId()));
                            }
                        }

                        @Override
                        public void cmdEnds(String cmdName) {
                            krnl.removeListener(this);
                        }
                    };
                    krnl.addListener(l);
                    if (s_inputDevice.isEnabled()) {
                        s_inputDevice.fireInterruptingInput("winzoom;setagain winzoom");
                    }
                }
            });
            popupMenu.add(menuItem);
            CmdLineDialog cld = ui.getActiveCmdLineDialogAt(1);
            if (cld != null) {
                Iterator<CmdLineDialog.ContextMenuListener> cmit = cld.contextMenuListenerIterator();
                while (cmit.hasNext()) {
                    cmit.next().extendContextMenu(popupMenu);
                }
            }
        }
        final Component comp = drawPanel != null && drawPanel instanceof JPanel ? (Component)((Object)drawPanel) : (Component)((Object)ui);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                popupMenu.show(comp, pos.x, pos.y);
            }
        });
    }

    protected class _CmdListener
    implements ActionListener {
        private String m_cmd = null;
        private int m_inputType = 2;

        public _CmdListener(String cmd) {
            this.m_cmd = cmd;
        }

        public _CmdListener(String cmd, int inputType) {
            this.m_cmd = cmd;
            this.m_inputType = inputType;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (s_inputDevice.isEnabled()) {
                switch (this.m_inputType) {
                    case 1: {
                        s_inputDevice.fireInput(String.valueOf(this.m_cmd) + ";setagain " + this.m_cmd);
                        break;
                    }
                    case 2: {
                        s_inputDevice.fireInterruptingInput(String.valueOf(this.m_cmd) + ";setagain " + this.m_cmd);
                        break;
                    }
                    default: {
                        s_inputDevice.fireInput(this.m_cmd);
                    }
                }
            }
        }
    }
}

