/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.ClonedBindingContext;
import cib.cad.db.ComponentBinding;
import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.Group;
import cib.cad.db.layer.Layer;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.NameSpace;
import cib.util.binding.Binding;
import cib.util.binding.BindingModel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.coll.ReverseAccessMap;
import cib.util.coll.SwappableList;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Copy
implements Cmd {
    protected String m_toString = null;
    private boolean m_changesState = false;
    protected AffineTransform m_mat = null;
    private static Set<Listener> s_listeners = new HashSet<Listener>();
    protected Map<Component, List<Component>> m_componentMap = new HashMap<Component, List<Component>>();
    protected Map<Component, Binding<Component>> m_clonedBindingMap = new HashMap<Component, Binding<Component>>();

    /*
     * WARNING - void declaration
     */
    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        void var11_17;
        List<Component> dstList;
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        NameSpace ns = db.getNameSpace();
        ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
        if (selSet.isEmpty()) {
            System.out.println(Messages.getString("kernel.cmds.Copy.0"));
            return;
        }
        this._notifyPreDoCopy();
        if (selSet.isEmpty()) {
            this.m_toString = Messages.getString("kernel.cmds.Copy.0a");
            this._notifyPostDoCopy();
            return;
        }
        this.m_changesState = true;
        this._copy(context, this.m_componentMap);
        Set<Component> srcSet = this.m_componentMap.keySet();
        for (Component src : srcSet) {
            dstList = this.m_componentMap.get(src);
            for (Component component : dstList) {
                if (!(src instanceof Group) || !(component instanceof Group)) continue;
                this._setPartNamesRecursively((Group)src, (Group)component, ns);
            }
        }
        for (Component src : srcSet) {
            dstList = this.m_componentMap.get(src);
            for (Component component : dstList) {
                Layer layer = (Layer)layerMap.get(src);
                if (layer != null) {
                    layerMap.put(component, layer);
                }
                if (!(src instanceof Group) || !(component instanceof Group)) continue;
                this._setPartLayersRecursively((Group)src, (Group)component, layerMap);
            }
        }
        ArrayList<Component> srcList = new ArrayList<Component>();
        SwappableList<Component> cmpList = db.getComponentList();
        for (Component comp : cmpList) {
            if (!srcSet.contains(comp)) continue;
            srcList.add(comp);
        }
        int nClones = this.m_componentMap.get(srcList.get(0)).size();
        boolean bl = false;
        while (var11_17 < nClones) {
            Component previousDst = null;
            for (Component src : srcList) {
                int j;
                int i;
                List<Component> dstList2 = this.m_componentMap.get(src);
                Component dst = dstList2.get((int)var11_17);
                if (previousDst != null && (i = cmpList.indexOf(previousDst)) > (j = cmpList.indexOf(dst))) {
                    cmpList.swap(i, j);
                    Component _dst = dst;
                    dst = previousDst;
                    previousDst = _dst;
                }
                previousDst = dst;
            }
            ++var11_17;
        }
        ClonedBindingContext clonedBindingContext = new ClonedBindingContext();
        clonedBindingContext.setCloningMap(this.m_componentMap);
        BindingModel<Component> bindingModel = db.getBindingModel();
        Set<Component> originals = this.m_componentMap.keySet();
        for (Component original : originals) {
            if (!bindingModel.containsKey(original)) continue;
            ComponentBinding b = (ComponentBinding)bindingModel.get(original);
            List<Component> clones = this.m_componentMap.get(original);
            for (Component clone : clones) {
                ComponentBinding bCloned = (ComponentBinding)b.clone();
                bindingModel.put(clone, bCloned);
                clonedBindingContext.setBindingModel(bindingModel);
                clonedBindingContext.setOriginalBinding(b);
                bCloned.updateClonedBinding(clonedBindingContext);
                this.m_clonedBindingMap.put(clone, (Binding)bCloned.clone());
            }
        }
    }

    protected abstract void _copy(Object var1, Map<Component, List<Component>> var2) throws CmdAbortedException;

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        Collection<List<Component>> compLists = this.m_componentMap.values();
        for (List<Component> comps : compLists) {
            cmpSet.removeAll(comps);
        }
        BindingModel<Component> bindingModel = db.getBindingModel();
        Set<Component> clones = this.m_clonedBindingMap.keySet();
        for (Component clone : clones) {
            bindingModel.remove(clone);
        }
        this._notifyPostUndoCopy();
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
        Collection<List<Component>> compLists = this.m_componentMap.values();
        for (List<Component> comps : compLists) {
            cmpSet.addAll(comps);
        }
        Set<Component> srcSet = this.m_componentMap.keySet();
        for (Component src : srcSet) {
            List<Component> dstList = this.m_componentMap.get(src);
            for (Component dst : dstList) {
                layerMap.put(dst, (Layer)layerMap.get(src));
            }
        }
        BindingModel<Component> bindingModel = db.getBindingModel();
        Set<Component> clones = this.m_clonedBindingMap.keySet();
        for (Component clone : clones) {
            Binding<Component> bCloned = this.m_clonedBindingMap.get(clone);
            bindingModel.put(clone, (Binding)bCloned.clone());
        }
        this._notifyPostRedoCopy();
    }

    @Override
    public boolean changesState() {
        return this.m_changesState;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    protected void _notifyPreDoCopy() {
        for (Listener l : s_listeners) {
            l.preDoCopy(this);
        }
    }

    protected void _notifyPostDoCopy() {
        for (Listener l : s_listeners) {
            l.postDoCopy(this, this.m_componentMap);
        }
    }

    protected void _notifyPostUndoCopy() {
        for (Listener l : s_listeners) {
            l.postUndoCopy(this, this.m_componentMap);
        }
    }

    protected void _notifyPostRedoCopy() {
        for (Listener l : s_listeners) {
            l.postRedoCopy(this, this.m_componentMap);
        }
    }

    public static boolean addListener(Listener l) {
        return s_listeners.add(l);
    }

    public static boolean removeListener(Listener l) {
        return s_listeners.remove(l);
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void _setPartNamesRecursively(Group srcGroup, Group dstGroup, NameSpace ns) {
        SwappableList<Component> srcGroupList = srcGroup.getComponentList();
        SwappableList<Component> dstGroupList = dstGroup.getComponentList();
        int n = srcGroupList.size();
        if (n == dstGroupList.size()) {
            int i = 0;
            while (i < n) {
                Component src = (Component)srcGroupList.get(i);
                Component dst = (Component)dstGroupList.get(i);
                if (!ns.containsObject(dst)) {
                    ns.put(dst, ns.generateName());
                }
                if (src instanceof Group && dst instanceof Group) {
                    this._setPartNamesRecursively((Group)src, (Group)dst, ns);
                }
                ++i;
            }
        }
    }

    private void _setPartLayersRecursively(Group srcGroup, Group dstGroup, ReverseAccessMap<Component, Layer> layerMap) {
        SwappableList<Component> srcGroupList = srcGroup.getComponentList();
        SwappableList<Component> dstGroupList = dstGroup.getComponentList();
        int n = srcGroupList.size();
        if (n == dstGroupList.size()) {
            int i = 0;
            while (i < n) {
                Component src = (Component)srcGroupList.get(i);
                Component dst = (Component)dstGroupList.get(i);
                layerMap.put(dst, (Layer)layerMap.get(src));
                if (src instanceof Group && dst instanceof Group) {
                    this._setPartLayersRecursively((Group)src, (Group)dst, layerMap);
                }
                ++i;
            }
        }
    }

    public static interface Listener {
        public void preDoCopy(Copy var1);

        public void postDoCopy(Copy var1, Map<Component, List<Component>> var2);

        public void postUndoCopy(Copy var1, Map<Component, List<Component>> var2);

        public void postRedoCopy(Copy var1, Map<Component, List<Component>> var2);
    }
}

