/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.MarkerMap;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.db.layer.Layer;
import cib.cad.db.layer.LayerManager;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.AttributedImage;
import cib.util.AttributedShape;
import cib.util.AttributedText;
import cib.util.CoordSpace;
import cib.util.NameSpace;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import cib.util.coll.ReverseAccessMap;
import cib.util.geo.Geo2D;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.File;
import java.text.AttributedCharacterIterator;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;

public class DumpComponents
extends CmdAdapter {
    private final double PT_PER_IN = 72.0;
    private final double IN_PER_M = 39.37;
    private double m_scale = 50.0;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        NameSpace ns = db.getNameSpace();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
        CoordSpace cs = db.getCoordSpace();
        AttributeManager am = AttributeManager.getAttributeManager();
        LayerManager lm = LayerManager.getLayerManager();
        this.m_scale = cs.getScale();
        if (selSet.isEmpty()) {
            krnl.readOK(Messages.getString("kernel.cmds.DumpComponents.0"), Messages.getString("kernel.cmds.DumpComponents.1"), Messages.getString("kernel.cmds.DumpComponents.2"), 6);
            return;
        }
        String status = "";
        for (Component c : selSet) {
            double[] m;
            status = String.valueOf(status) + ns.getName(c) + Messages.getString("kernel.cmds.DumpComponents.4") + c.getClass().getName() + "\n";
            status = String.valueOf(status) + "\t" + Messages.getString("kernel.cmds.DumpComponents.5") + Integer.toHexString(c.hashCode()) + "\n";
            Layer l = (Layer)layerMap.get(c);
            String layerName = lm.getLayerName(l);
            status = String.valueOf(status) + "\t" + Messages.getString("kernel.cmds.DumpComponents.7") + lm.getLocalizedLayerName(layerName) + Messages.getString("kernel.cmds.DumpComponents.8") + " <" + lm.getLocalizedLayerSemantics(layerName) + ">\n";
            Attributes drawAttr = c.getAttributes();
            if (drawAttr != null) {
                status = String.valueOf(status) + "\t" + Messages.getString("kernel.cmds.DumpComponents.11.1");
                status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.11.3") + am.getLocalizedLinePatternName(drawAttr.getLinePattern()) + "\n";
                status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.11.6") + am.getLocalizedLineWidthName(drawAttr.getLineWidth()) + "\n";
                status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.11.9") + am.getLocalizedDrawPaintName(drawAttr.getDrawPaint()) + "\n";
                status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.11.12") + am.getLocalizedFillPaintName(drawAttr.getFillPaint()) + "\n";
                status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.11.15") + am.getLocalizedFontFamilyName(drawAttr.getFontFamily()) + "\n";
                status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.11.18") + am.getLocalizedTextSizeName(drawAttr.getTextSize()) + "\n";
                status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.11.21") + am.getLocalizedVisibilityName(drawAttr.getVisibility()) + "\n";
            }
            NamedListIterator<AttributedShape> shapeIt = c.shapeIterator();
            while (shapeIt.hasNext()) {
                status = String.valueOf(status) + "\t" + Messages.getString("kernel.cmds.DumpComponents.15") + "\n";
                Shape shape = (Shape)shapeIt.next();
                double[] crds = new double[6];
                PathIterator pit = shape.getPathIterator(null);
                while (!pit.isDone()) {
                    int seg = pit.currentSegment(crds);
                    switch (seg) {
                        case 0: {
                            status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.17") + Geo2D.formatCoordinate(crds[0]) + " " + Geo2D.formatCoordinate(crds[1]) + "\n";
                            break;
                        }
                        case 1: {
                            status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.21") + Geo2D.formatCoordinate(crds[0]) + " " + Geo2D.formatCoordinate(crds[1]) + "\n";
                            break;
                        }
                        case 2: {
                            status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.25") + Geo2D.formatCoordinate(crds[0]) + " " + Geo2D.formatCoordinate(crds[1]) + " " + Geo2D.formatCoordinate(crds[2]) + " " + Geo2D.formatCoordinate(crds[3]) + "\n";
                            break;
                        }
                        case 3: {
                            status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.31") + Geo2D.formatCoordinate(crds[0]) + " " + Geo2D.formatCoordinate(crds[1]) + " " + Geo2D.formatCoordinate(crds[2]) + " " + Geo2D.formatCoordinate(crds[3]) + " " + Geo2D.formatCoordinate(crds[4]) + " " + Geo2D.formatCoordinate(crds[5]) + "\n";
                            break;
                        }
                        case 4: {
                            status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.39") + "\n";
                            break;
                        }
                        default: {
                            status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.42") + "\n";
                        }
                    }
                    pit.next();
                }
            }
            NamedListIterator<AttributedText> textIt = c.textIterator();
            while (textIt.hasNext()) {
                AttributedText text = (AttributedText)textIt.next();
                if (text == null) continue;
                AttributedCharacterIterator acit = text.getAttributedString().getIterator();
                StringBuffer buf = new StringBuffer();
                char chr = acit.first();
                while (chr != '\uffff') {
                    buf.append(chr);
                    chr = acit.next();
                }
                status = String.valueOf(status) + "\t" + Messages.getString("kernel.cmds.DumpComponents.45") + " <" + buf + ">\n";
                int runLimit = 0;
                while (acit.setIndex(runLimit) != '\uffff') {
                    int runStart = acit.getIndex();
                    runLimit = acit.getRunLimit();
                    status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.49") + runStart + Messages.getString("kernel.cmds.DumpComponents.50") + (runLimit - 1) + ":\n";
                    Map<AttributedCharacterIterator.Attribute, Object> map = acit.getAttributes();
                    for (AttributedCharacterIterator.Attribute attr : map.keySet()) {
                        Object value = map.get(attr);
                        if (attr.equals(TextAttribute.SIZE) && value instanceof Number) {
                            NumberFormat nf = NumberFormat.getInstance(Locale.ENGLISH);
                            nf.setMaximumFractionDigits(2);
                            nf.setMinimumFractionDigits(2);
                            value = nf.format(((Number)value).doubleValue() / 72.0 / 39.37 / this.m_scale * cs.getMillimetersPerNaturalUnit());
                        }
                        status = String.valueOf(status) + "\t\t\t" + attr + Messages.getString("kernel.cmds.DumpComponents.53") + value + "\n";
                    }
                }
                switch (text.getJustification()) {
                    case 0: {
                        status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.56") + "\n";
                        break;
                    }
                    case 9: {
                        status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.59") + "\n";
                        break;
                    }
                    case 1: {
                        status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.62") + "\n";
                        break;
                    }
                    case 2: {
                        status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.65") + "\n";
                        break;
                    }
                    case 3: {
                        status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.68") + "\n";
                        break;
                    }
                    case 10: {
                        status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.71") + "\n";
                        break;
                    }
                    case 4: {
                        status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.74") + "\n";
                        break;
                    }
                    case 5: {
                        status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.77") + "\n";
                        break;
                    }
                    case 6: {
                        status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.80") + "\n";
                        break;
                    }
                    case 11: {
                        status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.83") + "\n";
                        break;
                    }
                    case 7: {
                        status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.86") + "\n";
                        break;
                    }
                    case 8: {
                        status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.89") + "\n";
                        break;
                    }
                    default: {
                        status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.92") + "\n";
                    }
                }
                status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.95") + "\n";
                AffineTransform trf = text.getTransform();
                m = new double[6];
                trf.getMatrix(m);
                status = String.valueOf(status) + "\t\t\t" + Geo2D.formatCoordinate(m[0]) + "  " + Geo2D.formatCoordinate(m[2]) + "  " + Geo2D.formatCoordinate(m[4]) + "\n";
                status = String.valueOf(status) + "\t\t\t" + Geo2D.formatCoordinate(m[1]) + "  " + Geo2D.formatCoordinate(m[3]) + "  " + Geo2D.formatCoordinate(m[5]) + "\n";
                status = String.valueOf(status) + "\t\t\t0.0  0.0  1.0\n";
            }
            NamedListIterator<AttributedImage> imageIt = c.imageIterator();
            while (imageIt.hasNext()) {
                AttributedImage image = (AttributedImage)imageIt.next();
                File originalImageFile = image.getOriginalImageFile();
                status = String.valueOf(status) + "\t" + Messages.getString("kernel.cmds.DumpComponents.110") + originalImageFile.getName() + "\n";
                File physicalImageFile = image.getPhysicalImageFile();
                status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.113") + physicalImageFile.getAbsolutePath() + "\n";
                status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.116") + Geo2D.formatCoordinate(image.getWidth()) + Messages.getString("kernel.cmds.DumpComponents.117") + Geo2D.formatCoordinate(image.getHeight()) + "\n";
                status = String.valueOf(status) + "\t\t" + Messages.getString("kernel.cmds.DumpComponents.120") + "\n";
                AffineTransform trf = image.getTransform();
                m = new double[6];
                trf.getMatrix(m);
                status = String.valueOf(status) + "\t\t\t" + Geo2D.formatCoordinate(m[0]) + "  " + Geo2D.formatCoordinate(m[2]) + "  " + Geo2D.formatCoordinate(m[4]) + "\n";
                status = String.valueOf(status) + "\t\t\t" + Geo2D.formatCoordinate(m[1]) + "  " + Geo2D.formatCoordinate(m[3]) + "  " + Geo2D.formatCoordinate(m[5]) + "\n";
                status = String.valueOf(status) + "\t\t\t0.0  0.0  1.0\n";
            }
            MarkerMap mm = db.getMarkerMap();
            NamedListIterator<Point2D> ctrlPntIt = c.controlPointIterator();
            if (ctrlPntIt.hasNext()) {
                status = String.valueOf(status) + "\t" + Messages.getString("kernel.cmds.DumpComponents.134") + "\n";
            }
            while (ctrlPntIt.hasNext()) {
                int index = ctrlPntIt.nextIndex();
                int name = ctrlPntIt.nextName();
                boolean marked = mm.primitiveMarked(c, 2, index);
                String ctrlPointTypeString = "";
                if (c instanceof CtrlSegments) {
                    CtrlSegments ctrlSegs = (CtrlSegments)c;
                    int ctrlPointType = ctrlSegs.getCtrlType(name);
                    ctrlPointTypeString = ctrlPointType == 1 ? Messages.getString("kernel.cmds.DumpComponents.137") : (ctrlPointType == 2 ? Messages.getString("kernel.cmds.DumpComponents.138") : (ctrlPointType == 4 ? Messages.getString("kernel.cmds.DumpComponents.139") : (ctrlPointType == 8 ? Messages.getString("kernel.cmds.DumpComponents.140") : (ctrlPointType == 16 ? Messages.getString("kernel.cmds.DumpComponents.141") : (ctrlPointType == 32 ? Messages.getString("kernel.cmds.DumpComponents.142") : (ctrlPointType == 64 ? Messages.getString("kernel.cmds.DumpComponents.143") : (ctrlPointType == 128 ? Messages.getString("kernel.cmds.DumpComponents.144") : Messages.getString("kernel.cmds.DumpComponents.145"))))))));
                }
                Point2D ctrlPnt = (Point2D)ctrlPntIt.next();
                status = String.valueOf(status) + "\t\t" + (marked ? ">" : " ") + Integer.valueOf(index) + " \"" + Integer.valueOf(name) + "\" " + Geo2D.formatCoordinate(ctrlPnt.getX()) + " " + Geo2D.formatCoordinate(ctrlPnt.getY()) + " " + ctrlPointTypeString + "\n";
            }
            status = String.valueOf(status) + "\n";
        }
        status = String.valueOf(status) + selSet.size() + Messages.getString("kernel.cmds.DumpComponents.155") + (selSet.size() == 1 ? "" : Messages.getString("kernel.cmds.DumpComponents.157")) + Messages.getString("kernel.cmds.DumpComponents.158") + cmpSet.size() + Messages.getString("kernel.cmds.DumpComponents.159") + (cmpSet.size() == 1 ? "" : Messages.getString("kernel.cmds.DumpComponents.161")) + ".\n";
        krnl.readOK(Messages.getString("kernel.cmds.DumpComponents.163"), Messages.getString("kernel.cmds.DumpComponents.164"), status, 6);
    }
}

