/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.coll.SwappableList;
import java.util.HashSet;
import java.util.Set;

public class PosBackward
implements Cmd {
    private Set<Component> m_componentsNotMoved = new HashSet<Component>();
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        SwappableList<Component> cmpList = db.getComponentList();
        if (selSet.isEmpty()) {
            System.err.println(Messages.getString("kernel.cmds.PosBackward.0"));
            return;
        }
        int minIndex = 0;
        int i = 0;
        while (i < cmpList.size()) {
            Component comp = (Component)cmpList.get(i);
            if (selSet.contains(comp)) {
                if (i - 1 >= minIndex) {
                    cmpList.swap(i, i - 1);
                } else {
                    this.m_componentsNotMoved.add(comp);
                }
                ++minIndex;
            }
            ++i;
        }
        this.m_toString = String.valueOf(Messages.getString("kernel.cmds.PosBackward.1")) + selSet.size() + Messages.getString("kernel.cmds.PosBackward.2");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        SwappableList<Component> cmpList = db.getComponentList();
        int i = cmpList.size() - 2;
        while (i >= 0) {
            Component comp = (Component)cmpList.get(i);
            if (selSet.contains(comp) && !this.m_componentsNotMoved.contains(comp)) {
                cmpList.swap(i, i + 1);
            }
            --i;
        }
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        SwappableList<Component> cmpList = db.getComponentList();
        int i = 0;
        while (i < cmpList.size()) {
            Component comp = (Component)cmpList.get(i);
            if (selSet.contains(comp) && !this.m_componentsNotMoved.contains(comp)) {
                cmpList.swap(i, i - 1);
            }
            ++i;
        }
    }

    @Override
    public boolean changesState() {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        return !selSet.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

