/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.Print;
import cib.cad.kernel.cmds.PrintCrossPlatform;
import cib.cad.kernel.cmds.PrintDefault;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;

public class PrintSelector
implements Cmd {
    private Cmd m_printCmd = null;
    private int m_input = -1;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        do {
            CmdLineDialog dlg = ui.getCmdLineDialog();
            dlg.setUniqueName("kernel.cmds.PrintSelector-menu0");
            dlg.setPrompt(Messages.getString("kernel.cmds.PrintSelector.1"));
            dlg.setDefaultChoice(dlg.addChoice("Method 1"));
            dlg.addChoice("Method 2");
            dlg.addChoice("Method 3");
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    PrintSelector.this.m_input = iChoice;
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    PrintSelector.this.m_input = -1;
                    ui.disposeCmdLineDialog();
                }
            });
            ui.showCmdLineDialog(dlg);
            if (this.m_input == -1) {
                throw new CmdAbortedException();
            }
            if (this.m_input == 0) {
                this.m_printCmd = new Print();
                this.m_printCmd.doCmd(context);
                return;
            }
            if (this.m_input != 1) continue;
            this.m_printCmd = new PrintCrossPlatform();
            this.m_printCmd.doCmd(context);
            return;
        } while (this.m_input != 2);
        this.m_printCmd = new PrintDefault();
        this.m_printCmd.doCmd(context);
    }

    @Override
    public void undoCmd(Object context) {
        if (this.m_printCmd != null) {
            this.m_printCmd.undoCmd(context);
        }
    }

    @Override
    public void redoCmd(Object context) {
        if (this.m_printCmd != null) {
            this.m_printCmd.redoCmd(context);
        }
    }

    @Override
    public boolean changesState() {
        return this.m_printCmd != null ? this.m_printCmd.changesState() : false;
    }

    @Override
    public boolean isUndoable() {
        return this.m_printCmd != null ? this.m_printCmd.isUndoable() : true;
    }
}

