/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.Component;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UndoableCmd;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.util.SelectFilter;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.CollUtilities;
import cib.util.coll.IteratorFilter;
import cib.util.coll.ObservableSet;
import java.util.Iterator;

public class SelectAll
extends UndoableCmd {
    private String m_toString = null;
    private int m_action = -1;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        IteratorFilter<Component> filter = null;
        do {
            CmdLineDialog dlg = ui.getCmdLineDialog();
            dlg.setUniqueName("kernel.cmds.SelectAll-menu0");
            dlg.setPrompt(Messages.getString("kernel.cmds.SelectAll.1"));
            int iChoice = dlg.addChoice("Filter");
            if (filter != null) {
                dlg.setChoiceChecked(iChoice);
            }
            dlg.setDefaultChoice(dlg.addChoice("Done"));
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    SelectAll.this.m_action = iChoice;
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    SelectAll.this.m_action = -1;
                    ui.disposeCmdLineDialog();
                }
            });
            ui.showCmdLineDialog(dlg);
            if (this.m_action == 0) {
                filter = filter == null ? new SelectFilter().showDialog() : null;
                continue;
            }
            if (this.m_action != -1) continue;
            throw new CmdAbortedException();
        } while (this.m_action != 1);
        if (filter == null) {
            filter = new IteratorFilter<Component>(){
                private AttributeManager m_atm = AttributeManager.getAttributeManager();

                @Override
                public boolean matches(Component c) {
                    if (c == null) {
                        return false;
                    }
                    Attributes attr = c.getAttributes();
                    return attr == null ? true : this.m_atm.getVisibility(attr.getVisibility());
                }
            };
        }
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        Iterator it = cmpSet.iterator();
        Iterator<Component> fit = CollUtilities.filterableIterator(it, filter);
        while (fit.hasNext()) {
            Component o = fit.next();
            if (selSet.contains(o)) continue;
            this._saveSelectState(o);
            selSet.add(o);
        }
        int n = this._numberOfSavedSelectStates();
        this.m_toString = n > 0 ? String.valueOf(n) + (n == 1 ? Messages.getString("kernel.cmds.SelectAll.5") : Messages.getString("kernel.cmds.SelectAll.6")) + Messages.getString("kernel.cmds.SelectAll.7") : Messages.getString("kernel.cmds.SelectAll.8");
        System.out.println(this);
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

