/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.AddMouseStrokeInputDevice;
import cib.cad.lang.Messages;
import cib.cad.view.Desktop;
import cib.cad.view.GraphicalUserInterface;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;

public class SetDrawPanelLayout
extends CmdAdapter {
    private String m_toString = null;
    private int m_layoutPattern = 0;
    private int m_input;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        GraphicalUserInterface gui = (GraphicalUserInterface)ui;
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setUniqueName("kernel.cmds.SetDrawPanelLayout-menu0");
        dlg.setPrompt(Messages.getString("kernel.cmds.SetDrawPanelLayout.2"));
        dlg.setChoiceHints(dlg.addChoice("1"), Messages.getString("kernel.cmds.SetDrawPanelLayout.4"));
        dlg.setChoiceHints(dlg.addChoice("2V"), Messages.getString("kernel.cmds.SetDrawPanelLayout.6"));
        dlg.setChoiceHints(dlg.addChoice("2H"), Messages.getString("kernel.cmds.SetDrawPanelLayout.8"));
        dlg.setChoiceHints(dlg.setDefaultChoice(dlg.addChoice("3")), Messages.getString("kernel.cmds.SetDrawPanelLayout.10"));
        dlg.setChoiceHints(dlg.addChoice("4"), Messages.getString("kernel.cmds.SetDrawPanelLayout.12"));
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                SetDrawPanelLayout.this.m_input = iChoice;
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                SetDrawPanelLayout.this.m_input = -1;
                ui.disposeCmdLineDialog();
            }
        });
        ui.showCmdLineDialog(dlg);
        switch (this.m_input) {
            case 0: {
                this._setLayout(gui, 1);
                this.m_toString = Messages.getString("kernel.cmds.SetDrawPanelLayout.13");
                break;
            }
            case 1: {
                this._setLayout(gui, 2);
                this.m_toString = Messages.getString("kernel.cmds.SetDrawPanelLayout.14");
                break;
            }
            case 2: {
                this._setLayout(gui, 3);
                this.m_toString = Messages.getString("kernel.cmds.SetDrawPanelLayout.15");
                break;
            }
            case 3: {
                this._setLayout(gui, 4);
                this.m_toString = Messages.getString("kernel.cmds.SetDrawPanelLayout.16");
                break;
            }
            case 4: {
                this._setLayout(gui, 5);
                this.m_toString = Messages.getString("kernel.cmds.SetDrawPanelLayout.17");
                break;
            }
            case -1: {
                throw new CmdAbortedException();
            }
        }
        System.out.println(this.m_toString);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        GraphicalUserInterface gui = (GraphicalUserInterface)krnl.getUserInterface();
        this._setLayout(gui, this.m_layoutPattern);
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return this.m_layoutPattern != 0;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void _setLayout(GraphicalUserInterface gui, int layoutPattern) {
        AddMouseStrokeInputDevice mouseStrokeInputDevice = AddMouseStrokeInputDevice.getInstance();
        if (mouseStrokeInputDevice != null) {
            mouseStrokeInputDevice.setEnabled(false);
        }
        Desktop desktop = gui.getDesktop();
        this.m_layoutPattern = desktop.getLayoutPattern();
        desktop.setLayoutPattern(layoutPattern);
        if (mouseStrokeInputDevice != null) {
            mouseStrokeInputDevice.setEnabled(true);
        }
        gui.repaintUserInterface();
    }
}

