/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.util.CoordSpace;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.geo.Geo2D;

public class SetNaturalUnit
implements Cmd {
    private static final String PROP = "SetNaturalUnit.mmPerNU";
    private double m_mmPerNaturalUnit = Double.NaN;
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        CoordSpace cs = db.getCoordSpace();
        final UserInterface ui = krnl.getUserInterface();
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setUniqueName("kernel.cmds.SetNaturalUnit-menu0");
        dlg.setPrompt(Messages.getString("kernel.cmds.SetNaturalUnit.1"));
        dlg.setDefaultText(Messages.getString("kernel.cmds.SetNaturalUnit.0"));
        dlg.addChoice("mm");
        dlg.addChoice("cm");
        dlg.setDefaultChoice(dlg.addChoice("m"));
        dlg.addChoice("km");
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void textEntered(String text) {
                try {
                    SetNaturalUnit.this.m_mmPerNaturalUnit = Double.parseDouble(text);
                }
                catch (NumberFormatException e) {
                    return;
                }
                if (SetNaturalUnit.this.m_mmPerNaturalUnit <= Geo2D.getEps()) {
                    System.err.println(Messages.getString("kernel.cmds.SetNaturalUnit.7"));
                } else {
                    ui.disposeCmdLineDialog();
                }
            }

            @Override
            public void choiceSelected(int iChoice) {
                if (iChoice == 0) {
                    SetNaturalUnit.this.m_mmPerNaturalUnit = 1.0;
                } else if (iChoice == 1) {
                    SetNaturalUnit.this.m_mmPerNaturalUnit = 10.0;
                } else if (iChoice == 2) {
                    SetNaturalUnit.this.m_mmPerNaturalUnit = 1000.0;
                } else if (iChoice == 3) {
                    SetNaturalUnit.this.m_mmPerNaturalUnit = 1000000.0;
                } else {
                    return;
                }
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                SetNaturalUnit.this.m_mmPerNaturalUnit = Double.NaN;
                ui.disposeCmdLineDialog();
            }
        });
        ui.showCmdLineDialog(dlg);
        if (Double.isNaN(this.m_mmPerNaturalUnit)) {
            throw new CmdAbortedException();
        }
        double mmPerNaturalUnit = this.m_mmPerNaturalUnit;
        this.m_mmPerNaturalUnit = cs.getMillimetersPerNaturalUnit();
        cs.setMillimetersPerNaturalUnit(mmPerNaturalUnit, null, true);
        SetNaturalUnit.setDefaultMmPerNaturalUnit(mmPerNaturalUnit);
        ui.repaintUserInterface();
        this.m_toString = String.valueOf(Messages.getString("kernel.cmds.SetNaturalUnit.8")) + cs.getMillimetersPerNaturalUnit() + Messages.getString("kernel.cmds.SetNaturalUnit.9");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        CoordSpace cs = db.getCoordSpace();
        UserInterface ui = krnl.getUserInterface();
        double mmPerNaturalUnit = this.m_mmPerNaturalUnit;
        this.m_mmPerNaturalUnit = cs.getMillimetersPerNaturalUnit();
        cs.setMillimetersPerNaturalUnit(mmPerNaturalUnit, null, true);
        ui.repaintUserInterface();
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return !Double.isNaN(this.m_mmPerNaturalUnit);
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    public static double getDefaultMmPerNaturalUnit() {
        try {
            Kernel krnl = Kernel.getInstance();
            return Double.parseDouble(krnl.getProperty(PROP, "1000"));
        }
        catch (NumberFormatException numberFormatException) {
            return 1000.0;
        }
    }

    public static void setDefaultMmPerNaturalUnit(double mmPerNU) {
        Kernel krnl = Kernel.getInstance();
        krnl.setProperty(PROP, String.valueOf(mmPerNU));
    }
}

