/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.util.CoordSpace;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;

public class SetScale
implements Cmd {
    private static final String PROP = "SetScale.scale";
    private double m_svScale;
    private String m_toString = null;
    private transient Object m_input;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        final Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        Database db = krnl.getDatabase();
        CoordSpace cs = db.getCoordSpace();
        this.m_svScale = cs.getScale();
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setUniqueName("kernel.cmds.SetScale-menu0");
        dlg.setPrompt(Messages.getString("kernel.cmds.SetScale.1"));
        dlg.enableTextInput();
        dlg.addChoice("1:1");
        dlg.addChoice("1:5");
        dlg.addChoice("1:10");
        dlg.addChoice("1:20");
        dlg.addChoice("1:25");
        dlg.addChoice("1:50");
        dlg.setDefaultChoice(dlg.addChoice("1:100"));
        dlg.addChoice("1:200");
        dlg.addChoice("1:500");
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void textEntered(String text) {
                try {
                    Number number = krnl.getNumberInterpreter().getNumber(text);
                    double scale = number.doubleValue();
                    if (scale < 0.5) {
                        System.err.println(Messages.getString("kernel.cmds.SetScale.11"));
                    } else {
                        SetScale.this.m_input = number;
                        ui.disposeCmdLineDialog();
                    }
                }
                catch (IllegalArgumentException e) {
                    System.err.println(Messages.getString("kernel.cmds.SetScale.12"));
                }
            }

            @Override
            public void choiceSelected(int iChoice) {
                double scale;
                switch (iChoice) {
                    case 0: {
                        scale = 1.0;
                        break;
                    }
                    case 1: {
                        scale = 5.0;
                        break;
                    }
                    case 2: {
                        scale = 10.0;
                        break;
                    }
                    case 3: {
                        scale = 20.0;
                        break;
                    }
                    case 4: {
                        scale = 25.0;
                        break;
                    }
                    case 5: {
                        scale = 50.0;
                        break;
                    }
                    case 6: {
                        scale = 100.0;
                        break;
                    }
                    case 7: {
                        scale = 200.0;
                        break;
                    }
                    case 8: {
                        scale = 500.0;
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                SetScale.this.m_input = new Double(scale);
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                SetScale.this.m_input = new CmdAbortedException();
                ui.disposeCmdLineDialog();
            }
        });
        this.m_input = null;
        ui.showCmdLineDialog(dlg);
        if (this.m_input instanceof CmdAbortedException) {
            throw (CmdAbortedException)this.m_input;
        }
        double scale = ((Number)this.m_input).doubleValue();
        cs.setScale(scale);
        SetScale.setDefaultScale(scale);
        krnl.getUserInterface().repaintUserInterface();
        this.m_toString = String.valueOf(Messages.getString("kernel.cmds.SetScale.13")) + scale + Messages.getString("kernel.cmds.SetScale.14");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        CoordSpace cs = db.getCoordSpace();
        double scale = cs.getScale();
        cs.setScale(this.m_svScale);
        this.m_svScale = scale;
        krnl.getUserInterface().repaintUserInterface();
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    public static double getDefaultScale() {
        try {
            Kernel krnl = Kernel.getInstance();
            return Double.parseDouble(krnl.getProperty(PROP, "100"));
        }
        catch (NumberFormatException numberFormatException) {
            return 100.0;
        }
    }

    public static void setDefaultScale(double scale) {
        Kernel krnl = Kernel.getInstance();
        krnl.setProperty(PROP, String.valueOf(scale));
    }
}

