/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPanel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.view.Projection2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class WinMove
implements Cmd {
    private static final double EPS = 0.001;
    private int m_winMask = 0;
    private double m_moveX = 0.0;
    private double m_moveY = 0.0;
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        double moveX = krnl.readDouble(Messages.getString("kernel.cmds.WinMove.0"));
        double moveY = krnl.readDouble(Messages.getString("kernel.cmds.WinMove.1"));
        if (Math.abs(moveX) < 0.001 && Math.abs(moveY) < 0.001) {
            System.err.println(Messages.getString("kernel.cmds.WinMove.2"));
            return;
        }
        this.m_winMask = krnl.readWindowIds(Messages.getString("kernel.cmds.WinMove.3"));
        this.m_moveX = moveX;
        this.m_moveY = moveY;
        this.move(krnl);
        this.m_toString = Messages.getString("kernel.cmds.WinMove.4");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        this.m_moveX = -this.m_moveX;
        this.m_moveY = -this.m_moveY;
        this.move(krnl);
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return this.m_winMask != 0 && (Math.abs(this.m_moveX) > 0.001 || Math.abs(this.m_moveY) > 0.001);
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void move(Kernel krnl) {
        UserInterface ui = krnl.getUserInterface();
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            double y;
            DrawPanel drawPanel = (DrawPanel)it.next();
            if ((drawPanel.getId() & this.m_winMask) == 0) continue;
            Projection2D prj = drawPanel.getProjection();
            Rectangle2D rect = prj.getViewPort();
            double w = rect.getWidth();
            double h = rect.getHeight();
            double x = rect.getX() + this.m_moveX * w;
            if (!prj.setViewPort(x, y = rect.getY() + this.m_moveY * h, w, h)) {
                System.out.println(Messages.getString("kernel.cmds.WinMove.5"));
                continue;
            }
            drawPanel.setProjection(prj);
        }
    }
}

