/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPanel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.geo.Vector2D;
import cib.util.view.Projection2D;
import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class WinMoveByMouseWheel
implements Cmd {
    private DigitizeObject m_dig = null;
    private Rectangle2D m_vp = null;
    private Vector2D m_vec = null;
    private Point m_startLoc = new Point(0, 0);
    private Point m_endLoc = new Point(0, 0);
    private static final int WAIT = 400;
    private long m_timer = 0L;
    private String m_toString = null;
    private static boolean s_entered = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        try {
            Kernel krnl = (Kernel)context;
            WinMoveByMouseWheel winMoveByMouseWheel = this;
            synchronized (winMoveByMouseWheel) {
                if (s_entered) {
                    if (!krnl.hasArgument()) return;
                    krnl.consumeArgument();
                    return;
                }
                s_entered = true;
            }
            DigitizeObject dig = krnl.readDigitizeObject(Messages.getString("kernel.cmds.WinMoveByMouseWheel.0"));
            GeometryPanel panel = dig.getGeometryPanel();
            this.m_vp = (Rectangle2D)panel.getProjection().getViewPort().clone();
            this.m_dig = dig;
            if (!(panel instanceof DrawPanel)) return;
            DrawPanel dp = (DrawPanel)panel;
            boolean microscopeEnabled = dp.microscopeEnabled();
            if (microscopeEnabled) {
                dp.enableMicroscope(false);
            }
            MouseWheelListener mwl = new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    WinMoveByMouseWheel.this.m_timer = System.currentTimeMillis();
                    ((WinMoveByMouseWheel)WinMoveByMouseWheel.this).m_endLoc.y = e.getWheelRotation() > 0 ? (((WinMoveByMouseWheel)WinMoveByMouseWheel.this).m_endLoc.y -= 30) : (((WinMoveByMouseWheel)WinMoveByMouseWheel.this).m_endLoc.y += 30);
                    WinMoveByMouseWheel.this.m_vec = new Vector2D(WinMoveByMouseWheel.this.m_startLoc, WinMoveByMouseWheel.this.m_endLoc);
                    WinMoveByMouseWheel.this.move(WinMoveByMouseWheel.this.m_vec);
                }
            };
            dp.addMouseWheelListener(mwl);
            this.m_timer = System.currentTimeMillis();
            do {
                try {
                    Thread.sleep(80L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (System.currentTimeMillis() - this.m_timer <= 400L);
            dp.removeMouseWheelListener(mwl);
            if (this.m_dig == null) return;
            DrawPanel drawPanel = (DrawPanel)this.m_dig.getGeometryPanel();
            Projection2D prj = drawPanel.getProjection();
            AffineTransform v2m = prj.getViewToModel();
            Point2D.Double oldM = new Point2D.Double();
            Point2D.Double newM = new Point2D.Double();
            v2m.transform(this.m_startLoc, oldM);
            v2m.transform(this.m_endLoc, newM);
            double dx = ((Point2D)newM).getX() - ((Point2D)oldM).getX();
            double dy = ((Point2D)newM).getY() - ((Point2D)oldM).getY();
            double minU = prj.getMinU();
            double minV = prj.getMinV();
            double maxU = prj.getMaxU();
            double maxV = prj.getMaxV();
            if (!prj.setViewPort(minU - dx, minV - dy, maxU - minU, maxV - minV)) {
                this.m_toString = Messages.getString("kernel.cmds.WinMoveByMouseWheel.1");
            } else {
                drawPanel.setProjection(prj);
                this.m_toString = Messages.getString("kernel.cmds.WinMoveByMouseWheel.2");
            }
            System.out.println(this);
            if (!microscopeEnabled) return;
            dp.enableMicroscope(true);
            return;
        }
        finally {
            s_entered = false;
        }
    }

    @Override
    public void undoCmd(Object context) {
        Projection2D proj = this.m_dig.getGeometryPanel().getProjection();
        Rectangle2D _vp = (Rectangle2D)proj.getViewPort().clone();
        proj.setViewPort(this.m_vp);
        this.m_dig.getGeometryPanel().setProjection(proj);
        this.m_vp = _vp;
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean changesState() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void move(Vector2D vec) {
        DrawPanel drawPanel = (DrawPanel)this.m_dig.getGeometryPanel();
        AffineTransform trf = AffineTransform.getTranslateInstance(vec.x, vec.y);
        drawPanel.transformPanelImmediately(trf);
    }
}

