/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds.util;

import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.util.geo.Geo2D;
import cib.util.geo.Vector2D;
import cib.util.view.Projection2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;

public class AbsoluteAngleRubberBand
implements GeometryPanel.RubberbandListener {
    private UserInterface m_ui = null;
    private Line2D m_line = new Line2D.Double();
    private Map<JPanel, Graphics2D> m_panelToGfx = new HashMap<JPanel, Graphics2D>();

    public AbsoluteAngleRubberBand(Kernel krnl, Point2D pnt) {
        this.m_ui = krnl.getUserInterface();
        this.m_line.setLine(pnt, pnt);
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            JPanel panel = (JPanel)((Object)gp);
            Graphics2D gfx = (Graphics2D)panel.getGraphics();
            gfx.setXORMode(panel.getBackground());
            gfx.setColor(panel.getForeground());
            this.m_panelToGfx.put(panel, gfx);
            gp.addListener(this);
        }
    }

    @Override
    public void reset() {
        this.m_line.setLine(this.m_line.getP1(), this.m_line.getP1());
    }

    @Override
    public void paintStarts() {
        this._draw();
        this.m_line.setLine(this.m_line.getX1(), this.m_line.getY1(), this.m_line.getX1(), this.m_line.getY1());
    }

    @Override
    public void paintEnds() {
        this.m_line.setLine(this.m_line.getX1(), this.m_line.getY1(), this.m_line.getX1(), this.m_line.getY1());
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            JPanel panel = (JPanel)((Object)gp);
            Point p = panel.getMousePosition();
            if (p == null) continue;
            Point2D.Double pin = new Point2D.Double();
            Point2D.Double pout = new Point2D.Double();
            Projection2D prj2D = gp.getProjection();
            ((Point2D)pin).setLocation(((Point2D)p).getX(), ((Point2D)p).getY());
            prj2D.getViewToModel().transform(pin, pout);
            this.m_line.setLine(this.m_line.getX1(), this.m_line.getY1(), ((Point2D)pout).getX(), ((Point2D)pout).getY());
            break;
        }
        this._draw();
    }

    public void close() {
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            gp.removeListener(this);
            JPanel panel = (JPanel)((Object)gp);
            Graphics gfx = this.m_panelToGfx.get(panel);
            gfx.dispose();
        }
    }

    private void _draw() {
        if (Geo2D.length(this.m_line) >= Geo2D.getEps()) {
            Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
            while (it.hasNext()) {
                GeometryPanel panel = it.next();
                Graphics2D gfx = this.m_panelToGfx.get(panel);
                if (gfx == null) {
                    throw new InternalError("AbsoluteAngleRubberBand: gfx == null");
                }
                Projection2D prj2D = panel.getProjection();
                AffineTransform m2v = prj2D.getModelToView();
                double len = Geo2D.length(this.m_line);
                if (!(len > Geo2D.getEps())) continue;
                Vector2D v1 = new Vector2D(len, 0.0);
                Vector2D v3 = new Vector2D(this.m_line.getX1(), this.m_line.getY1(), this.m_line.getX2(), this.m_line.getY2());
                double angle = v1.getAngleCCW(v3);
                double startAngle = Vector2D.X_UNIT.getAngleCCW(v1);
                Vector2D v2 = new Vector2D(startAngle + 0.5 * angle);
                v2.scaleBy(len);
                Point2D apex = this.m_line.getP1();
                v1.add(apex);
                v2.add(apex);
                v3.add(apex);
                Arc2D arc = Geo2D.calculateArc2D(v1, v2, v3, new Arc2D.Double());
                gfx.draw(m2v.createTransformedShape(this.m_line));
                gfx.draw(m2v.createTransformedShape(new Line2D.Double(this.m_line.getP1(), v1)));
                if (arc == null) continue;
                gfx.draw(m2v.createTransformedShape(arc));
            }
        }
    }
}

