/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds.util;

import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.util.geo.Geo2D;
import cib.util.view.Projection2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;

public class CubicCurveRubberBand
implements GeometryPanel.RubberbandListener {
    private UserInterface m_ui = null;
    private CubicCurve2D m_curve = null;
    private Point2D[] m_curvePoints = new Point2D[]{new Point2D.Double(), new Point2D.Double(), new Point2D.Double(), new Point2D.Double()};
    private int m_curPoint = 0;
    private Map<JPanel, Graphics2D> m_panelToGfx = new HashMap<JPanel, Graphics2D>();

    public CubicCurveRubberBand(Kernel krnl, Point2D p1) {
        this.m_ui = krnl.getUserInterface();
        this.m_curvePoints[0].setLocation(p1);
        this.m_curvePoints[1].setLocation(p1);
        this.m_curvePoints[2].setLocation(p1);
        this.m_curvePoints[3].setLocation(p1);
        this.m_curPoint = 3;
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            JPanel panel = (JPanel)((Object)gp);
            Graphics2D gfx = (Graphics2D)panel.getGraphics();
            gfx.setXORMode(panel.getBackground());
            gfx.setColor(panel.getForeground());
            this.m_panelToGfx.put(panel, gfx);
            gp.addListener(this);
        }
    }

    public void setP4(Point2D p4) {
        this.m_curvePoints[3].setLocation(p4);
        this.m_curPoint = 1;
    }

    public void setP2(Point2D p2) {
        this.m_curvePoints[1].setLocation(p2);
        this.m_curvePoints[2].setLocation(p2);
        this.m_curPoint = 2;
    }

    public void setP3(Point2D p3) {
        this.m_curvePoints[2].setLocation(p3);
        this.m_curPoint = 2;
    }

    private CubicCurve2D _getCurve() {
        return new CubicCurve2D.Double(this.m_curvePoints[0].getX(), this.m_curvePoints[0].getY(), this.m_curvePoints[1].getX(), this.m_curvePoints[1].getY(), this.m_curvePoints[2].getX(), this.m_curvePoints[2].getY(), this.m_curvePoints[3].getX(), this.m_curvePoints[3].getY());
    }

    @Override
    public void reset() {
        this.m_curve = null;
    }

    @Override
    public void paintStarts() {
        this._draw();
        this.m_curve = null;
    }

    @Override
    public void paintEnds() {
        this.m_curve = null;
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            JPanel panel = (JPanel)((Object)gp);
            Point p = panel.getMousePosition();
            if (p == null) continue;
            Point2D.Double pin = new Point2D.Double();
            Point2D.Double pout = new Point2D.Double();
            Projection2D prj2D = gp.getProjection();
            ((Point2D)pin).setLocation(((Point2D)p).getX(), ((Point2D)p).getY());
            prj2D.getViewToModel().transform(pin, pout);
            this.m_curvePoints[this.m_curPoint].setLocation(pout);
            if (this.m_curPoint == 1) {
                this.m_curvePoints[this.m_curPoint + 1].setLocation(pout);
            }
            this.m_curve = this._getCurve();
            break;
        }
        this._draw();
    }

    public void close() {
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            gp.removeListener(this);
            JPanel panel = (JPanel)((Object)gp);
            Graphics gfx = this.m_panelToGfx.get(panel);
            gfx.dispose();
        }
    }

    private void _draw() {
        if (this.m_curve == null) {
            return;
        }
        if (!this._mustClip()) {
            Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
            while (it.hasNext()) {
                GeometryPanel panel = it.next();
                Graphics2D gfx = this.m_panelToGfx.get(panel);
                if (gfx == null) {
                    throw new InternalError("CubicCurveRubberBand: gfx == null");
                }
                gfx.setColor(((JPanel)((Object)panel)).getForeground());
                Projection2D prj2D = panel.getProjection();
                AffineTransform m2v = prj2D.getModelToView();
                gfx.draw(m2v.createTransformedShape(this.m_curve));
            }
            return;
        }
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel panel = it.next();
            Graphics2D gfx = this.m_panelToGfx.get(panel);
            if (gfx == null) {
                throw new InternalError("CubicCurveRubberBand: gfx == null");
            }
            gfx.setColor(((JPanel)((Object)panel)).getForeground());
            Projection2D prj2D = panel.getProjection();
            AffineTransform m2v = prj2D.getModelToView();
            PathIterator pit = this.m_curve.getPathIterator(null, Geo2D.getEps());
            Line2D.Double seg = null;
            double[] mvto = new double[2];
            double[] last = new double[2];
            double[] crds = new double[6];
            while (!pit.isDone()) {
                int type = pit.currentSegment(crds);
                switch (type) {
                    case 0: {
                        mvto[0] = crds[0];
                        mvto[1] = crds[1];
                        seg = null;
                        last[0] = crds[0];
                        last[1] = crds[1];
                        break;
                    }
                    case 1: {
                        seg = new Line2D.Double(last[0], last[1], crds[0], crds[1]);
                        this._draw((JPanel)((Object)panel), gfx, m2v, seg);
                        last[0] = crds[0];
                        last[1] = crds[1];
                        break;
                    }
                    case 4: {
                        seg = new Line2D.Double(last[0], last[1], mvto[0], mvto[1]);
                        break;
                    }
                    default: {
                        throw new Error("Not a flattening path iterator");
                    }
                }
                if (seg == null) {
                    // empty if block
                }
                pit.next();
            }
        }
    }

    private void _draw(JPanel panel, Graphics2D gfx, AffineTransform m2v, Line2D c) {
        Point2D.Double scrPoint1 = new Point2D.Double();
        m2v.transform(c.getP1(), scrPoint1);
        Point2D.Double scrPoint2 = new Point2D.Double();
        m2v.transform(c.getP2(), scrPoint2);
        Line2D.Double scrLine = new Line2D.Double(scrPoint1, scrPoint2);
        if (Geo2D.clip(panel.getVisibleRect(), scrLine) != 0) {
            gfx.draw(scrLine);
        }
    }

    private boolean _mustClip() {
        return false;
    }
}

