/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.constr;

import cib.cad.db.comp.Component;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.cmds.util.ArcAngleRubberBand;
import cib.cad.kernel.cmds.util.ArcBy3PointsRubberBand;
import cib.cad.kernel.constr.ConCircle2D;
import cib.cad.kernel.constr.ConObject;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.kernel.constr.Construction;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.geo.Geo2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

public class ConArc2D
extends ConObject {
    private Arc2D m_defArc = null;
    private transient Object m_input = null;

    public ConArc2D(Kernel krnl) {
        super(krnl);
        this._init();
    }

    protected ConArc2D(ConObject con) {
        super(con);
        this._init();
    }

    private void _init() {
        this.setPrompt(Messages.getString("kernel.constr.ConArc2D.0"));
    }

    public void setDefault(Arc2D arc) {
        this.m_defArc = arc == null ? null : (Arc2D)arc.clone();
    }

    public Arc2D getDefault() {
        return this.m_defArc == null ? null : (Arc2D)this.m_defArc.clone();
    }

    @Override
    public void show() {
        this.showConArcDialog();
    }

    @Override
    public void dispose() {
        this._setPickCursor(false);
        this._getUI().disposeCmdLineDialog();
    }

    @Override
    public void setDigitizeCursor(boolean on) {
        ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
        conPoint.setDigitizeCursor(on);
    }

    private void showConArcDialog() {
        block5: while (true) {
            CmdLineDialog dlg = this._getUI().getCmdLineDialog();
            dlg.setUniqueName("kernel.constr.ConArc2D-menu0");
            final ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
            conPoint.setFilter(this.m_filter);
            dlg.setPrompt(String.valueOf(this.getPrompt()) + (ConPoint2D.getRelCoordFlag() ? Messages.getString("kernel.constr.ConArc2D.2") : ""));
            dlg.enableTextInput(true);
            if (this.m_defArc != null) {
                dlg.setDefaultText(String.valueOf(Geo2D.formatCoordinate(this.m_defArc.getCenterX())) + " " + Geo2D.formatCoordinate(this.m_defArc.getCenterY()));
            }
            dlg.enableDigitize(-1);
            dlg.addChoice("Pick");
            dlg.addChoice("Circle and angles");
            dlg.setChoiceChecked(1, true);
            dlg.addChoice("Circumference");
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    ConArc2D.this.m_input = new Integer(iChoice);
                    ConArc2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    ConArc2D.this.m_input = new CmdAbortedException();
                    ConArc2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void digitized(int x, int y, GeometryPanel gp) {
                    ConArc2D.this.m_input = new DigitizeToken(x, y, gp.getId());
                    ConArc2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void textEntered(String text) {
                    ConArc2D.this.m_input = new TextToken(text);
                    ConArc2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void interruptStarts(String argList) {
                    conPoint.setDigitizeCursor(false);
                    conPoint.showRelativeCoordinatesAid(false);
                }

                @Override
                public void interruptEnds() {
                    conPoint.setDigitizeCursor(true);
                    conPoint.showRelativeCoordinatesAid(true);
                }
            });
            conPoint.setDigitizeCursor(true);
            conPoint.showRelativeCoordinatesAid(true);
            this._getUI().showCmdLineDialog(dlg);
            conPoint.setDigitizeCursor(false);
            conPoint.showRelativeCoordinatesAid(false);
            if (this.m_input instanceof Integer) {
                int iChoice = (Integer)this.m_input;
                switch (iChoice) {
                    case 0: {
                        if (!this.showPickArcDialog()) continue block5;
                        return;
                    }
                    case 1: {
                        this.showCircleAngleDialog();
                        return;
                    }
                    case 2: {
                        this.showCircumferenceDialog();
                        return;
                    }
                }
                System.err.println(Messages.getString("kernel.constr.ConArc2D.8"));
                continue;
            }
            if (this.m_input instanceof CmdAbortedException) {
                this.notifyAborted();
                return;
            }
            if (this.m_input instanceof DigitizeToken) {
                this.m_krnl.pushBackArguments(new CmdLineToken[]{(DigitizeToken)this.m_input});
                this.showCircleAngleDialog();
                return;
            }
            if (this.m_input instanceof TextToken) break;
        }
        this.m_krnl.pushBackArguments(new CmdLineToken[]{(TextToken)this.m_input});
        this.showCircleAngleDialog();
    }

    private boolean showPickArcDialog() {
        CmdLineDialog dlg = this._getUI().getCmdLineDialog();
        dlg.setUniqueName("kernel.constr.ConArc2D-menu1");
        dlg.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConArc2D.10"));
        dlg.enableDigitize(-1);
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void dialogAborted() {
                ConArc2D.this.m_input = new CmdAbortedException();
                ConArc2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                ConArc2D.this.m_input = new DigitizeObject(gp, x, y);
                ConArc2D.this._getUI().disposeCmdLineDialog();
            }
        });
        this._setPickCursor(true);
        this._getUI().showCmdLineDialog(dlg);
        this._setPickCursor(false);
        if (this.m_input instanceof CmdAbortedException) {
            this.notifyAborted();
            return true;
        }
        if (this.m_input instanceof DigitizeObject) {
            DigitizeObject dig = (DigitizeObject)this.m_input;
            Rectangle2D.Double pickBox = new Rectangle2D.Double(dig.getX() - 5, dig.getY() - 5, 10.0, 10.0);
            GeometryPanel gp = dig.getGeometryPanel();
            double[] crds = new double[8];
            Iterator<Component> it = gp.objectIterator(pickBox, true);
            while (it.hasNext()) {
                Component o = it.next();
                if (!this._accepts(o, -1, -1)) continue;
                GeometryPanel.SegmentIterator git = gp.intersectionSegmentIterator(o, pickBox);
                while (git.hasNext()) {
                    if (git.next(crds) != 64) continue;
                    Point2D.Double sp = new Point2D.Double(crds[0], crds[1]);
                    Point2D.Double ap = new Point2D.Double(crds[2], crds[3]);
                    Point2D.Double ep = new Point2D.Double(crds[4], crds[5]);
                    Shape shape = Geo2D.calculateArc2D(sp, ap, ep, new Arc2D.Double());
                    if (shape == null) {
                        shape = new Line2D.Double(sp, ep);
                    }
                    this.notifyArcConstructed(shape);
                    return true;
                }
            }
            System.err.println(Messages.getString("kernel.constr.ConArc2D.11"));
        }
        return false;
    }

    private void showCircleAngleDialog() {
        final ConCircle2D conCircle = new ConCircle2D(this.m_krnl);
        final Ellipse2D.Double circle = new Ellipse2D.Double();
        final Point2D.Double pntOnCircumference = new Point2D.Double(Double.NaN, 0.0);
        conCircle.setPrompt(this.getPrompt());
        conCircle.setFilter(this.m_filter);
        if (this.m_defArc != null) {
            Ellipse2D.Double defCircle = new Ellipse2D.Double();
            defCircle.setFrame(this.m_defArc.getFrame());
            conCircle.setDefault(defCircle);
        }
        conCircle.addListener(new ConCircle2D.Listener(){

            @Override
            public void circleConstructed(Ellipse2D c) {
                circle.setFrame(c.getFrame());
                ConArc2D.this.m_input = c;
                conCircle.dispose();
            }

            @Override
            public void dialogAborted() {
                ConArc2D.this.m_input = new CmdAbortedException();
                conCircle.dispose();
            }

            @Override
            public void pointOnCircumferenceConstructed(Point2D pnt) {
                pntOnCircumference.setLocation(pnt);
            }
        });
        conCircle.setDrawEnabled(false);
        conCircle.show();
        if (this.m_input instanceof CmdAbortedException) {
            this.notifyAborted();
            return;
        }
        if (Geo2D.isNull(circle)) {
            Arc2D.Double arc = new Arc2D.Double();
            ((Arc2D)arc).setArc(circle.getCenterX(), circle.getCenterY(), ((RectangularShape)circle).getWidth(), ((RectangularShape)circle).getHeight(), 0.0, 0.0, 0);
            this.notifyArcConstructed(arc);
            return;
        }
        Point2D.Double ctr = new Point2D.Double(circle.getCenterX(), circle.getCenterY());
        double rad = 0.5 * ((RectangularShape)circle).getWidth();
        double startAngle = 0.0;
        double sweepAngle = 360.0;
        if (this.m_defArc != null) {
            startAngle = -this.m_defArc.getAngleStart();
            sweepAngle = -this.m_defArc.getAngleExtent();
        }
        ArcAngleRubberBand rb = null;
        try {
            boolean confirmAngle;
            block48: {
                Point2D.Double pnt;
                block49: {
                    block46: {
                        rb = new ArcAngleRubberBand(this.m_krnl, ctr, rad);
                        if (!Double.isNaN(((Point2D)pntOnCircumference).getX())) {
                            double dx = ((Point2D)pntOnCircumference).getX() - ((Point2D)ctr).getX();
                            double dy = ((Point2D)pntOnCircumference).getY() - ((Point2D)ctr).getY();
                            startAngle = Math.atan2(dy, dx);
                        } else {
                            block47: {
                                CmdLineDialog dlg = this._getUI().getCmdLineDialog();
                                dlg.setUniqueName("kernel.constr.ConArc2D-menu2");
                                final ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
                                conPoint.setFilter(this.m_filter);
                                dlg.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConArc2D.13"));
                                dlg.enableTextInput(true);
                                dlg.setDefaultText(Geo2D.formatDegrees(startAngle));
                                dlg.enableDigitize(-1);
                                dlg.addChoice("Start angle");
                                dlg.addChoice("Radial point");
                                dlg.setChoiceChecked(1, true);
                                dlg.addListener(new CmdLineDialog.Listener(){

                                    @Override
                                    public void choiceSelected(int iChoice) {
                                        ConArc2D.this.m_input = new Integer(iChoice);
                                        ConArc2D.this._getUI().disposeCmdLineDialog();
                                    }

                                    @Override
                                    public void dialogAborted() {
                                        ConArc2D.this.m_input = new CmdAbortedException();
                                        ConArc2D.this._getUI().disposeCmdLineDialog();
                                    }

                                    @Override
                                    public void digitized(int x, int y, GeometryPanel gp) {
                                        ConArc2D.this.m_input = new DigitizeToken(x, y, gp.getId());
                                        ConArc2D.this._getUI().disposeCmdLineDialog();
                                    }

                                    @Override
                                    public void textEntered(String text) {
                                        ConArc2D.this.m_input = new TextToken(text);
                                        ConArc2D.this._getUI().disposeCmdLineDialog();
                                    }

                                    @Override
                                    public void interruptStarts(String argList) {
                                        conPoint.setDigitizeCursor(false);
                                    }

                                    @Override
                                    public void interruptEnds() {
                                        conPoint.setDigitizeCursor(true);
                                    }
                                });
                                conPoint.setDigitizeCursor(true);
                                this._getUI().showCmdLineDialog(dlg);
                                conPoint.setDigitizeCursor(false);
                                try {
                                    if (this.m_input instanceof Integer) {
                                        int iChoice = (Integer)this.m_input;
                                        switch (iChoice) {
                                            case 0: {
                                                startAngle = Construction.getConstruction(this.m_krnl).angle2D(Messages.getString("kernel.constr.ConArc2D.16"), Double.NaN, this.m_filter);
                                                break;
                                            }
                                            case 1: {
                                                pnt = new Point2D.Double();
                                                if (ConPoint2D.getRelCoordFlag()) {
                                                    ConPoint2D.setRelCoord(ctr);
                                                }
                                                Construction.getConstruction(this.m_krnl).point2D(Messages.getString("kernel.constr.ConArc2D.17"), pnt, null, this.m_filter);
                                                startAngle = Math.atan2(((Point2D)pnt).getY() - ((Point2D)ctr).getY(), ((Point2D)pnt).getX() - ((Point2D)ctr).getX());
                                                break;
                                            }
                                            default: {
                                                System.err.println(Messages.getString("kernel.constr.ConArc2D.18"));
                                                break;
                                            }
                                        }
                                        break block46;
                                    }
                                    if (!(this.m_input instanceof CmdAbortedException)) break block47;
                                    this.notifyAborted();
                                    rb.close();
                                    return;
                                }
                                catch (CmdAbortedException e) {
                                    this.notifyAborted();
                                    rb.close();
                                    if (rb != null) {
                                        rb.close();
                                    }
                                    return;
                                }
                            }
                            if (this.m_input instanceof DigitizeToken) {
                                this.m_krnl.pushBackArguments(new CmdLineToken[]{(DigitizeToken)this.m_input});
                                Point2D.Double pnt2 = new Point2D.Double();
                                if (ConPoint2D.getRelCoordFlag()) {
                                    ConPoint2D.setRelCoord(ctr);
                                }
                                Construction.getConstruction(this.m_krnl).point2D(Messages.getString("kernel.constr.ConArc2D.19"), pnt2, null, this.m_filter);
                                startAngle = Math.atan2(((Point2D)pnt2).getY() - ((Point2D)ctr).getY(), ((Point2D)pnt2).getX() - ((Point2D)ctr).getX());
                            } else if (this.m_input instanceof TextToken) {
                                this.m_krnl.pushBackArguments(new CmdLineToken[]{(TextToken)this.m_input});
                                startAngle = Construction.getConstruction(this.m_krnl).angle2D(Messages.getString("kernel.constr.ConArc2D.20"), Double.NaN, this.m_filter);
                            }
                        }
                    }
                    rb.setStartAngle(startAngle);
                    confirmAngle = false;
                    CmdLineDialog dlg = this._getUI().getCmdLineDialog();
                    dlg.setUniqueName("kernel.constr.ConArc2D-menu3");
                    final ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
                    conPoint.setFilter(this.m_filter);
                    dlg.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConArc2D.22"));
                    dlg.enableTextInput(true);
                    dlg.setDefaultText(Geo2D.formatDegrees(sweepAngle));
                    dlg.enableDigitize(-1);
                    dlg.addChoice("Sweep angle");
                    dlg.addChoice("Radial point");
                    dlg.setChoiceChecked(1, true);
                    dlg.addListener(new CmdLineDialog.Listener(){

                        @Override
                        public void choiceSelected(int iChoice) {
                            ConArc2D.this.m_input = new Integer(iChoice);
                            ConArc2D.this._getUI().disposeCmdLineDialog();
                        }

                        @Override
                        public void dialogAborted() {
                            ConArc2D.this.m_input = new CmdAbortedException();
                            ConArc2D.this._getUI().disposeCmdLineDialog();
                        }

                        @Override
                        public void digitized(int x, int y, GeometryPanel gp) {
                            ConArc2D.this.m_input = new DigitizeToken(x, y, gp.getId());
                            ConArc2D.this._getUI().disposeCmdLineDialog();
                        }

                        @Override
                        public void textEntered(String text) {
                            ConArc2D.this.m_input = new TextToken(text);
                            ConArc2D.this._getUI().disposeCmdLineDialog();
                        }

                        @Override
                        public void interruptStarts(String argList) {
                            conPoint.setDigitizeCursor(false);
                        }

                        @Override
                        public void interruptEnds() {
                            conPoint.setDigitizeCursor(true);
                        }
                    });
                    conPoint.setDigitizeCursor(true);
                    this._getUI().showCmdLineDialog(dlg);
                    conPoint.setDigitizeCursor(false);
                    try {
                        if (this.m_input instanceof Integer) {
                            int iChoice = (Integer)this.m_input;
                            switch (iChoice) {
                                case 0: {
                                    sweepAngle = Construction.getConstruction(this.m_krnl).angle2D(Messages.getString("kernel.constr.ConArc2D.25"), Double.NaN, this.m_filter);
                                    break;
                                }
                                case 1: {
                                    Point2D.Double pnt3 = new Point2D.Double();
                                    if (ConPoint2D.getRelCoordFlag()) {
                                        ConPoint2D.setRelCoord(ctr);
                                    }
                                    DigitizeObject dig = Construction.getConstruction(this.m_krnl).point2D(Messages.getString("kernel.constr.ConArc2D.26"), pnt3, null, this.m_filter);
                                    sweepAngle = rb.sweepAngleFromPoint(pnt3);
                                    if (dig != null && !this.m_krnl.hasArgument()) {
                                        this.m_krnl.addArgument(new TextToken(String.valueOf(Math.toDegrees(sweepAngle))));
                                    }
                                    confirmAngle = true;
                                    break;
                                }
                                default: {
                                    System.err.println(Messages.getString("kernel.constr.ConArc2D.28"));
                                    break;
                                }
                            }
                            break block48;
                        }
                        if (!(this.m_input instanceof CmdAbortedException)) break block49;
                        this.notifyAborted();
                        rb.close();
                        return;
                    }
                    catch (CmdAbortedException e) {
                        this.notifyAborted();
                        rb.close();
                        if (rb != null) {
                            rb.close();
                        }
                        return;
                    }
                }
                if (this.m_input instanceof DigitizeToken) {
                    this.m_krnl.pushBackArguments(new CmdLineToken[]{(DigitizeToken)this.m_input});
                    pnt = new Point2D.Double();
                    if (ConPoint2D.getRelCoordFlag()) {
                        ConPoint2D.setRelCoord(ctr);
                    }
                    DigitizeObject dig = Construction.getConstruction(this.m_krnl).point2D(Messages.getString("kernel.constr.ConArc2D.29"), pnt, null, this.m_filter);
                    sweepAngle = rb.sweepAngleFromPoint(pnt);
                    if (dig != null && !this.m_krnl.hasArgument()) {
                        this.m_krnl.addArgument(new TextToken(String.valueOf(Math.toDegrees(sweepAngle))));
                    }
                    confirmAngle = true;
                } else if (this.m_input instanceof TextToken) {
                    this.m_krnl.pushBackArguments(new CmdLineToken[]{(TextToken)this.m_input});
                    sweepAngle = Construction.getConstruction(this.m_krnl).angle2D(Messages.getString("kernel.constr.ConArc2D.31"), Double.NaN, this.m_filter);
                }
            }
            if (rb != null) {
                rb.close();
            }
            if (confirmAngle) {
                sweepAngle = this.showConfirmAngleDialog(sweepAngle);
            }
        }
        finally {
            if (rb != null) {
                rb.close();
            }
        }
        this.notifyArcConstructed(ConArc2D.newArc2D(((Point2D)ctr).getX(), ((Point2D)ctr).getY(), rad, startAngle, sweepAngle));
    }

    private double showConfirmAngleDialog(double angle) {
        CmdLineDialog dlg = this._getUI().getCmdLineDialog();
        dlg.setUniqueName("kernel.constr.ConArc2D-menu4");
        dlg.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConArc2D.33"));
        dlg.setDefaultText(Geo2D.formatDegrees(Math.toDegrees(angle)));
        dlg.enableTextInput(true);
        dlg.addChoice("Invert");
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                ConArc2D.this.m_input = new Integer(iChoice);
                ConArc2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                ConArc2D.this.m_input = new CmdAbortedException();
                ConArc2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void textEntered(String text) {
                try {
                    ConArc2D.this.m_input = Double.valueOf(text);
                    ConArc2D.this._getUI().disposeCmdLineDialog();
                }
                catch (NumberFormatException e) {
                    System.err.println(Messages.getString("kernel.constr.ConArc2D.35"));
                }
            }
        });
        this.m_input = null;
        this._getUI().showCmdLineDialog(dlg);
        if (this.m_input instanceof Integer) {
            int iChoice = (Integer)this.m_input;
            switch (iChoice) {
                case 0: {
                    if (angle < 0.0) {
                        angle += Math.PI * 2;
                        break;
                    }
                    angle -= Math.PI * 2;
                    break;
                }
                default: {
                    System.err.println(Messages.getString("kernel.constr.ConArc2D.36"));
                    break;
                }
            }
        } else {
            if (this.m_input instanceof Double) {
                angle = (Double)this.m_input;
                angle = Math.toRadians(angle);
                return angle;
            }
            if (this.m_input instanceof CmdAbortedException) {
                this.notifyAborted();
                return angle;
            }
        }
        return this.showConfirmAngleDialog(angle);
    }

    private void showCircumferenceDialog() {
        Point2D.Double sp = new Point2D.Double();
        try {
            Construction.getConstruction(this.m_krnl).point2D(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConArc2D.37"), sp, null, this.m_filter);
        }
        catch (CmdAbortedException e) {
            this.notifyAborted();
            return;
        }
        ArcBy3PointsRubberBand rb = new ArcBy3PointsRubberBand(this.m_krnl, sp);
        try {
            Point2D.Double ep = new Point2D.Double();
            try {
                Construction.getConstruction(this.m_krnl).point2D(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConArc2D.38"), ep, null, this.m_filter);
            }
            catch (CmdAbortedException e) {
                this.notifyAborted();
                rb.close();
                if (rb != null) {
                    rb.close();
                }
                return;
            }
            rb.setEP(ep);
            Point2D.Double p = new Point2D.Double();
            try {
                ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
                conPoint.setFilter(this.m_filter);
                if (ConPoint2D.getRelCoordFlag()) {
                    ConPoint2D.setRelCoord(sp);
                }
                Construction.getConstruction(this.m_krnl).point2D(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConArc2D.39"), p, null, this.m_filter);
            }
            catch (CmdAbortedException e) {
                this.notifyAborted();
                rb.close();
                if (rb != null) {
                    rb.close();
                }
                return;
            }
            Arc2D arc = Geo2D.calculateArc2D(sp, p, ep, new Arc2D.Double());
            this.notifyArcConstructed(arc == null ? new Line2D.Double(sp, ep) : arc);
        }
        finally {
            if (rb != null) {
                rb.close();
            }
        }
    }

    public static Arc2D newArc2D(double cx, double cy, double r, double startAngleRad, double sweepAngleRad) {
        Arc2D.Double arc = new Arc2D.Double();
        double startAngle = -Math.toDegrees(startAngleRad);
        double sweepAngle = -Math.toDegrees(sweepAngleRad);
        arc.setArcByCenter(cx, cy, r, startAngle, sweepAngle, 0);
        return arc;
    }

    public static double getRadius(Arc2D arc) {
        double diameterY;
        if (arc == null) {
            return Double.NaN;
        }
        double diameterX = arc.getWidth();
        if (Math.abs(diameterX - (diameterY = arc.getHeight())) < Geo2D.getEps()) {
            return 0.5 * arc.getWidth();
        }
        return Double.NaN;
    }

    private void notifyArcConstructed(Shape shape) {
        if (this.isDrawEnabled()) {
            this._getUI().draw(shape);
        }
        Iterator<ConObject.Listener> it = this.listenerIterator();
        while (it.hasNext()) {
            Listener l = (Listener)it.next();
            l.arcConstructed(shape);
        }
    }

    public static class Adapter
    implements Listener {
        @Override
        public void dialogAborted() {
        }

        @Override
        public void arcConstructed(Shape arc) {
        }
    }

    public static interface Listener
    extends ConObject.Listener {
        public void arcConstructed(Shape var1);
    }
}

