/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.constr;

import cib.cad.db.comp.Component;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.cmds.util.CircleBy3PointsRubberBand;
import cib.cad.kernel.cmds.util.CircleRubberBand;
import cib.cad.kernel.constr.ConObject;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.kernel.constr.Construction;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.geo.Geo2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class ConCircle2D
extends ConObject {
    private Ellipse2D m_defCircle = null;
    private transient Object m_input = null;

    public ConCircle2D(Kernel krnl) {
        super(krnl);
        this._init();
    }

    protected ConCircle2D(ConObject con) {
        super(con);
        this._init();
    }

    private void _init() {
        this.setPrompt(Messages.getString("kernel.constr.ConCircle2D.0"));
    }

    public void setDefault(Ellipse2D circle) {
        this.m_defCircle = circle == null ? null : (Ellipse2D)circle.clone();
    }

    public Ellipse2D getDefault() {
        return this.m_defCircle == null ? null : (Ellipse2D)this.m_defCircle.clone();
    }

    @Override
    public void show() {
        this.showConCircleDialog();
    }

    @Override
    public void dispose() {
        this._setPickCursor(false);
        this._getUI().disposeCmdLineDialog();
    }

    @Override
    public void setDigitizeCursor(boolean on) {
        ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
        conPoint.setDigitizeCursor(on);
    }

    private void showConCircleDialog() {
        block6: while (true) {
            CmdLineDialog dlg = this._getUI().getCmdLineDialog();
            dlg.setUniqueName("kernel.constr.ConCircle2D-menu0");
            final ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
            conPoint.setFilter(this.m_filter);
            dlg.setPrompt(String.valueOf(this.getPrompt()) + (ConPoint2D.getRelCoordFlag() ? Messages.getString("kernel.constr.ConCircle2D.2") : ""));
            dlg.enableTextInput(true);
            if (this.m_defCircle != null) {
                dlg.setDefaultText(String.valueOf(Geo2D.formatCoordinate(this.m_defCircle.getCenterX())) + " " + Geo2D.formatCoordinate(this.m_defCircle.getCenterY()));
            }
            dlg.enableDigitize(-1);
            dlg.addChoice("Pick");
            dlg.addChoice("Center");
            dlg.setChoiceChecked(1, true);
            dlg.addChoice("Circumference");
            dlg.addChoice("Tangent");
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    ConCircle2D.this.m_input = new Integer(iChoice);
                    ConCircle2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    ConCircle2D.this.m_input = new CmdAbortedException();
                    ConCircle2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void digitized(int x, int y, GeometryPanel gp) {
                    ConCircle2D.this.m_input = new DigitizeToken(x, y, gp.getId());
                    ConCircle2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void textEntered(String text) {
                    ConCircle2D.this.m_input = new TextToken(text);
                    ConCircle2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void interruptStarts(String argList) {
                    conPoint.setDigitizeCursor(false);
                    conPoint.showRelativeCoordinatesAid(false);
                }

                @Override
                public void interruptEnds() {
                    conPoint.setDigitizeCursor(true);
                    conPoint.showRelativeCoordinatesAid(true);
                }
            });
            conPoint.setDigitizeCursor(true);
            conPoint.showRelativeCoordinatesAid(true);
            this._getUI().showCmdLineDialog(dlg);
            conPoint.setDigitizeCursor(false);
            conPoint.showRelativeCoordinatesAid(false);
            if (this.m_input instanceof Integer) {
                int iChoice = (Integer)this.m_input;
                switch (iChoice) {
                    case 0: {
                        if (!this.showPickCircleDialog()) continue block6;
                        return;
                    }
                    case 1: {
                        this.showCenterDialog();
                        return;
                    }
                    case 2: {
                        this.showCircumferenceDialog();
                        return;
                    }
                    case 3: {
                        this.showTangentDialog();
                        return;
                    }
                }
                System.err.println(Messages.getString("kernel.constr.ConCircle2D.9"));
                continue;
            }
            if (this.m_input instanceof CmdAbortedException) {
                this.notifyAborted();
                return;
            }
            if (this.m_input instanceof DigitizeToken) {
                this.m_krnl.pushBackArguments(new CmdLineToken[]{(DigitizeToken)this.m_input});
                this.showCenterDialog();
                return;
            }
            if (this.m_input instanceof TextToken) break;
        }
        this.m_krnl.pushBackArguments(new CmdLineToken[]{(TextToken)this.m_input});
        this.showCenterDialog();
    }

    private boolean showPickCircleDialog() {
        CmdLineDialog dlg = this._getUI().getCmdLineDialog();
        dlg.setUniqueName("kernel.constr.ConCircle2D-menu1");
        dlg.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConCircle2D.11"));
        dlg.enableDigitize(-1);
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void dialogAborted() {
                ConCircle2D.this.m_input = new CmdAbortedException();
                ConCircle2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                ConCircle2D.this.m_input = new DigitizeObject(gp, x, y);
                ConCircle2D.this._getUI().disposeCmdLineDialog();
            }
        });
        this._setPickCursor(true);
        this._getUI().showCmdLineDialog(dlg);
        this._setPickCursor(false);
        if (this.m_input instanceof CmdAbortedException) {
            this.notifyAborted();
            return true;
        }
        if (this.m_input instanceof DigitizeObject) {
            DigitizeObject dig = (DigitizeObject)this.m_input;
            Rectangle2D.Double pickBox = new Rectangle2D.Double(dig.getX() - 5, dig.getY() - 5, 10.0, 10.0);
            GeometryPanel gp = dig.getGeometryPanel();
            double[] crds = new double[8];
            Iterator<Component> it = gp.objectIterator(pickBox, true);
            while (it.hasNext()) {
                Component o = it.next();
                if (!this._accepts(o, -1, -1)) continue;
                GeometryPanel.SegmentIterator git = gp.intersectionSegmentIterator(o, pickBox);
                while (git.hasNext()) {
                    Point2D.Double ep;
                    Point2D.Double ap;
                    Point2D.Double sp;
                    Ellipse2D circle;
                    if (git.next(crds) != 64 || (circle = Geo2D.calculateEllipse2D(sp = new Point2D.Double(crds[0], crds[1]), ap = new Point2D.Double(crds[2], crds[3]), ep = new Point2D.Double(crds[4], crds[5]), new Ellipse2D.Double())) == null) continue;
                    this.notifyCircleConstructed(circle);
                    return true;
                }
            }
            System.err.println(Messages.getString("kernel.constr.ConCircle2D.12"));
        }
        return false;
    }

    private void showCenterDialog() {
        CircleRubberBand rb = null;
        try {
            Point2D.Double ctr = new Point2D.Double();
            try {
                if (this.m_defCircle == null) {
                    Construction.getConstruction(this.m_krnl).point2D(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConCircle2D.13"), ctr, null, this.m_filter);
                } else {
                    Point2D.Double defCtr = new Point2D.Double(this.m_defCircle.getCenterX(), this.m_defCircle.getCenterY());
                    Construction.getConstruction(this.m_krnl).point2D(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConCircle2D.14"), ctr, defCtr, this.m_filter);
                }
            }
            catch (CmdAbortedException e) {
                this.notifyAborted();
                if (rb != null) {
                    rb.close();
                }
                return;
            }
            rb = new CircleRubberBand(this.m_krnl, ctr);
            CmdLineDialog dlg = this._getUI().getCmdLineDialog();
            dlg.setUniqueName("kernel.constr.ConCircle2D-menu2");
            final ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
            conPoint.setFilter(this.m_filter);
            dlg.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConCircle2D.16"));
            dlg.enableTextInput(true);
            if (this.m_defCircle != null) {
                double defRad = 0.5 * this.m_defCircle.getWidth();
                dlg.setDefaultText(Geo2D.formatDegrees(defRad));
            }
            dlg.enableDigitize(-1);
            dlg.addChoice("Circumference");
            dlg.setChoiceChecked(0, true);
            dlg.addChoice("Radius");
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    ConCircle2D.this.m_input = new Integer(iChoice);
                    ConCircle2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    ConCircle2D.this.m_input = new CmdAbortedException();
                    ConCircle2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void digitized(int x, int y, GeometryPanel gp) {
                    ConCircle2D.this.m_input = new DigitizeToken(x, y, gp.getId());
                    ConCircle2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void textEntered(String text) {
                    ConCircle2D.this.m_input = new TextToken(text);
                    ConCircle2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void interruptStarts(String argList) {
                    conPoint.setDigitizeCursor(false);
                }

                @Override
                public void interruptEnds() {
                    conPoint.setDigitizeCursor(true);
                }
            });
            conPoint.setDigitizeCursor(true);
            this._getUI().showCmdLineDialog(dlg);
            conPoint.setDigitizeCursor(false);
            double rad = 0.0;
            Point2D.Double pntOnCircumference = null;
            if (this.m_input instanceof Integer) {
                int iChoice = (Integer)this.m_input;
                switch (iChoice) {
                    case 0: {
                        try {
                            pntOnCircumference = new Point2D.Double();
                            Construction.getConstruction(this.m_krnl).point2D(Messages.getString("kernel.constr.ConCircle2D.19"), pntOnCircumference, null, this.m_filter);
                            this.notifyPointOnCircumferenceConstructed(pntOnCircumference);
                            this.notifyCircleConstructed(ConCircle2D.newEllipse2D(((Point2D)ctr).getX(), ((Point2D)ctr).getY(), pntOnCircumference));
                        }
                        catch (CmdAbortedException e) {
                            this.notifyAborted();
                        }
                        break;
                    }
                    case 1: {
                        try {
                            if (this.m_defCircle == null) {
                                rad = Construction.getConstruction(this.m_krnl).distance2D(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConCircle2D.20"), Double.NaN, this.m_filter);
                            } else {
                                double defRad = 0.5 * this.m_defCircle.getWidth();
                                rad = Construction.getConstruction(this.m_krnl).distance2D(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConCircle2D.21"), defRad, this.m_filter);
                            }
                            this.notifyCircleConstructed(ConCircle2D.newEllipse2D(((Point2D)ctr).getX(), ((Point2D)ctr).getY(), rad));
                        }
                        catch (CmdAbortedException e) {
                            this.notifyAborted();
                        }
                        break;
                    }
                    default: {
                        System.err.println(Messages.getString("kernel.constr.ConCircle2D.22"));
                        break;
                    }
                }
            } else if (this.m_input instanceof CmdAbortedException) {
                this.notifyAborted();
            } else if (this.m_input instanceof DigitizeToken) {
                this.m_krnl.pushBackArguments(new CmdLineToken[]{(DigitizeToken)this.m_input});
                try {
                    pntOnCircumference = new Point2D.Double();
                    Construction.getConstruction(this.m_krnl).point2D(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConCircle2D.23"), pntOnCircumference, null, this.m_filter);
                    this.notifyPointOnCircumferenceConstructed(pntOnCircumference);
                    this.notifyCircleConstructed(ConCircle2D.newEllipse2D(((Point2D)ctr).getX(), ((Point2D)ctr).getY(), pntOnCircumference));
                }
                catch (CmdAbortedException e) {
                    this.notifyAborted();
                }
            } else if (this.m_input instanceof TextToken) {
                this.m_krnl.pushBackArguments(new CmdLineToken[]{(TextToken)this.m_input});
                try {
                    rad = this.m_krnl.getConstruction().distance2D(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConCircle2D.24"), Double.NaN, this.m_filter);
                    this.notifyCircleConstructed(ConCircle2D.newEllipse2D(((Point2D)ctr).getX(), ((Point2D)ctr).getY(), rad));
                }
                catch (CmdAbortedException e) {
                    this.notifyAborted();
                }
            }
        }
        finally {
            if (rb != null) {
                rb.close();
            }
        }
    }

    private void showCircumferenceDialog() {
        Point2D.Double p1 = new Point2D.Double();
        try {
            Construction.getConstruction(this.m_krnl).point2D(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConCircle2D.25"), p1, null, this.m_filter);
        }
        catch (CmdAbortedException e) {
            this.notifyAborted();
            return;
        }
        CircleBy3PointsRubberBand rb = new CircleBy3PointsRubberBand(this.m_krnl, p1);
        try {
            Point2D.Double p2 = new Point2D.Double();
            try {
                Construction.getConstruction(this.m_krnl).point2D(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConCircle2D.26"), p2, null, this.m_filter);
            }
            catch (CmdAbortedException e) {
                this.notifyAborted();
                rb.close();
                if (rb != null) {
                    rb.close();
                }
                return;
            }
            rb.setP2(p2);
            Point2D.Double p3 = new Point2D.Double();
            try {
                ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
                conPoint.setFilter(this.m_filter);
                if (ConPoint2D.getRelCoordFlag()) {
                    ConPoint2D.setRelCoord(p1);
                }
                Construction.getConstruction(this.m_krnl).point2D(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConCircle2D.27"), p3, null, this.m_filter);
            }
            catch (CmdAbortedException e) {
                this.notifyAborted();
                rb.close();
                if (rb != null) {
                    rb.close();
                }
                return;
            }
            Ellipse2D ell = Geo2D.calculateEllipse2D(p1, p2, p3, new Ellipse2D.Double());
            this.notifyCircleConstructed(ell);
        }
        finally {
            if (rb != null) {
                rb.close();
            }
        }
    }

    private void showTangentDialog() {
        try {
            int nCircles = 0;
            Point2D[] centers = new Point2D[8];
            double radius = 0.0;
            while (nCircles == 0) {
                Ellipse2D c2;
                Line2D l2;
                Shape s1 = this.showTangentDialog(0);
                Shape s2 = this.showTangentDialog(1);
                radius = 0.0;
                while (radius < Geo2D.getEps()) {
                    radius = Construction.getConstruction(this.m_krnl).distance2D(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConCircle2D.28"), Double.NaN, this.m_filter);
                    if (!(radius < Geo2D.getEps())) continue;
                    System.err.println(Messages.getString("kernel.constr.ConCircle2D.29"));
                }
                if (s1 instanceof Line2D) {
                    Line2D l1 = (Line2D)s1;
                    if (s2 instanceof Line2D) {
                        l2 = (Line2D)s2;
                        nCircles = Geo2D.calculateTangentCircles(l1, l2, radius, centers);
                    } else if (s2 instanceof Ellipse2D) {
                        c2 = (Ellipse2D)s2;
                        nCircles = Geo2D.calculateTangentCircles(l1, c2, radius, centers);
                    }
                } else if (s1 instanceof Ellipse2D) {
                    Ellipse2D c1 = (Ellipse2D)s1;
                    if (s2 instanceof Line2D) {
                        l2 = (Line2D)s2;
                        nCircles = Geo2D.calculateTangentCircles(l2, c1, radius, centers);
                    } else if (s2 instanceof Ellipse2D) {
                        c2 = (Ellipse2D)s2;
                        nCircles = Geo2D.calculateTangentCircles(c1, c2, radius, centers);
                    }
                } else {
                    throw new InternalError();
                }
                if (nCircles != 0) continue;
                System.err.println(Messages.getString("kernel.constr.ConCircle2D.30"));
            }
            Ellipse2D[] circles = new Ellipse2D[nCircles];
            int i = 0;
            while (i < nCircles) {
                circles[i] = new Ellipse2D.Double();
                circles[i].setFrameFromCenter(centers[i].getX(), centers[i].getY(), centers[i].getX() - radius, centers[i].getY() - radius);
                this._getUI().draw(circles[i]);
                ++i;
            }
            if (nCircles == 1) {
                this.notifyCircleConstructed(circles[0]);
                return;
            }
            while (true) {
                DigitizeObject dig = this.m_krnl.readDigitizeObject(String.valueOf(Messages.getString("kernel.constr.ConCircle2D.31")) + nCircles + Messages.getString("kernel.constr.ConCircle2D.32"), Construction.getPickNearCursor());
                GeometryPanel panel = dig.getGeometryPanel();
                Point2D.Double pickPnt = new Point2D.Double(dig.getX(), dig.getY());
                AffineTransform m2v = panel.getProjection().getModelToView();
                Rectangle rectangle = new Rectangle();
                rectangle.setFrameFromDiagonal(((Point2D)pickPnt).getX() - 5.0, ((Point2D)pickPnt).getY() - 5.0, ((Point2D)pickPnt).getX() + 5.0, ((Point2D)pickPnt).getY() + 5.0);
                int i2 = 0;
                while (i2 < nCircles) {
                    Shape shp = m2v.createTransformedShape(circles[i2]);
                    if (shp.intersects(rectangle) && !shp.contains(rectangle)) {
                        int j = 0;
                        while (j < nCircles) {
                            this._getUI().undraw(circles[j]);
                            ++j;
                        }
                        this.notifyCircleConstructed(circles[i2]);
                        return;
                    }
                    ++i2;
                }
                System.err.println(Messages.getString("kernel.constr.ConCircle2D.33"));
            }
        }
        catch (CmdAbortedException e) {
            this.notifyAborted();
            return;
        }
    }

    private Shape showTangentDialog(int iTangent) throws CmdAbortedException {
        CmdLineDialog dlg = this._getUI().getCmdLineDialog();
        dlg.setUniqueName("kernel.constr.ConCircle2D-menu3");
        final ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
        conPoint.setFilter(this.m_filter);
        dlg.setPrompt(String.valueOf(this.getPrompt()) + (iTangent == 0 ? Messages.getString("kernel.constr.ConCircle2D.35") : Messages.getString("kernel.constr.ConCircle2D.36")) + Messages.getString("kernel.constr.ConCircle2D.37") + (ConPoint2D.getRelCoordFlag() ? Messages.getString("kernel.constr.ConCircle2D.38") : ""));
        dlg.enableTextInput(true);
        dlg.enableDigitize(-1);
        dlg.addChoice("Line");
        dlg.setChoiceChecked(0, true);
        dlg.addChoice("Circle");
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                ConCircle2D.this.m_input = new Integer(iChoice);
                ConCircle2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                ConCircle2D.this.m_input = new CmdAbortedException();
                ConCircle2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                ConCircle2D.this.m_input = new DigitizeToken(x, y, gp.getId());
                ConCircle2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void textEntered(String text) {
                ConCircle2D.this.m_input = new TextToken(text);
                ConCircle2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void interruptStarts(String argList) {
                conPoint.setDigitizeCursor(false);
                conPoint.showRelativeCoordinatesAid(false);
            }

            @Override
            public void interruptEnds() {
                conPoint.setDigitizeCursor(true);
                conPoint.showRelativeCoordinatesAid(true);
            }
        });
        conPoint.setDigitizeCursor(true);
        conPoint.showRelativeCoordinatesAid(true);
        this._getUI().showCmdLineDialog(dlg);
        conPoint.setDigitizeCursor(false);
        conPoint.showRelativeCoordinatesAid(false);
        if (this.m_input instanceof Integer) {
            int iChoice = (Integer)this.m_input;
            switch (iChoice) {
                case 0: {
                    Line2D.Double line = new Line2D.Double();
                    Construction.getConstruction(this.m_krnl).line2D(Messages.getString("kernel.constr.ConCircle2D.42"), line, null, this.m_filter);
                    return line;
                }
                case 1: {
                    Ellipse2D.Double circle = new Ellipse2D.Double();
                    Construction.getConstruction(this.m_krnl).circle2D(Messages.getString("kernel.constr.ConCircle2D.43"), circle, null, this.m_filter);
                    return circle;
                }
            }
            System.err.println(Messages.getString("kernel.constr.ConCircle2D.44"));
        } else {
            if (this.m_input instanceof CmdAbortedException) {
                throw (CmdAbortedException)this.m_input;
            }
            if (this.m_input instanceof DigitizeToken) {
                this.m_krnl.pushBackArguments(new CmdLineToken[]{(DigitizeToken)this.m_input});
                Line2D.Double line = new Line2D.Double();
                Construction.getConstruction(this.m_krnl).line2D(Messages.getString("kernel.constr.ConCircle2D.45"), line, null, this.m_filter);
                return line;
            }
            if (this.m_input instanceof TextToken) {
                this.m_krnl.pushBackArguments(new CmdLineToken[]{(TextToken)this.m_input});
                Line2D.Double line = new Line2D.Double();
                Construction.getConstruction(this.m_krnl).line2D(Messages.getString("kernel.constr.ConCircle2D.46"), line, null, this.m_filter);
                return line;
            }
        }
        throw new InternalError();
    }

    public static Ellipse2D newEllipse2D(double cx, double cy, double r) {
        Ellipse2D.Double ellipse = new Ellipse2D.Double();
        ellipse.setFrameFromCenter(cx, cy, cx + r, cy + r);
        return ellipse;
    }

    public static Ellipse2D newEllipse2D(double cx, double cy, Point2D pntOnCircumference) {
        double r = pntOnCircumference.distance(cx, cy);
        return ConCircle2D.newEllipse2D(cx, cy, r);
    }

    public static double getRadius(Ellipse2D circle) {
        double diameterY;
        if (circle == null) {
            return Double.NaN;
        }
        double diameterX = circle.getWidth();
        if (Math.abs(diameterX - (diameterY = circle.getHeight())) < Geo2D.getEps()) {
            return 0.5 * circle.getWidth();
        }
        return Double.NaN;
    }

    private void notifyCircleConstructed(Ellipse2D circle) {
        if (circle != null && this.isDrawEnabled()) {
            this._getUI().draw(circle);
        }
        Iterator<ConObject.Listener> it = this.listenerIterator();
        while (it.hasNext()) {
            Listener l = (Listener)it.next();
            l.circleConstructed(circle);
        }
    }

    private void notifyPointOnCircumferenceConstructed(Point2D pnt) {
        Iterator<ConObject.Listener> it = this.listenerIterator();
        while (it.hasNext()) {
            Listener l = (Listener)it.next();
            l.pointOnCircumferenceConstructed(pnt);
        }
    }

    public static class Adapter
    implements Listener {
        @Override
        public void dialogAborted() {
        }

        @Override
        public void pointOnCircumferenceConstructed(Point2D pnt) {
        }

        @Override
        public void circleConstructed(Ellipse2D cir) {
        }
    }

    public static interface Listener
    extends ConObject.Listener {
        public void pointOnCircumferenceConstructed(Point2D var1);

        public void circleConstructed(Ellipse2D var1);
    }
}

