/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.constr;

import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.constr.ConAngle2D;
import cib.cad.kernel.constr.ConArc2D;
import cib.cad.kernel.constr.ConCircle2D;
import cib.cad.kernel.constr.ConDistance2D;
import cib.cad.kernel.constr.ConLine2D;
import cib.cad.kernel.constr.ConLineSeg2D;
import cib.cad.kernel.constr.ConObject;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.kernel.constr.ConScale2D;
import cib.cad.kernel.constr.ConVector2D;
import cib.cad.kernel.constr.InfiniteCircleException;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.geo.Vector2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class Construction {
    private static Construction s_instance = null;
    private Kernel m_krnl;
    private boolean m_aborted = false;
    private static boolean s_relCoordFlag = false;
    private static boolean s_orthoMode = false;
    private double m_angle;
    private double m_dist;
    private transient boolean m_infiniteCircle = false;
    private Line2D t_arcAsLineSeg = null;
    private double m_scale;

    private Construction(Kernel krnl) {
        if (s_instance == null) {
            s_instance = this;
        }
        this.m_krnl = krnl;
    }

    public static Construction getConstruction(Kernel krnl) {
        if (s_instance == null) {
            new Construction(krnl);
        }
        return s_instance;
    }

    public void saveSettings() {
        s_relCoordFlag = ConPoint2D.getRelCoordFlag();
        s_orthoMode = ConLineSeg2D.isOrthogonalMode();
    }

    public void restoreSettings() {
        ConPoint2D.setRelCoordFlag(s_relCoordFlag);
        ConLineSeg2D.setOrthogonalMode(s_orthoMode);
    }

    public double angle2D() throws CmdAbortedException {
        return this.angle2D(Messages.getString("kernel.constr.Construction.0"), Double.NaN);
    }

    public double angle2D(String prompt) throws CmdAbortedException {
        return this.angle2D(prompt, Double.NaN);
    }

    public double angle2D(String prompt, double def) throws CmdAbortedException {
        return this.angle2D(prompt, def, null);
    }

    public double angle2D(String prompt, double def, ConObject.Filter filter) throws CmdAbortedException {
        final ConAngle2D conAngle = new ConAngle2D(this.m_krnl);
        conAngle.setPrompt(prompt);
        conAngle.setDefault(def);
        conAngle.setFilter(filter);
        conAngle.addListener(new ConAngle2D.Listener(){

            @Override
            public void angleConstructed(double angle) {
                Construction.this.m_angle = angle;
                Construction.this.m_aborted = false;
                conAngle.dispose();
            }

            @Override
            public void dialogAborted() {
                Construction.this.m_aborted = true;
                conAngle.dispose();
            }
        });
        conAngle.show();
        if (this.m_aborted) {
            throw new CmdAbortedException();
        }
        return this.m_angle;
    }

    public double distance2D() throws CmdAbortedException {
        return this.distance2D(Messages.getString("kernel.constr.Construction.1"), Double.NaN);
    }

    public double distance2D(String prompt) throws CmdAbortedException {
        return this.distance2D(prompt, Double.NaN);
    }

    public double distance2D(String prompt, double def) throws CmdAbortedException {
        return this.distance2D(prompt, def, null);
    }

    public double distance2D(String prompt, double def, ConObject.Filter filter) throws CmdAbortedException {
        final ConDistance2D conDist = new ConDistance2D(this.m_krnl);
        conDist.setPrompt(prompt);
        conDist.setDefault(def);
        conDist.setFilter(filter);
        conDist.addListener(new ConDistance2D.Listener(){

            @Override
            public void distanceConstructed(double dist) {
                Construction.this.m_dist = dist;
                Construction.this.m_aborted = false;
                conDist.dispose();
            }

            @Override
            public void dialogAborted() {
                Construction.this.m_aborted = true;
                conDist.dispose();
            }
        });
        conDist.show();
        if (this.m_aborted) {
            throw new CmdAbortedException();
        }
        return this.m_dist;
    }

    public DigitizeObject point2D(Point2D pnt) throws CmdAbortedException {
        return this.point2D(Messages.getString("kernel.constr.Construction.2"), pnt);
    }

    public DigitizeObject point2D(String prompt, Point2D pnt) throws CmdAbortedException {
        return this.point2D(prompt, pnt, null);
    }

    public DigitizeObject point2D(String prompt, Point2D pnt, Point2D def) throws CmdAbortedException {
        return this.point2D(prompt, pnt, def, null);
    }

    public DigitizeObject point2D(String prompt, final Point2D pnt, Point2D def, ConObject.Filter filter) throws CmdAbortedException {
        final ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
        conPoint.setPrompt(prompt);
        conPoint.setDefault(def);
        conPoint.setFilter(filter);
        conPoint.addListener(new ConPoint2D.Adapter(){

            @Override
            public void pointConstructed(Point2D p) {
                pnt.setLocation(p);
                Construction.this.m_aborted = false;
                conPoint.dispose();
            }

            @Override
            public void dialogAborted() {
                Construction.this.m_aborted = true;
                conPoint.dispose();
            }
        });
        conPoint.show();
        if (this.m_aborted) {
            throw new CmdAbortedException();
        }
        return conPoint.getLastDigitizeObject();
    }

    public void vector2D(Vector2D vec) throws CmdAbortedException {
        this.vector2D(Messages.getString("kernel.constr.Construction.3"), vec);
    }

    public void vector2D(String prompt, Vector2D vec) throws CmdAbortedException {
        this.vector2D(prompt, vec, null);
    }

    public void vector2D(String prompt, Vector2D vec, Vector2D def) throws CmdAbortedException {
        this.vector2D(prompt, vec, def, null);
    }

    public void vector2D(String prompt, final Vector2D vec, Vector2D def, ConObject.Filter filter) throws CmdAbortedException {
        final ConVector2D conVector = new ConVector2D(this.m_krnl);
        conVector.setPrompt(prompt);
        conVector.setDefault(def);
        conVector.setFilter(filter);
        conVector.addListener(new ConVector2D.Listener(){

            @Override
            public void vectorConstructed(Vector2D v) {
                vec.setLocation(v);
                Construction.this.m_aborted = false;
                conVector.dispose();
            }

            @Override
            public void dialogAborted() {
                Construction.this.m_aborted = true;
                conVector.dispose();
            }
        });
        conVector.show();
        if (this.m_aborted) {
            throw new CmdAbortedException();
        }
    }

    public void line2D(Line2D line) throws CmdAbortedException {
        this.line2D(Messages.getString("kernel.constr.Construction.4"), line);
    }

    public void line2D(String prompt, Line2D lin) throws CmdAbortedException {
        this.line2D(prompt, lin, null);
    }

    public void line2D(String prompt, Line2D line, Line2D def) throws CmdAbortedException {
        this.line2D(prompt, line, def, null);
    }

    public void line2D(String prompt, final Line2D line, Line2D def, ConObject.Filter filter) throws CmdAbortedException {
        final ConLine2D conLine = new ConLine2D(this.m_krnl);
        conLine.setPrompt(prompt);
        conLine.setDefault(def);
        conLine.setFilter(filter);
        conLine.addListener(new ConLine2D.Listener(){

            @Override
            public void lineConstructed(Line2D l) {
                line.setLine(l);
                Construction.this.m_aborted = false;
                conLine.dispose();
            }

            @Override
            public void dialogAborted() {
                Construction.this.m_aborted = true;
                conLine.dispose();
            }
        });
        conLine.show();
        if (this.m_aborted) {
            throw new CmdAbortedException();
        }
    }

    public void lineSeg2D(Line2D lineSeg) throws CmdAbortedException {
        this.lineSeg2D(Messages.getString("kernel.constr.Construction.5"), lineSeg);
    }

    public void lineSeg2D(String prompt, Line2D lineSeg) throws CmdAbortedException {
        this.lineSeg2D(prompt, lineSeg, null);
    }

    public void lineSeg2D(String prompt, Line2D lineSeg, Line2D def) throws CmdAbortedException {
        this.lineSeg2D(prompt, lineSeg, def, null);
    }

    public void lineSeg2D(String prompt, final Line2D lineSeg, Line2D def, ConObject.Filter filter) throws CmdAbortedException {
        final ConLineSeg2D conLineSeg = new ConLineSeg2D(this.m_krnl);
        conLineSeg.setPrompt(prompt);
        conLineSeg.setDefault(def);
        conLineSeg.setFilter(filter);
        conLineSeg.addListener(new ConLineSeg2D.Listener(){

            @Override
            public void lineSegConstructed(Line2D l) {
                lineSeg.setLine(l);
                Construction.this.m_aborted = false;
                conLineSeg.dispose();
            }

            @Override
            public void dialogAborted() {
                Construction.this.m_aborted = true;
                conLineSeg.dispose();
            }
        });
        conLineSeg.show();
        if (this.m_aborted) {
            throw new CmdAbortedException();
        }
    }

    public void circle2D(Ellipse2D cir) throws CmdAbortedException, InfiniteCircleException {
        this.circle2D(Messages.getString("kernel.constr.Construction.6"), cir);
    }

    public void circle2D(String prompt, Ellipse2D cir) throws CmdAbortedException, InfiniteCircleException {
        this.circle2D(prompt, cir, null);
    }

    public void circle2D(String prompt, Ellipse2D cir, Ellipse2D defCircle) throws CmdAbortedException, InfiniteCircleException {
        this.circle2D(prompt, cir, defCircle, null);
    }

    public void circle2D(String prompt, final Ellipse2D cir, Ellipse2D defCircle, ConObject.Filter filter) throws CmdAbortedException, InfiniteCircleException {
        final ConCircle2D conCircle = new ConCircle2D(this.m_krnl);
        conCircle.setPrompt(prompt);
        conCircle.setDefault(defCircle);
        conCircle.setFilter(filter);
        conCircle.addListener(new ConCircle2D.Adapter(){

            @Override
            public void circleConstructed(Ellipse2D c) {
                Construction.this.m_aborted = false;
                Construction.this.m_infiniteCircle = c == null;
                if (c != null) {
                    cir.setFrame(c.getFrame());
                }
                conCircle.dispose();
            }

            @Override
            public void dialogAborted() {
                Construction.this.m_aborted = true;
                conCircle.dispose();
            }
        });
        conCircle.show();
        if (this.m_aborted) {
            throw new CmdAbortedException();
        }
        if (this.m_infiniteCircle) {
            throw new InfiniteCircleException();
        }
    }

    public Line2D arc2D(Arc2D arc) throws CmdAbortedException {
        return this.arc2D(Messages.getString("kernel.constr.Construction.7"), arc);
    }

    public Line2D arc2D(String prompt, Arc2D arc) throws CmdAbortedException {
        return this.arc2D(prompt, arc, null);
    }

    public Line2D arc2D(String prompt, Arc2D arc, Arc2D defArc) throws CmdAbortedException {
        return this.arc2D(prompt, arc, defArc, null);
    }

    public Line2D arc2D(String prompt, final Arc2D arc, Arc2D defArc, ConObject.Filter filter) throws CmdAbortedException {
        this.t_arcAsLineSeg = null;
        final ConArc2D conArc = new ConArc2D(this.m_krnl);
        conArc.setPrompt(prompt);
        conArc.setDefault(defArc);
        conArc.setFilter(filter);
        conArc.addListener(new ConArc2D.Listener(){

            @Override
            public void arcConstructed(Shape a) {
                if (a instanceof Arc2D) {
                    arc.setArc((Arc2D)a);
                } else if (a instanceof Line2D) {
                    arc.setArc(new Arc2D.Double());
                    Construction.this.t_arcAsLineSeg = (Line2D)a;
                }
                Construction.this.m_aborted = false;
                conArc.dispose();
            }

            @Override
            public void dialogAborted() {
                Construction.this.m_aborted = true;
                conArc.dispose();
            }
        });
        conArc.show();
        if (this.m_aborted) {
            throw new CmdAbortedException();
        }
        return this.t_arcAsLineSeg;
    }

    public double scale2D() throws CmdAbortedException {
        return this.scale2D(Messages.getString("kernel.constr.Construction.8"), Double.NaN);
    }

    public double scale2D(String prompt) throws CmdAbortedException {
        return this.scale2D(prompt, Double.NaN);
    }

    public double scale2D(String prompt, double def) throws CmdAbortedException {
        return this.scale2D(prompt, def, null);
    }

    public double scale2D(String prompt, double def, ConObject.Filter filter) throws CmdAbortedException {
        final ConScale2D conScale = new ConScale2D(this.m_krnl);
        conScale.setPrompt(prompt);
        conScale.setDefault(def);
        conScale.setFilter(filter);
        conScale.addListener(new ConScale2D.Listener(){

            @Override
            public void scaleConstructed(double scale) {
                Construction.this.m_scale = scale;
                Construction.this.m_aborted = false;
                conScale.dispose();
            }

            @Override
            public void dialogAborted() {
                Construction.this.m_aborted = true;
                conScale.dispose();
            }
        });
        conScale.show();
        if (this.m_aborted) {
            throw new CmdAbortedException();
        }
        return this.m_scale;
    }

    public static Cursor getPickNearCursor() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getBestCursorSize(10, 10);
        BufferedImage img = new BufferedImage(dim.width, dim.height, 6);
        Graphics2D gfx = (Graphics2D)((Image)img).getGraphics();
        gfx.setPaintMode();
        gfx.setColor(Color.BLACK);
        gfx.setStroke(new BasicStroke());
        gfx.drawRect(0, 0, 9, 9);
        gfx.dispose();
        return toolkit.createCustomCursor(img, new Point(5, 5), "PickNearCursor");
    }

    public static Cursor getDigitizeUngriddedCursor() {
        return Cursor.getPredefinedCursor(1);
    }

    public static Cursor getDigitizeGriddedCursor() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int CROSS_SIZE = 17;
        int CURSOR_SIZE = 30;
        Dimension dim = toolkit.getBestCursorSize(30, 30);
        BufferedImage img = new BufferedImage(dim.width, dim.height, 6);
        Graphics2D gfx = (Graphics2D)((Image)img).getGraphics();
        gfx.setPaintMode();
        gfx.setColor(Color.BLACK);
        gfx.setStroke(new BasicStroke());
        gfx.drawLine(0, 8, 16, 8);
        gfx.drawLine(8, 0, 8, 16);
        int i = 12;
        while (i < 30) {
            int j = 12;
            while (j < 30) {
                gfx.drawLine(i - 1, j - 1, i + 1, j + 1);
                gfx.drawLine(i - 1, j + 1, i + 1, j - 1);
                j += 7;
            }
            i += 7;
        }
        gfx.dispose();
        return toolkit.createCustomCursor(img, new Point(8, 8), "GridCursor");
    }

    public static Cursor getSnapCursor() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getBestCursorSize(10, 10);
        BufferedImage img = new BufferedImage(dim.width, dim.height, 6);
        Graphics2D gfx = (Graphics2D)((Image)img).getGraphics();
        gfx.setPaintMode();
        gfx.setColor(Color.BLACK);
        gfx.setStroke(new BasicStroke());
        gfx.drawRect(0, 0, 9, 9);
        gfx.drawLine(0, 0, 9, 9);
        gfx.drawLine(0, 9, 9, 0);
        gfx.dispose();
        return toolkit.createCustomCursor(img, new Point(5, 5), "SnapCursor");
    }

    UserInterface getUI() {
        return this.m_krnl.getUserInterface();
    }
}

