/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.interpreter;

import cib.cad.kernel.interpreter.DefaultNumberInterpreterConstants;
import cib.cad.kernel.interpreter.DefaultNumberInterpreterTokenManager;
import cib.cad.kernel.interpreter.JavaCharStream;
import cib.cad.kernel.interpreter.NumberInterpreter;
import cib.cad.kernel.interpreter.ParseException;
import cib.cad.kernel.interpreter.Token;
import cib.cad.kernel.interpreter.TokenMgrError;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;

public class DefaultNumberInterpreter
implements NumberInterpreter,
DefaultNumberInterpreterConstants {
    public DefaultNumberInterpreterTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[6];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    static {
        DefaultNumberInterpreter.jj_la1_0();
    }

    public static void main(String[] args) throws ParseException {
        DefaultNumberInterpreter interpreter = new DefaultNumberInterpreter(System.in);
        while (true) {
            interpreter.ReInit(System.in);
            System.out.print("Enter expression: ");
            System.out.flush();
            try {
                interpreter.start();
                continue;
            }
            catch (TokenMgrError e) {
                System.out.println(e);
                continue;
            }
            catch (ParseException e) {
                System.out.println(e);
                continue;
            }
            break;
        }
    }

    @Override
    public Number getNumber(String token) {
        StringReader reader = new StringReader(token);
        this.ReInit(reader);
        try {
            return this.sum();
        }
        catch (TokenMgrError tokenMgrError) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Illegal number");
    }

    public final void start() throws ParseException {
        Number n = this.sum();
        this.jj_consume_token(16);
    }

    public final Number sum() throws ParseException {
        Number left = this.prod();
        while (this.jj_2_1(Integer.MAX_VALUE)) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    op = this.jj_consume_token(5);
                    break;
                }
                case 6: {
                    op = this.jj_consume_token(6);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Number right = this.prod();
            if (left instanceof Integer && right instanceof Integer) {
                left = new Integer(op.kind == 5 ? left.intValue() + right.intValue() : left.intValue() - right.intValue());
                continue;
            }
            left = new Double(op.kind == 5 ? left.doubleValue() + right.doubleValue() : left.doubleValue() - right.doubleValue());
        }
        return left;
    }

    public final Number prod() throws ParseException {
        Number left = this.exp();
        block7: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    op = this.jj_consume_token(7);
                    break;
                }
                case 8: {
                    op = this.jj_consume_token(8);
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Number right = this.exp();
            if (left instanceof Integer && right instanceof Integer) {
                left = new Integer(op.kind == 7 ? left.intValue() * right.intValue() : left.intValue() / right.intValue());
                continue;
            }
            left = new Double(op.kind == 7 ? left.doubleValue() * right.doubleValue() : left.doubleValue() / right.doubleValue());
        }
        return left;
    }

    public final Number exp() throws ParseException {
        Number left = this.unary();
        while (this.jj_2_2(Integer.MAX_VALUE)) {
            this.jj_consume_token(9);
            Number right = this.exp();
            if (left instanceof Integer && right instanceof Integer) {
                left = new Integer((int)Math.pow(left.doubleValue(), right.doubleValue()));
                continue;
            }
            left = new Double(Math.pow(left.doubleValue(), right.doubleValue()));
        }
        return left;
    }

    public final Number unary() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 10: 
            case 14: 
            case 17: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[3] = this.jj_gen;
                    }
                }
                Number operand = this.number();
                return operand;
            }
            case 6: {
                this.jj_consume_token(6);
                Number operand = this.number();
                if (operand instanceof Integer) {
                    return new Integer(-operand.intValue());
                }
                return new Double(-operand.doubleValue());
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Number number() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                Token c = this.jj_consume_token(10);
                return Integer.valueOf(c.image);
            }
            case 14: {
                Token c = this.jj_consume_token(14);
                String literal = c.image.replace(',', '.');
                return Double.valueOf(literal);
            }
            case 17: {
                this.jj_consume_token(17);
                Number val = this.sum();
                this.jj_consume_token(18);
                return val;
            }
        }
        this.jj_la1[5] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private final boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(5)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(6)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_2() {
        return this.jj_scan_token(9);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{96, 384, 384, 32, 148576, 148480};
    }

    public DefaultNumberInterpreter(InputStream stream) {
        this(stream, null);
    }

    public DefaultNumberInterpreter(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new DefaultNumberInterpreterTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public DefaultNumberInterpreter(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new DefaultNumberInterpreterTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public DefaultNumberInterpreter(DefaultNumberInterpreterTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(DefaultNumberInterpreterTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) {
                        exists = false;
                        break;
                    }
                    ++i2;
                }
                if (exists) break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[19];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i = 0;
        while (i < 6) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 19) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 2) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
            ++i;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

