/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view;

import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineDialogAdapter;
import cib.cad.lang.Messages;
import cib.util.view.SingleRowLayout;
import cib.util.view.ViewUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class CmdLineDialogPanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    private static final char[] SPECIAL_CHARS = new char[]{'\u00b1', '\u00b0', '\u00d8', '\u00b5', '\u03c0', ' ', '\u00b2', '\u00b3', '\u00bc', '\u00bd', '\u00be', ' ', '\u00a9', '\u00ae'};
    private List<JButton> m_buttons = new ArrayList<JButton>();
    private Set<Listener> m_inputListeners = new HashSet<Listener>();
    private boolean m_enabled = false;
    private String m_promptPrefix = "";
    private final JPanel m_textPanel = new JPanel();
    private final JPanel m_menuPanel = new JPanel();
    private final JLabel m_promptLabel = new JLabel();
    private final JTextField m_inputField = new JTextField();
    private final JButton m_specialCharacters = new JButton("\u00d8,\u00b1,...");
    private final JProgressBar m_progressBar = new JProgressBar();
    private ActionListener m_actionListener;
    private FocusListener m_focusListener = new FocusListener(){
        private Component m_focusedComponent = null;

        @Override
        public void focusGained(FocusEvent e) {
            JFrame frame = (JFrame)CmdLineDialogPanel.this.getTopLevelAncestor();
            if (this.m_focusedComponent != null && frame != null && frame.isFocused()) {
                this.m_focusedComponent.requestFocusInWindow();
            } else if (CmdLineDialogPanel.this.m_inputField != null) {
                CmdLineDialogPanel.this.m_inputField.requestFocusInWindow();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.m_focusedComponent = null;
            if (CmdLineDialogPanel.this.m_inputField.isEnabled()) {
                this.m_focusedComponent = CmdLineDialogPanel.this.m_inputField;
            } else {
                for (JButton button : CmdLineDialogPanel.this.m_buttons) {
                    if (!button.hasFocus()) continue;
                    this.m_focusedComponent = button;
                    break;
                }
            }
        }
    };
    private static final String CANCEL_TEXT = "Cancel";
    private static final String KEY_CANCEL_TEXT_LOC = "view.CmdLineDialogPanel.2";
    private static final String KEY_CANCEL_HINTS = "view.CmdLineDialogPanel.3";
    private static final String INTERRUPT_TEXT = "Interrupt";
    private static final String KEY_INTERRUPT_TEXT_LOC = "view.CmdLineDialogPanel.5";
    private static final String KEY_INTERRUPT_HINTS = "view.CmdLineDialogPanel.6";
    private static final String KEY_SPECIAL_CHARACTERS_TOOL_TIP_TEXT = "view.CmdLineDialogPanel.11";
    private static final boolean MAC_OS = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private static final boolean LINUX = System.getProperty("os.name").toLowerCase().startsWith("linux");
    private static final int MOD_SELECT_ALL = ViewUtilities.SHORTCUT;
    private static final int KEY_SELECT_ALL = 65;
    private static final int MOD_REMOVE = 0;
    private static final int KEY_REMOVE = 127;
    private static final int MOD_CANCEL = 0;
    private static final int KEY_CANCEL = 27;

    public CmdLineDialogPanel() {
        this.constructGUI();
    }

    public CmdLineDialogPanel(String prompt) {
        this.constructGUI();
    }

    private void constructGUI() {
        this.m_specialCharacters.setToolTipText(Messages.getString(KEY_SPECIAL_CHARACTERS_TOOL_TIP_TEXT));
        this.m_promptLabel.setText("");
        Dimension dim = this.m_progressBar.getPreferredSize();
        this.m_progressBar.setPreferredSize(new Dimension(40, dim.height));
        this.m_specialCharacters.putClientProperty("JButton.buttonType", "textured");
        JPanel buttonAndTextPanel = new JPanel();
        BorderLayout bl = new BorderLayout();
        bl.setHgap(0);
        buttonAndTextPanel.setLayout(bl);
        buttonAndTextPanel.add((Component)this.m_specialCharacters, "West");
        buttonAndTextPanel.add((Component)this.m_inputField, "Center");
        buttonAndTextPanel.add((Component)this.m_progressBar, "East");
        this.m_specialCharacters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionListener al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String text = CmdLineDialogPanel.this.m_inputField.getText();
                        int pos = CmdLineDialogPanel.this.m_inputField.getCaretPosition();
                        String specChar = e.getActionCommand();
                        text = String.valueOf(text.substring(0, pos)) + specChar + text.substring(pos);
                        CmdLineDialogPanel.this.m_inputField.setText(text);
                        CmdLineDialogPanel.this.m_inputField.setCaretPosition(pos + 1);
                    }
                };
                final JPopupMenu popupMenu = new JPopupMenu();
                int i = 0;
                while (i < SPECIAL_CHARS.length) {
                    if (SPECIAL_CHARS[i] == ' ') {
                        popupMenu.addSeparator();
                    } else {
                        String str = new String(new char[]{SPECIAL_CHARS[i]});
                        JMenuItem menuItem = new JMenuItem(str);
                        menuItem.addActionListener(al);
                        popupMenu.add(menuItem);
                    }
                    ++i;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        popupMenu.show(CmdLineDialogPanel.this.m_specialCharacters, 0, 0);
                    }
                });
            }
        });
        bl = new BorderLayout();
        bl.setHgap(10);
        this.m_textPanel.setLayout(bl);
        this.m_textPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.m_textPanel.add((Component)this.m_promptLabel, "West");
        this.m_textPanel.add((Component)buttonAndTextPanel, "Center");
        JButton continuationButton = new JButton("\u00bb");
        continuationButton.setFont(new Font("sansserif", 0, 20));
        continuationButton.putClientProperty("JButton.buttonType", "toolbar");
        continuationButton.setFocusable(false);
        this.m_menuPanel.setLayout(new SingleRowLayout(continuationButton, 5));
        if (!MAC_OS) {
            continuationButton.setBorderPainted(false);
            continuationButton.setBorder(new EmptyBorder(0, 2, 0, 2));
            this.m_menuPanel.setBorder(new EmptyBorder(6, 0, 4, 0));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_textPanel, "North");
        this.add((Component)this.m_menuPanel, "South");
        this.m_actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton button = (JButton)e.getSource();
                if (button.getName().equals(CmdLineDialogPanel.CANCEL_TEXT)) {
                    CmdLineDialogPanel.this._gotInput("#cancel()");
                } else if (button.getName().equals(CmdLineDialogPanel.INTERRUPT_TEXT)) {
                    CmdLineDialogPanel.this._gotInput("#interrupt()");
                } else {
                    CmdLineDialogPanel.this._gotInput("#menu(\"" + button.getName() + "\")");
                }
            }
        };
        this.m_inputField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n' && e.getModifiers() == 0) {
                    CmdLineDialogPanel.this._gotInput(CmdLineDialogPanel.this.m_inputField.getText());
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (CmdLineDialogPanel.this.m_inputField.getText().isEmpty()) {
                    if (e.getModifiers() == MOD_SELECT_ALL && e.getKeyCode() == 65) {
                        e.consume();
                        CmdLineDialogPanel.this._gotInput("#interrupt(\"selectAll #menu(Done)\")");
                    } else if (e.getModifiers() == 0 && e.getKeyCode() == 127) {
                        e.consume();
                        CmdLineDialogPanel.this._gotInput("#interrupt(remove)");
                    }
                }
                if (e.getModifiers() == 0 && e.getKeyCode() == 27) {
                    CmdLineDialogPanel.this._gotInput("#cancel()");
                }
            }
        });
        this._showGUI(new CmdLineDialogAdapter(), true);
    }

    protected void _showGUIlater(final CmdLineDialog dlg, final boolean startCmd) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CmdLineDialogPanel.this._showGUI(dlg, startCmd);
            }
        });
        this.revalidate();
    }

    protected void setPromptPrefix(String prefix) {
        this.m_promptPrefix = prefix;
    }

    protected void _clearChoices(boolean isCancelable, boolean isInterruptable) {
        this.m_menuPanel.removeAll();
        this.m_buttons.clear();
        this._addChoice(CANCEL_TEXT, Messages.getString(KEY_CANCEL_TEXT_LOC), Messages.getString(KEY_CANCEL_HINTS), isCancelable, false);
        this._addChoice(INTERRUPT_TEXT, Messages.getString(KEY_INTERRUPT_TEXT_LOC), Messages.getString(KEY_INTERRUPT_HINTS), isInterruptable, false);
    }

    protected void _addChoice(String item, String itemLocalized, String hints, boolean enabled, boolean checked) {
        JButton button = new JButton(String.valueOf(checked ? "\u2713 " : "") + itemLocalized);
        this.m_buttons.add(button);
        button.setName(item);
        if (hints != null) {
            button.setToolTipText(hints);
        }
        button.addActionListener(this.m_actionListener);
        button.setEnabled(enabled);
        this.m_menuPanel.add(button);
    }

    protected void _addSeparator() {
        Dimension dim = new Dimension(8, 30);
        Component comp = this.m_menuPanel.getComponent(0);
        if (comp instanceof JButton) {
            dim = ((JButton)comp).getPreferredSize();
        }
        dim.width = 8;
        JLabel separator = new JLabel(LINUX ? "o" : "\u25cf");
        separator.setPreferredSize(dim);
        this.m_menuPanel.add(separator);
    }

    protected boolean addListener(Listener l) {
        return this.m_inputListeners.add(l);
    }

    protected boolean removeListener(Listener l) {
        return this.m_inputListeners.remove(l);
    }

    protected Iterator<Listener> listenerIterator() {
        return this.m_inputListeners.iterator();
    }

    private void _gotInput(String input) {
        if (this.m_enabled) {
            for (Listener l : this.m_inputListeners) {
                l.gotInput(input);
            }
        }
    }

    private String _getLocalizedChoiceAt(int iChoice, CmdLineDialog dlg) {
        String uniqueName = dlg.getUniqueName();
        String choice = dlg.getChoiceAt(iChoice);
        String choiceText = uniqueName == null ? choice : Messages.getString(String.valueOf(uniqueName) + "." + choice);
        return choiceText.startsWith("!") && choiceText.endsWith("!") ? choice : choiceText;
    }

    private void _showGUI(CmdLineDialog dlg, boolean startCmd) {
        this.m_specialCharacters.setToolTipText(Messages.getString(KEY_SPECIAL_CHARACTERS_TOOL_TIP_TEXT));
        this.m_promptLabel.setText(" " + this.m_promptPrefix + dlg.getPrompt());
        if (dlg.getPromptHints() != null) {
            this.m_promptLabel.setToolTipText(dlg.getPromptHints());
        }
        this.m_inputField.setEnabled(true);
        this.m_specialCharacters.setEnabled(true);
        String text = dlg.getDefaultText() != null ? dlg.getDefaultText() : "";
        this.m_inputField.setText(text);
        this.m_inputField.setCaretPosition(text.endsWith("\"") ? text.length() - 1 : text.length());
        this._setProgressEnabled(false);
        if (startCmd) {
            this._clearChoices(false, false);
        } else {
            this._clearChoices(true, dlg.isInterruptable());
            if (dlg.getNumberOfChoices() > 0) {
                this._addSeparator();
            }
            int i = 0;
            while (i < dlg.getNumberOfChoices()) {
                this._addChoice(dlg.getChoiceAt(i), this._getLocalizedChoiceAt(i, dlg), dlg.getChoiceHints(i), dlg.isChoiceEnabled(i), dlg.isChoiceChecked(i));
                if (dlg.hasSeparatorAt(i)) {
                    this._addSeparator();
                }
                ++i;
            }
        }
        this._setEnabled(true);
        JFrame frame = (JFrame)this.getTopLevelAncestor();
        if (frame != null && frame.isFocused()) {
            Component componentToFocus = null;
            if (this.m_buttons.get(0) != null) {
                componentToFocus = this.m_buttons.get(0);
            }
            if (this.m_inputField.isEnabled()) {
                componentToFocus = this.m_inputField;
            }
            if (dlg.getDefaultChoice() < 0) {
                if (this.m_inputField.isEnabled()) {
                    componentToFocus = this.m_inputField;
                }
            } else {
                JButton button;
                int iButton = dlg.getDefaultChoice() + 1;
                if (dlg.isInterruptable()) {
                    ++iButton;
                }
                if ((button = this.m_buttons.get(iButton)) != null) {
                    componentToFocus = button;
                }
            }
            if (componentToFocus != null) {
                componentToFocus.requestFocusInWindow();
            }
        }
        this.repaint();
    }

    protected void _disposeGUI() {
        this._setEnabled(false);
        this._clearChoices(false, false);
        this.m_promptLabel.setText("...");
        this.m_specialCharacters.setEnabled(false);
        this.m_inputField.setText("");
        this.m_inputField.setEnabled(false);
        this._setProgressEnabled(true);
        this.setEnabled(false);
    }

    protected void _setEnabled(boolean enabled) {
        this.m_enabled = enabled;
        JFrame frame = (JFrame)this.getTopLevelAncestor();
        if (frame != null && this.m_focusListener != null) {
            frame.addFocusListener(this.m_focusListener);
            this.m_focusListener = null;
        }
    }

    protected void _setProgressEnabled(final boolean on) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CmdLineDialogPanel.this.m_progressBar.setIndeterminate(on);
            }
        });
    }

    public static class Listener {
        public void gotInput(String input) {
        }
    }
}

