/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class InfoAreaPrintStream
extends PrintStream {
    private JTextArea m_textArea;
    private JTextField m_textField;
    private boolean m_textAreaToBeCleared = true;

    public InfoAreaPrintStream(JTextArea textArea, JTextField textField) {
        super(new ByteArrayOutputStream());
        this.m_textField = textField;
        this.m_textArea = textArea;
    }

    @Override
    public boolean checkError() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void print(boolean b) {
        this.append(b ? "true" : "false", true);
    }

    @Override
    public void print(char c) {
        this.append(String.valueOf(c), true);
    }

    @Override
    public void print(char[] s) {
        this.append(String.valueOf(s), true);
    }

    @Override
    public void print(double d) {
        this.append(String.valueOf(d), true);
    }

    @Override
    public void print(float f) {
        this.append(String.valueOf(f), true);
    }

    @Override
    public void print(int i) {
        this.append(String.valueOf(i), true);
    }

    @Override
    public void print(long l) {
        this.append(String.valueOf(l), true);
    }

    @Override
    public void print(Object obj) {
        this.append(String.valueOf(obj), true);
    }

    @Override
    public void print(String s) {
        this.append(s, true);
    }

    @Override
    public void println() {
        this.append("\n", true);
    }

    @Override
    public void println(boolean x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char[] x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(double x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(float x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(int x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(long x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(Object x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(String x) {
        this.print(x);
        this.println();
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.print(new String(buf, off, len));
    }

    @Override
    public void write(int b) {
        this.print(String.valueOf((char)b));
    }

    @Override
    public void write(byte[] b) {
        this.print(new String(b));
    }

    private void append(String text, boolean show) {
        int endPos;
        if (text == null) {
            return;
        }
        this.m_textArea.append(text);
        if (show) {
            this.showBottom();
        }
        if (-1 == text.indexOf(10)) {
            if (this.m_textAreaToBeCleared) {
                this.m_textField.setText(text);
            } else {
                this.m_textField.setText(String.valueOf(this.m_textField.getText()) + text);
            }
            this.m_textAreaToBeCleared = false;
            return;
        }
        int i = endPos = text.length() - 1;
        while (i >= 0) {
            if (text.charAt(i) != '\n') break;
            endPos = i - 1;
            this.m_textAreaToBeCleared = true;
            if (endPos <= 0) {
                return;
            }
            --i;
        }
        int startPos = endPos;
        int i2 = endPos;
        while (i2 >= 0) {
            if (text.charAt(i2) == '\n') break;
            startPos = i2--;
        }
        this.m_textField.setText(text.substring(startPos, endPos + 1));
    }

    private void showBottom() {
        try {
            int pos = this.m_textArea.getDocument().getLength();
            this.m_textArea.setCaretPosition(pos > 0 ? pos - 1 : 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

