/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view;

import cib.cad.kernel.CancelToken;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineDialogAdapter;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.InputDevice;
import cib.cad.kernel.InterruptToken;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.MenuItemToken;
import cib.cad.kernel.NormDigitizeToken;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.WindowToken;
import cib.cad.kernel.interpreter.ArgumentTokenizer;
import cib.cad.kernel.interpreter.CmdLineInterpreter;
import cib.cad.kernel.interpreter.ParseException;
import cib.cad.kernel.interpreter.TokenMgrError;
import cib.cad.lang.Messages;
import cib.cad.view.CmdLineDialogInputDevice;
import cib.cad.view.CmdLineDialogPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.JFrame;

public class InputManager {
    private final boolean showErrors = false;
    private Set<InputDevice> m_inputDevices = new HashSet<InputDevice>();
    private Kernel m_krnl;
    private CmdLineDialogPanel m_cmdLineDialogPanel;
    private InputDevice.Listener m_inputDeviceListener = new InputDevice.Listener(){

        @Override
        public synchronized void gotInput(String str) {
            try {
                if (InputManager.this.m_promptingForCommand) {
                    InputManager.this.m_rawInput = str;
                    InputManager.this.resume();
                } else {
                    ArgumentTokenizer tokenizer = InputManager.this.m_krnl.getArgumentTokenizer();
                    List<CmdLineToken> tokens = tokenizer.getTokens(str);
                    int n = tokens.size();
                    int i = 0;
                    while (i < n) {
                        CmdLineToken token = tokens.get(i);
                        if (token instanceof TextToken && token.toString().equalsIgnoreCase("picknear")) {
                            tokens.remove(i);
                            --n;
                            --i;
                        }
                        ++i;
                    }
                    InputManager.this.m_krnl.addArguments(tokens);
                    InputManager.this.consumeArgsByCmdLineDialog();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    };
    private String m_rawInput = null;
    private boolean m_promptingForCommand = true;
    private Stack<_State> m_stateStack = new Stack();
    private int m_nResumed = 0;

    protected InputManager() {
    }

    public InputManager(Kernel krnl, CmdLineDialogPanel panel) {
        this.m_krnl = krnl;
        this.m_cmdLineDialogPanel = panel;
        this.addInputDevice(new CmdLineDialogInputDevice(this.m_cmdLineDialogPanel));
        this.m_stateStack.push(new _State());
    }

    public boolean addInputDevice(InputDevice device) {
        device.addInputListener(this.m_inputDeviceListener);
        return this.m_inputDevices.add(device);
    }

    public boolean removeInputDevice(InputDevice device) {
        return this.m_inputDevices.remove(device);
    }

    public String promptForCommand(String prompt) {
        this.m_promptingForCommand = true;
        this._setCursor(0);
        if (this.m_krnl.hasArgument()) {
            return this.m_krnl.consumeArgument().toString();
        }
        CmdLineDialog dlg = this.getCmdLineDialog();
        dlg.setPrompt(prompt);
        dlg.enableTextInput();
        this.m_cmdLineDialogPanel._showGUIlater(dlg, true);
        this.suspend();
        return this.m_rawInput;
    }

    public CmdLineDialog getCmdLineDialog() {
        return new CmdLineDialogAdapter();
    }

    public void showCmdLineDialog(CmdLineDialog dlg) {
        this.m_promptingForCommand = false;
        this._replaceCursor(3, 0);
        _State state = this.getCurrentState();
        state.m_cmdLineDialog = dlg;
        UserInterface ui = this.m_krnl.getUserInterface();
        JFrame frame = (JFrame)((Object)ui);
        if (frame.isCursorSet()) {
            state.m_cursors.put(frame, frame.getCursor());
        }
        Iterator<GeometryPanel> gpit = ui.geometryPanelIterator();
        while (gpit.hasNext()) {
            Component panel = (Component)((Object)gpit.next());
            if (!panel.isCursorSet()) continue;
            state.m_cursors.put(panel, panel.getCursor());
        }
        if (!this.consumeArguments(dlg)) {
            this.m_cmdLineDialogPanel._showGUIlater(dlg, false);
            this.suspend();
            this._setCursor(3);
            this.m_cmdLineDialogPanel._disposeGUI();
        }
        state.m_cmdLineDialog = null;
    }

    public CmdLineDialog getActiveCmdLineDialogAt(int index) {
        if (index < 0 || index >= this.m_stateStack.size()) {
            throw new IllegalArgumentException();
        }
        return ((_State)this.m_stateStack.get(this.m_stateStack.size() - index - 1)).m_cmdLineDialog;
    }

    private void _setCursor(int cursorType) {
        JFrame frame = (JFrame)((Object)this.m_krnl.getUserInterface());
        UserInterface ui = this.m_krnl.getUserInterface();
        if (!ui.isDrawingEnabled()) {
            return;
        }
        frame.setCursor(Cursor.getPredefinedCursor(cursorType));
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            Component panel = (Component)((Object)it.next());
            panel.setCursor(Cursor.getPredefinedCursor(cursorType));
        }
    }

    private void _replaceCursor(int oldCursorType, int newCursorType) {
        JFrame frame = (JFrame)((Object)this.m_krnl.getUserInterface());
        UserInterface ui = this.m_krnl.getUserInterface();
        if (!ui.isDrawingEnabled()) {
            return;
        }
        if (frame.getCursor().getType() == oldCursorType) {
            frame.setCursor(Cursor.getPredefinedCursor(newCursorType));
        }
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            Component panel = (Component)((Object)it.next());
            if (panel.getCursor().getType() != oldCursorType) continue;
            panel.setCursor(Cursor.getPredefinedCursor(newCursorType));
        }
    }

    public void disposeCmdLineDialog() {
        this.resume();
    }

    public void consumeArgsByCmdLineDialog() {
        _State state = this.getCurrentState();
        CmdLineDialog dlg = state.m_cmdLineDialog;
        if (dlg != null) {
            this.consumeArguments(dlg);
        }
    }

    private synchronized boolean consumeArguments(CmdLineDialog dlg) {
        UserInterface ui = this.m_krnl.getUserInterface();
        int nResumed = this.m_nResumed;
        while (this.m_krnl.hasArgument() && nResumed == this.m_nResumed) {
            Iterator<CmdLineDialog.Listener> it;
            GeometryPanel _gp;
            Iterator<Object> it2;
            CmdLineToken token;
            CmdLineToken arg = this.m_krnl.consumeArgument();
            String interruptArguments = null;
            if (arg instanceof MenuItemToken) {
                token = (MenuItemToken)arg;
                int index = dlg.getChoiceIndex(((MenuItemToken)token).getText());
                if (index == -1) {
                    arg = null;
                } else if (!dlg.isChoiceEnabled(index)) {
                    arg = null;
                } else {
                    it2 = dlg.listenerIterator();
                    while (it2.hasNext()) {
                        ((CmdLineDialog.Listener)it2.next()).choiceSelected(index);
                    }
                }
            } else if (arg instanceof DigitizeToken) {
                token = (DigitizeToken)arg;
                GeometryPanel gp = null;
                it2 = ui.geometryPanelIterator();
                while (gp == null && it2.hasNext()) {
                    _gp = (GeometryPanel)it2.next();
                    if (_gp.getId() != ((DigitizeToken)token).getWindow()) continue;
                    gp = _gp;
                }
                if ((gp.getId() & dlg.digitizeEnabledWinMask()) == 0) {
                    arg = null;
                } else {
                    Iterator<CmdLineDialog.Listener> _it = dlg.listenerIterator();
                    while (_it.hasNext()) {
                        _it.next().digitized(((DigitizeToken)token).getX(), ((DigitizeToken)token).getY(), gp);
                    }
                }
            } else if (arg instanceof NormDigitizeToken) {
                token = (NormDigitizeToken)arg;
                GeometryPanel gp = null;
                it2 = ui.geometryPanelIterator();
                while (gp == null && it2.hasNext()) {
                    _gp = (GeometryPanel)it2.next();
                    if (_gp.getId() != ((NormDigitizeToken)token).getWindow()) continue;
                    gp = _gp;
                }
                if ((gp.getId() & dlg.digitizeEnabledWinMask()) == 0) {
                    arg = null;
                } else {
                    DigitizeToken digToken = ((NormDigitizeToken)token).getDigitizeToken(gp);
                    Iterator<CmdLineDialog.Listener> _it = dlg.listenerIterator();
                    while (_it.hasNext()) {
                        _it.next().digitized(digToken.getX(), digToken.getY(), gp);
                    }
                }
            } else if (arg instanceof WindowToken) {
                token = (WindowToken)arg;
                int winMask = ((WindowToken)token).getWindows() & dlg.digitizeEnabledWinMask();
                if (winMask == 0) {
                    arg = null;
                } else {
                    it2 = dlg.listenerIterator();
                    while (it2.hasNext()) {
                        ((CmdLineDialog.Listener)it2.next()).windowSpecified(((WindowToken)token).getWindows());
                    }
                }
            } else if (arg instanceof TextToken) {
                if (!dlg.textEnabled()) {
                    arg = null;
                } else {
                    token = (TextToken)arg;
                    Iterator<CmdLineDialog.Listener> it3 = dlg.listenerIterator();
                    while (it3.hasNext()) {
                        it3.next().textEntered(((TextToken)token).toString());
                    }
                }
            } else if (arg instanceof CancelToken) {
                it = dlg.listenerIterator();
                while (it.hasNext()) {
                    it.next().dialogAborted();
                }
            } else if (arg instanceof InterruptToken) {
                InterruptToken irToken = (InterruptToken)arg;
                Iterator<CmdLineDialog.Listener> it4 = dlg.listenerIterator();
                while (it4.hasNext()) {
                    it4.next().interruptStarts(irToken.getText());
                }
                interruptArguments = irToken.getText();
            }
            if (arg != null) {
                it = dlg.listenerIterator();
                while (it.hasNext()) {
                    it.next().gotToken(arg);
                }
            }
            if (interruptArguments == null) continue;
            this.interruptCommand(TextToken.literalToString(interruptArguments));
            return this.consumeArguments(dlg);
        }
        return nResumed != this.m_nResumed;
    }

    private _State getCurrentState() {
        return this.m_stateStack.peek();
    }

    private void interruptCommand(String args) {
        _State lastState = this.getCurrentState();
        lastState.m_argList = this.m_krnl.getArguments();
        lastState.m_variableArgMap = this.m_krnl.getVariableArguments();
        this.m_krnl.clearArguments();
        UserInterface ui = this.m_krnl.getUserInterface();
        Iterator<GeometryPanel> gpit = ui.geometryPanelIterator();
        while (gpit.hasNext()) {
            GeometryPanel drawPanel = gpit.next();
            HashSet<GeometryPanel.RubberbandListener> listeners = new HashSet<GeometryPanel.RubberbandListener>();
            lastState.m_rubberBands.put(drawPanel, listeners);
            Iterator<GeometryPanel.RubberbandListener> it = drawPanel.listenerIterator();
            while (it.hasNext()) {
                GeometryPanel.RubberbandListener l = it.next();
                l.reset();
                listeners.add(l);
                it.remove();
            }
            HashSet<GeometryPanel.AnnotationRenderer> renderers = new HashSet<GeometryPanel.AnnotationRenderer>();
            lastState.m_annotationRenderers.put(drawPanel, renderers);
            Iterator<GeometryPanel.AnnotationRenderer> arit = drawPanel.annotationRendererIterator();
            while (arit.hasNext()) {
                GeometryPanel.AnnotationRenderer ar = arit.next();
                renderers.add(ar);
                arit.remove();
            }
        }
        _State newState = new _State();
        this.m_stateStack.push(newState);
        int nInterrupted = this.m_stateStack.size() - 1;
        this.m_cmdLineDialogPanel.setPromptPrefix(String.valueOf(Messages.getString("view.InputManager.13")) + nInterrupted + ": ");
        if (!lastState.m_guard.isSuspended()) {
            this._interrupt(args);
        } else {
            InterruptThread thread = new InterruptThread(args);
            thread.start();
        }
    }

    private void _interrupt(String args) {
        int nInterrupted;
        if (args.equals("")) {
            args = this.promptForCommand(Messages.getString("view.InputManager.16"));
        }
        StringReader reader = new StringReader(String.valueOf(args) + ";");
        CmdLineInterpreter interpreter = new CmdLineInterpreter(reader);
        interpreter.addListener(new CmdLineInterpreter.Listener(){
            private String m_cmdName = null;
            private String m_args = "";

            @Override
            public void parsingCommand(String cmdName) {
                this.m_cmdName = cmdName;
                this.m_args = " ";
            }

            @Override
            public void parsingArgument(String arg) {
                this.m_args = String.valueOf(this.m_args) + arg + " ";
            }

            @Override
            public void parsingEndOfCommand() {
                InputManager.this.m_krnl.doCmd(this.m_cmdName, this.m_args);
            }
        });
        try {
            interpreter.ReInit(reader);
            interpreter.start();
        }
        catch (TokenMgrError e) {
            System.err.println(e);
        }
        catch (ParseException e) {
            System.err.println(e);
        }
        this.disposeCmdLineDialog();
        this.m_promptingForCommand = false;
        this.m_stateStack.pop();
        _State state = this.getCurrentState();
        this.m_krnl.addArguments(state.m_argList);
        this.m_krnl.putAllVariableArguments(state.m_variableArgMap);
        Set drawPanels = state.m_rubberBands.keySet();
        for (GeometryPanel drawPanel : drawPanels) {
            Set listeners = (Set)state.m_rubberBands.get(drawPanel);
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                GeometryPanel.RubberbandListener l = (GeometryPanel.RubberbandListener)iterator.next();
                drawPanel.addListener(l);
            }
            Set renderers = (Set)state.m_annotationRenderers.get(drawPanel);
            for (GeometryPanel.AnnotationRenderer ar : renderers) {
                drawPanel.addAnnotationRenderer(ar);
            }
        }
        Set uiComponents = state.m_cursors.keySet();
        for (Component uiComponent : uiComponents) {
            Cursor cursor = (Cursor)state.m_cursors.get(uiComponent);
            uiComponent.setCursor(cursor);
        }
        if (state.m_cmdLineDialog != null) {
            Iterator<CmdLineDialog.Listener> it = state.m_cmdLineDialog.listenerIterator();
            while (it.hasNext()) {
                it.next().interruptEnds();
            }
        }
        String prompt = (nInterrupted = this.m_stateStack.size() - 1) == 0 ? "" : String.valueOf(Messages.getString("view.InputManager.22")) + nInterrupted + ": ";
        this.m_cmdLineDialogPanel.setPromptPrefix(prompt);
        if (state.m_cmdLineDialog != null) {
            this.m_cmdLineDialogPanel._showGUIlater(state.m_cmdLineDialog, false);
        }
    }

    private void suspend() {
        _State state = this.getCurrentState();
        state.m_guard.suspend();
    }

    private void resume() {
        _State state = this.getCurrentState();
        state.m_guard.resume();
        ++this.m_nResumed;
    }

    private class InterruptThread
    extends Thread {
        private String m_argList;

        private InterruptThread(String argList) {
            super("CADEMIA command interrupt thread");
            this.m_argList = "";
            this.m_argList = argList;
        }

        @Override
        public void run() {
            InputManager.this._interrupt(this.m_argList);
        }
    }

    private class _Guard {
        private boolean m_suspended = false;

        private _Guard() {
        }

        public synchronized void suspend() {
            if (this.m_suspended) {
                throw new InternalError(Messages.getString("view.InputManager.24"));
            }
            this.m_suspended = true;
            while (this.m_suspended) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public synchronized void resume() {
            this.m_suspended = false;
            this.notifyAll();
        }

        public synchronized boolean isSuspended() {
            return this.m_suspended;
        }
    }

    class _State {
        private _Guard m_guard;
        private CmdLineDialog m_cmdLineDialog;
        private List<CmdLineToken> m_argList;
        private Map<String, CmdLineToken[]> m_variableArgMap;
        private Map<Component, Cursor> m_cursors;
        private Map<GeometryPanel, Set<GeometryPanel.RubberbandListener>> m_rubberBands;
        private Map<GeometryPanel, Set<GeometryPanel.AnnotationRenderer>> m_annotationRenderers;

        _State() {
            this.m_guard = new _Guard();
            this.m_cmdLineDialog = null;
            this.m_argList = null;
            this.m_variableArgMap = null;
            this.m_cursors = new HashMap<Component, Cursor>();
            this.m_rubberBands = new HashMap<GeometryPanel, Set<GeometryPanel.RubberbandListener>>();
            this.m_annotationRenderers = new HashMap<GeometryPanel, Set<GeometryPanel.AnnotationRenderer>>();
        }
    }
}

