/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view;

import cib.cad.kernel.LayeredGraphics2D;
import cib.cad.kernel.View;
import cib.util.geo.Geo2D;
import cib.util.view.FillPaint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;

public class ShapeView
implements View {
    private transient int m_lastClipStatus = 0;
    protected Shape m_boundaryShape = null;
    protected Paint m_boundaryPaint = null;
    protected Paint m_boundaryBorderPaint = null;
    protected Stroke m_boundaryBorderStroke = null;
    protected Shape m_interiorShape = null;
    protected Paint m_interiorPaint = null;
    protected boolean m_interiorPickable = false;
    private static boolean s_macOsQuartzOn;

    static {
        String quartz;
        s_macOsQuartzOn = false;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("mac os x") && (quartz = System.getProperty("apple.awt.graphics.UseQuartz")) != null) {
            s_macOsQuartzOn = quartz.toLowerCase().startsWith("true");
        }
    }

    public ShapeView(Shape bndShape, Paint bndPaint, Paint bndBrdPaint, Stroke bndBrdStroke) {
        this.setBoundaryShape(bndShape);
        this.setBoundaryPaint(bndPaint);
        this.setBoundaryBorderPaint(bndBrdPaint);
        this.setBoundaryBorderStroke(bndBrdStroke);
    }

    public ShapeView(Shape bndShape, Paint bndPaint, Paint bndBrdPaint, Stroke bndBrdStroke, Shape intShape, Paint intPaint) {
        this.setBoundaryShape(bndShape);
        this.setBoundaryPaint(bndPaint);
        this.setBoundaryBorderPaint(bndBrdPaint);
        this.setBoundaryBorderStroke(bndBrdStroke);
        this.setInteriorShape(intShape);
        this.setInteriorPaint(intPaint);
    }

    public void setBoundaryShape(Shape s) {
        this.m_boundaryShape = s;
    }

    public void setBoundaryPaint(Paint p) {
        this.m_boundaryPaint = p instanceof Color && p.equals(Color.WHITE) ? Color.BLACK : p;
    }

    public void setBoundaryBorderPaint(Paint p) {
        this.m_boundaryBorderPaint = p instanceof Color && p.equals(Color.WHITE) ? Color.BLACK : p;
    }

    public void setBoundaryBorderStroke(Stroke stroke) {
        this.m_boundaryBorderStroke = stroke;
    }

    public void setInteriorShape(Shape s) {
        this.m_interiorShape = s;
    }

    public void setInteriorPaint(Paint p) {
        Color c;
        if (p instanceof Color && (c = (Color)p).getRed() == Color.WHITE.getRed() && c.getGreen() == Color.WHITE.getGreen() && c.getBlue() == Color.WHITE.getBlue()) {
            this.m_interiorPaint = new Color(Color.BLACK.getRed(), Color.BLACK.getGreen(), Color.BLACK.getBlue(), c.getAlpha());
            return;
        }
        this.m_interiorPaint = p;
    }

    public void setInteriorPickable(boolean on) {
        this.m_interiorPickable = on;
    }

    @Override
    public void draw(Graphics g) {
        LayeredGraphics2D lg = (LayeredGraphics2D)g;
        if (lg.setLayer("COMPONENT_GRAPHICS")) {
            this._draw(g, this.m_boundaryPaint, this.m_boundaryBorderPaint, this.m_interiorPaint);
        }
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        if (this.m_interiorPickable && this.m_interiorShape != null) {
            return this.m_interiorShape.intersects(r);
        }
        return this._isStrokedBoundaryShape() ? this.m_boundaryShape.intersects(r) : Geo2D.collision(this.m_boundaryShape, r, 2.0);
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D rct = this.m_boundaryShape.getBounds2D();
        rct.setFrame(rct.getX() - 1.0, rct.getY() - 1.0, rct.getWidth() + 2.0, rct.getHeight() + 2.0);
        return rct;
    }

    protected void _draw(Graphics _g, Paint bndPaint, Paint bndBrdPaint, Paint intPaint) {
        BasicStroke bs;
        Graphics2D g = (Graphics2D)_g;
        if (intPaint != null) {
            if (s_macOsQuartzOn) {
                Color replacementColor = null;
                if (intPaint instanceof FillPaint) {
                    FillPaint fp = (FillPaint)intPaint;
                    replacementColor = fp.getReplacementColor();
                }
                if (replacementColor != null) {
                    g.setPaint(replacementColor);
                } else {
                    g.setPaint(intPaint);
                }
                Rectangle clip = g.getClipBounds();
                if (clip != null) {
                    clip.grow(2, 2);
                    Area areaShape = new Area(this.m_interiorShape);
                    Area areaClip = new Area(clip);
                    areaShape.intersect(areaClip);
                    g.fill(areaShape);
                } else {
                    g.fill(this.m_interiorShape);
                }
            } else {
                g.setPaint(intPaint);
                g.fill(this.m_interiorShape);
            }
        }
        if (bndPaint != null) {
            g.setPaint(bndPaint);
            g.fill(this.m_boundaryShape);
        }
        g.setStroke(this.m_boundaryBorderStroke);
        g.setPaint(bndBrdPaint);
        if (this.m_boundaryBorderStroke instanceof BasicStroke && (bs = (BasicStroke)this.m_boundaryBorderStroke).getDashArray() != null) {
            Path2D.Double clippedPath = new Path2D.Double();
            Rectangle clipBounds = g.getClipBounds();
            if (clipBounds != null) {
                clipBounds.grow(2, 2);
            }
            boolean connect = false;
            PathIterator pit = this.m_boundaryShape.getPathIterator(null, 1.0);
            Line2D.Double seg = null;
            double[] mvto = new double[2];
            double[] last = new double[2];
            double[] crds = new double[6];
            while (!pit.isDone()) {
                int type = pit.currentSegment(crds);
                switch (type) {
                    case 0: {
                        mvto[0] = crds[0];
                        mvto[1] = crds[1];
                        seg = null;
                        last[0] = crds[0];
                        last[1] = crds[1];
                        connect = false;
                        break;
                    }
                    case 1: {
                        seg = new Line2D.Double(last[0], last[1], crds[0], crds[1]);
                        this._clipAndAppend(clippedPath, seg, clipBounds, connect);
                        last[0] = crds[0];
                        last[1] = crds[1];
                        connect = true;
                        break;
                    }
                    case 4: {
                        seg = new Line2D.Double(last[0], last[1], mvto[0], mvto[1]);
                        this._clipAndAppend(clippedPath, seg, clipBounds, connect);
                        connect = false;
                        break;
                    }
                    default: {
                        throw new Error("Not a flattening path iterator");
                    }
                }
                if (seg == null) {
                    // empty if block
                }
                pit.next();
            }
            g.draw(clippedPath);
            return;
        }
        g.draw(this.m_boundaryShape);
    }

    private boolean _isStrokedBoundaryShape() {
        return this.m_boundaryPaint != null;
    }

    private void _clipAndAppend(Path2D path, Line2D line, Rectangle clip, boolean connect) {
        if (clip != null) {
            int clipStatus = Geo2D.clip(clip, line);
            if (clipStatus != 0) {
                if (clipStatus == 1 || this.m_lastClipStatus == 1 || this.m_lastClipStatus == 0) {
                    connect = false;
                }
                path.append(line, connect);
            }
            this.m_lastClipStatus = clipStatus;
        } else {
            path.append(line, connect);
            this.m_lastClipStatus = -1;
        }
    }
}

