/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view.cmds;

import cib.cad.db.comp.Component;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.ViewController;
import cib.cad.lang.Messages;
import cib.util.RuntimeExtensionClassLoader;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;

public class PutViewController
implements Cmd {
    private Class<Component> m_compClass = null;
    private Class<ViewController> m_viewCtrlClass = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        UserInterface ui = krnl.getUserInterface();
        String clsName = null;
        Class<Component> compClass = null;
        while (compClass == null) {
            Class<Component> _compClass = null;
            try {
                clsName = krnl.readString(Messages.getString("view.cmds.PutViewController.0"));
                _compClass = Class.forName(clsName);
            }
            catch (ClassNotFoundException e) {
                RuntimeExtensionClassLoader cl = krnl.getClassLoader();
                try {
                    _compClass = Class.forName(clsName, true, cl);
                }
                catch (ClassNotFoundException x) {
                    krnl.readOK(String.valueOf(Messages.getString("view.cmds.PutViewController.1")) + clsName + Messages.getString("view.cmds.PutViewController.2"), 14);
                }
            }
            if (Component.class.isAssignableFrom(_compClass)) {
                compClass = _compClass;
                continue;
            }
            krnl.readOK(String.valueOf(Messages.getString("view.cmds.PutViewController.3")) + clsName + Messages.getString("view.cmds.PutViewController.4"), 14);
        }
        Class<?> viewCtrlClass = null;
        while (viewCtrlClass == null) {
            Class<?> _viewCtrlClass = null;
            try {
                clsName = krnl.readString(Messages.getString("view.cmds.PutViewController.5"), "<null>");
                if (clsName.equals("<null>")) break;
                _viewCtrlClass = Class.forName(clsName);
            }
            catch (ClassNotFoundException e) {
                RuntimeExtensionClassLoader cl = krnl.getClassLoader();
                try {
                    _viewCtrlClass = Class.forName(clsName, true, cl);
                }
                catch (ClassNotFoundException x) {
                    krnl.readOK(String.valueOf(Messages.getString("view.cmds.PutViewController.8")) + clsName + Messages.getString("view.cmds.PutViewController.9"), 14);
                }
            }
            if (ViewController.class.isAssignableFrom(_viewCtrlClass)) {
                viewCtrlClass = _viewCtrlClass;
                continue;
            }
            krnl.readOK(String.valueOf(Messages.getString("view.cmds.PutViewController.10")) + clsName + Messages.getString("view.cmds.PutViewController.11"), 14);
        }
        Class<ViewController> oldViewCtrlClass = ui.getViewControllerClass(compClass);
        if (oldViewCtrlClass == null && viewCtrlClass == null || oldViewCtrlClass != null && oldViewCtrlClass.equals(viewCtrlClass)) {
            System.out.println(Messages.getString("view.cmds.PutViewController.12"));
            return;
        }
        if (!krnl.readYesNo(Messages.getString("view.cmds.PutViewController.13"), 2)) {
            return;
        }
        ui.putViewControllerAssignment(compClass, viewCtrlClass);
        System.out.println(String.valueOf(Messages.getString("view.cmds.PutViewController.14")) + viewCtrlClass + Messages.getString("view.cmds.PutViewController.15") + compClass);
        this.m_compClass = compClass;
        this.m_viewCtrlClass = oldViewCtrlClass;
        ui.repaintUserInterface();
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        UserInterface ui = krnl.getUserInterface();
        Class<ViewController> viewCtrlClass = ui.getViewControllerClass(this.m_compClass);
        ui.putViewControllerAssignment(this.m_compClass, this.m_viewCtrlClass);
        this.m_viewCtrlClass = viewCtrlClass;
        ui.repaintUserInterface();
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return this.m_compClass != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }
}

