/*
 * Decompiled with CFR 0.152.
 */
package cib.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class AttributedShape
implements Shape,
Cloneable {
    Shape m_shape = null;
    Stroke m_stroke = null;
    Paint m_draw = null;
    Paint m_fill = null;

    protected AttributedShape() {
    }

    public AttributedShape(Shape shape) {
        this.m_shape = shape;
        this.m_stroke = new BasicStroke(0.0f);
        this.m_draw = Color.black;
        this.m_fill = null;
    }

    public AttributedShape(AttributedShape as) {
        if (as.m_shape != null) {
            this.m_shape = new AffineTransform().createTransformedShape(as.m_shape);
        }
        this.m_stroke = as.m_stroke;
        this.m_draw = as.m_draw;
        this.m_fill = as.m_fill;
    }

    public AttributedShape(Shape shape, Stroke stroke, Paint draw, Paint fill) {
        this.m_shape = shape;
        this.m_stroke = stroke;
        this.m_draw = draw;
        this.m_fill = fill;
    }

    public Object clone() {
        try {
            AttributedShape clone = (AttributedShape)super.clone();
            if (this.m_shape != null) {
                clone.m_shape = new AffineTransform().createTransformedShape(this.m_shape);
            }
            clone.m_stroke = this.m_stroke;
            clone.m_draw = this.m_draw;
            clone.m_fill = this.m_fill;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void setShape(Shape shape) {
        this.m_shape = shape;
    }

    public Shape getShape() {
        return this.m_shape;
    }

    public void setDrawPaint(Paint paint) {
        this.m_draw = paint;
    }

    public Paint getDrawPaint() {
        return this.m_draw;
    }

    public void setFillPaint(Paint paint) {
        this.m_fill = paint;
    }

    public Paint getFillPaint() {
        return this.m_fill;
    }

    public void setStroke(Stroke stroke) {
        this.m_stroke = stroke;
    }

    public Stroke getStroke() {
        return this.m_stroke;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.m_shape.contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.m_shape.contains(x, y, w, h);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.m_shape.contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.m_shape.contains(r);
    }

    @Override
    public Rectangle getBounds() {
        return this.m_shape.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.m_shape.getBounds2D();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.m_shape.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.m_shape.getPathIterator(at, flatness);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.m_shape.intersects(x, y, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.m_shape.intersects(r);
    }
}

