/*
 * Decompiled with CFR 0.152.
 */
package cib.util;

import cib.util.coll.CollUtilities;
import cib.util.coll.ReverseAccessMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class NameSpace
implements Serializable {
    private static final long serialVersionUID = 0L;
    public final char SEPARATOR = (char)64;
    private String m_nameExt = "";
    private ReverseAccessMap<Object, String> m_map = CollUtilities.bijectiveReverseAccessMap(new HashMap());
    private Map<String, Long> m_generatedNumbers = new HashMap<String, Long>();
    private static NameSpace s_nameSpace = null;

    public NameSpace() {
        s_nameSpace = this;
    }

    public static NameSpace getInstance() {
        return s_nameSpace;
    }

    public void setNameExtension(String nameExt) {
        if (nameExt.indexOf(64) != -1) {
            throw new IllegalArgumentException("Name extension must not contain a @");
        }
        this.m_nameExt = nameExt;
    }

    public String getNameExtension() {
        return this.m_nameExt;
    }

    public String extendedName(String name) {
        if (this.m_nameExt.equals("")) {
            return name;
        }
        int pos = name.lastIndexOf(64);
        return pos == -1 ? String.valueOf(name) + '@' + this.m_nameExt : name;
    }

    public String generateName() {
        return this.generateName("obj");
    }

    public String generateName(String prefix) {
        String extPrefix = this.extendedName(prefix);
        if (!this.m_generatedNumbers.containsKey(extPrefix)) {
            this.m_generatedNumbers.put(extPrefix, new Long(0L));
        }
        long number = this.m_generatedNumbers.get(extPrefix);
        this.m_generatedNumbers.put(extPrefix, new Long(number + 1L));
        return this.extendedName(String.valueOf(prefix) + Long.toString(number));
    }

    public void clear() {
        this.m_map.clear();
    }

    public void put(Object object, String name) {
        String oldName;
        if (object == null || name == null) {
            throw new NullPointerException();
        }
        String extName = this.extendedName(name);
        if (extName.equals(oldName = (String)this.m_map.get(object))) {
            return;
        }
        if (oldName != null || this.m_map.containsValue(extName)) {
            throw new IllegalArgumentException("Can't change name");
        }
        this.m_map.put(object, extName);
    }

    public String getName(Object object) {
        return (String)this.m_map.get(object);
    }

    public Object getObject(String name) {
        return this.m_map.getKey(this.extendedName(name));
    }

    public boolean containsObject(Object object) {
        return this.m_map.containsKey(object);
    }

    public boolean containsName(String name) {
        return this.m_map.containsValue(this.extendedName(name));
    }

    public void remove(Object object) {
        this.m_map.remove(object);
    }

    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    public int size() {
        return this.m_map.size();
    }

    public String toString() {
        return this.m_map.toString();
    }
}

