/*
 * Decompiled with CFR 0.152.
 */
package cib.util.binding;

import cib.util.binding.Binding;
import cib.util.binding.BindingContext;
import cib.util.binding.BindingModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BindingUtils<E> {
    private static <E> Set<IEdge<E>> _edges(E boundObject, Binding<E> b) {
        HashSet edgeSet = new HashSet();
        Set<E> bindingObjects = b.getBindingObjects();
        for (E bindingObject : bindingObjects) {
            edgeSet.add(new IEdge(bindingObject, boundObject));
        }
        return edgeSet;
    }

    public static <E> void updateBindings(BindingModel<E> bindingModel, Set<E> changedObjects, BindingContext<E> context) {
        if (changedObjects.isEmpty()) {
            return;
        }
        Set<IEdge<E>> edgeSet = BindingUtils.getEdges(bindingModel);
        Set<IEdge<E>> changeSet = BindingUtils.getChangedSet(edgeSet, changedObjects);
        Set<IEdge<E>> changeDomain = BindingUtils.getChangeDomain(edgeSet, changeSet);
        List<List<E>> updateOrder = BindingUtils.topologicalSort(changeDomain);
        int nUpdates = 0;
        if (context == null) {
            context = new BindingContext();
        }
        for (List<E> list : updateOrder) {
            for (E boundObject : list) {
                if (!bindingModel.containsKey(boundObject)) continue;
                Binding binding = (Binding)bindingModel.get(boundObject);
                binding.update(context);
                ++nUpdates;
            }
        }
    }

    private static <E> Set<IEdge<E>> getEdges(Map<E, Binding<E>> bindingMap) {
        HashSet<IEdge<IEdge<E>>> edgeSet = new HashSet<IEdge<IEdge<E>>>();
        Set<E> boundObjects = bindingMap.keySet();
        for (E boundObject : boundObjects) {
            Binding<E> b = bindingMap.get(boundObject);
            edgeSet.addAll(BindingUtils._edges(boundObject, b));
        }
        return edgeSet;
    }

    private static <E> Set<IEdge<E>> getChangedSet(Set<IEdge<E>> edgeSet, Set<E> changedObjects) {
        HashSet<IEdge<IEdge<E>>> changeSet = new HashSet<IEdge<IEdge<E>>>();
        for (IEdge<E> edge : edgeSet) {
            if (!changedObjects.contains(((IEdge)edge).start) && !changedObjects.contains(((IEdge)edge).end)) continue;
            changeSet.add(edge);
        }
        return changeSet;
    }

    private static <E> Set<IEdge<E>> getChangeDomain(Set<IEdge<E>> set, Set<IEdge<E>> changedSet) {
        HashSet<IEdge<E>> allSet = new HashSet<IEdge<E>>(set);
        HashSet affectedSet = new HashSet(changedSet);
        if (affectedSet.isEmpty()) {
            return affectedSet;
        }
        HashSet<IEdge> tmp = new HashSet<IEdge>();
        ArrayList<IEdge<IEdge>> list = new ArrayList<IEdge<IEdge>>(changedSet);
        while (list.size() > 0) {
            tmp.clear();
            IEdge edge = (IEdge)list.remove(0);
            Iterator allSetIter = allSet.iterator();
            while (allSetIter.hasNext()) {
                IEdge e = (IEdge)allSetIter.next();
                if (e.start != edge.end) continue;
                tmp.add(e);
                list.add(e);
                allSetIter.remove();
            }
            affectedSet.addAll(tmp);
        }
        return affectedSet;
    }

    private static <E> List<List<E>> topologicalSort(Set<IEdge<E>> set) {
        HashSet<Object> end;
        ArrayList list = new ArrayList();
        if (set.isEmpty()) {
            return list;
        }
        int counter = 0;
        HashSet<Object> start = new HashSet<Object>();
        for (IEdge<E> e : set) {
            start.add(((IEdge)e).start);
            start.add(((IEdge)e).end);
        }
        HashSet completed = new HashSet();
        do {
            end = new HashSet<Object>();
            Iterator<IEdge<E>> it = set.iterator();
            while (it.hasNext()) {
                IEdge<E> e = it.next();
                if (!completed.contains(((IEdge)e).start)) {
                    end.add(((IEdge)e).end);
                    continue;
                }
                it.remove();
            }
            list.add(new ArrayList());
            Iterator iter = start.iterator();
            boolean cycle = true;
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (end.contains(obj)) continue;
                cycle = false;
                ((List)list.get(counter)).add(obj);
                completed.add(obj);
                iter.remove();
            }
            if (cycle) {
                throw new RuntimeException("Cycle Detected!!!\n" + list);
            }
            ++counter;
        } while (!end.isEmpty());
        list.remove(0);
        return list;
    }

    static class IEdge<E> {
        private E start;
        private E end;

        private IEdge(E start, E end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "(" + this.start + " -> " + this.end + ")";
        }
    }
}

