/*
 * Decompiled with CFR 0.152.
 */
package cib.util.cmd;

import cib.util.Dbg;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class CmdMgr {
    public static final int CAN_UNDO_MORE = 1;
    public static final int CAN_REDO_MORE = 2;
    protected LinkedList<Cmd> m_cmdHistory = new LinkedList();
    protected int m_cmdHistoryIndex = -1;
    protected int m_maximumSize = 20;

    public void setMaximumSize(int n) {
        this.m_maximumSize = n <= 0 ? -1 : n;
    }

    public int getMaximumSize() {
        return this.m_maximumSize;
    }

    public void clear() {
        this.m_cmdHistory.clear();
        this.m_cmdHistoryIndex = -1;
    }

    public boolean isEmpty() {
        return this.m_cmdHistory.isEmpty();
    }

    public int doCmd(Cmd cmd, Object context) {
        try {
            cmd.doCmd(context);
        }
        catch (CmdAbortedException e) {
            return this.getFlags();
        }
        if (cmd.changesState()) {
            if (cmd.isUndoable()) {
                this.m_cmdHistory.add(++this.m_cmdHistoryIndex, cmd);
                Cmd lastCmd = null;
                while (cmd != (lastCmd = this.m_cmdHistory.getLast())) {
                    this.m_cmdHistory.remove(lastCmd);
                }
                if (this.m_maximumSize > 0) {
                    while (this.m_cmdHistory.size() > this.m_maximumSize) {
                        this.m_cmdHistory.removeFirst();
                        --this.m_cmdHistoryIndex;
                    }
                }
            } else {
                this.clear();
            }
        }
        if (Dbg.on()) {
            this.dumpCmdHistory();
        }
        return this.getFlags();
    }

    public int doCmd(Cmd cmd) {
        return this.doCmd(cmd, null);
    }

    public int undoCmd(Object context) {
        if (this.m_cmdHistoryIndex < 0) {
            return this.getFlags();
        }
        Cmd cmd = this.m_cmdHistory.get(this.m_cmdHistoryIndex);
        --this.m_cmdHistoryIndex;
        cmd.undoCmd(context);
        if (Dbg.on()) {
            this.dumpCmdHistory();
        }
        return this.getFlags();
    }

    public int undoCmd() {
        return this.undoCmd(null);
    }

    public int redoCmd(Object context) {
        int index = this.m_cmdHistoryIndex + 1;
        if (index < this.m_cmdHistory.size()) {
            Cmd cmd = this.m_cmdHistory.get(index);
            this.m_cmdHistoryIndex = index;
            cmd.redoCmd(context);
        }
        if (Dbg.on()) {
            this.dumpCmdHistory();
        }
        return this.getFlags();
    }

    public int redoCmd() {
        return this.redoCmd(null);
    }

    public boolean canUndoMore() {
        return this.m_cmdHistoryIndex >= 0;
    }

    public boolean canRedoMore() {
        return this.m_cmdHistoryIndex + 1 < this.m_cmdHistory.size();
    }

    public Iterator<Cmd> undoableCommandsIterator() {
        return new UndoableCommandsIterator(this.m_cmdHistoryIndex);
    }

    public Iterator<Cmd> redoableCommandsIterator() {
        return new RedoableCommandsIterator(this.m_cmdHistoryIndex + 1);
    }

    public void dumpCmdHistory() {
        System.out.println("Dump of command history");
        int index = 0;
        while (index < this.m_cmdHistory.size()) {
            Cmd o = this.m_cmdHistory.get(index);
            String cursor = this.m_cmdHistoryIndex == index ? " <- current" : "";
            System.out.println(" " + index + " " + o.toString() + cursor);
            ++index;
        }
    }

    protected int getFlags() {
        int flags = 0;
        if (this.canUndoMore()) {
            flags |= 1;
        }
        if (this.canRedoMore()) {
            flags |= 2;
        }
        return flags;
    }

    private class RedoableCommandsIterator
    implements Iterator<Cmd> {
        private int m_ind;

        public RedoableCommandsIterator(int ind) {
            this.m_ind = ind;
        }

        @Override
        public boolean hasNext() {
            return this.m_ind < CmdMgr.this.m_cmdHistory.size();
        }

        @Override
        public Cmd next() {
            if (this.m_ind >= CmdMgr.this.m_cmdHistory.size()) {
                throw new NoSuchElementException();
            }
            Cmd cmd = CmdMgr.this.m_cmdHistory.get(this.m_ind++);
            return cmd;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class UndoableCommandsIterator
    implements Iterator<Cmd> {
        private int m_ind;

        public UndoableCommandsIterator(int ind) {
            this.m_ind = ind;
        }

        @Override
        public boolean hasNext() {
            return this.m_ind >= 0;
        }

        @Override
        public Cmd next() {
            if (this.m_ind < 0) {
                throw new NoSuchElementException();
            }
            Cmd cmd = CmdMgr.this.m_cmdHistory.get(this.m_ind--);
            return cmd;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

