/*
 * Decompiled with CFR 0.152.
 */
package cib.util.dxf;

import cib.util.dxf.GroupCode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;

public class DXFWriter {
    private static final String EOL = "\r\n";
    private static final String CHARSET = "ISO-8859-1";
    private OutputStreamWriter m_out = null;
    private File m_file = null;
    private int m_handle = 0;

    protected DXFWriter() {
    }

    public DXFWriter(File file) throws IOException {
        this.m_file = file;
        this.m_out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), CHARSET);
    }

    public void endFile() throws IOException {
        this.writeGroup(GroupCode.GC0, "EOF");
        this.m_out.close();
        String hdl = this.nextHandle();
        char[] chars = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
        int n = hdl.length();
        int i = 0;
        while (i < n) {
            chars[chars.length - i - 1] = hdl.charAt(n - i - 1);
            ++i;
        }
        RandomAccessFile raf = new RandomAccessFile(this.m_file, "rw");
        String tag = raf.readLine();
        String data = raf.readLine();
        while (!tag.equals("  0") || !data.equals("ENDSEC")) {
            if (tag.equals("  9") && data.equals("$HANDSEED")) {
                tag = raf.readLine();
                if (!tag.equals("  5")) {
                    throw new AssertionError((Object)"$HANDSEED not found");
                }
                long fp = raf.getFilePointer();
                data = raf.readLine();
                if (!data.equals("????????")) {
                    throw new AssertionError((Object)"$HANDSEED not found");
                }
                raf.seek(fp);
                raf.writeBytes(new String(chars));
                break;
            }
            tag = raf.readLine();
            data = raf.readLine();
        }
        raf.close();
    }

    public void startSection(String section) throws IOException {
        this.writeGroup(GroupCode.GC0, "SECTION");
        this.writeGroup(GroupCode.GC2, section);
    }

    public void endSection() throws IOException {
        this.writeGroup(GroupCode.GC0, "ENDSEC");
    }

    public String nextHandle() {
        return Integer.toHexString(++this.m_handle).toUpperCase();
    }

    public void writeGroup(GroupCode gc, String val) throws IOException {
        String strgc = Integer.toString(gc.toInt());
        while (strgc.length() < 3) {
            strgc = " " + strgc;
        }
        this.m_out.write(String.valueOf(strgc) + EOL);
        this.m_out.write(String.valueOf(val) + EOL);
    }

    public void writeGroup(GroupCode gc, int val) throws IOException {
        String strval = Integer.toString(val);
        this.writeGroup(gc, strval);
    }

    public void writeGroup(GroupCode gc, double val) throws IOException {
        String strval = Double.isNaN(val) || Double.isInfinite(val) ? "0" : Double.toString(val);
        this.writeGroup(gc, strval);
    }

    public void writeGroup(GroupCode gc, boolean val) throws IOException {
        this.writeGroup(gc, val ? "1" : "0");
    }
}

