/*
 * Decompiled with CFR 0.152.
 */
package cib.util.geo;

import cib.util.geo.Geo2D;
import cib.util.geo.NullVectorException;
import java.awt.geom.Point2D;

public class Vector2D
extends Point2D
implements Cloneable {
    public double x = 0.0;
    public double y = 0.0;
    public static final Vector2D NULL = new Vector2D(0.0, 0.0);
    public static final Vector2D X_UNIT = new Vector2D(1.0, 0.0);
    public static final Vector2D Y_UNIT = new Vector2D(0.0, 1.0);

    static void main(String[] args) throws NullVectorException {
        System.out.println("getAngleCCW(xvec, yvec) = " + X_UNIT.getAngleCCW(Y_UNIT) * 180.0 / Math.PI);
        System.out.println("getAngleCCW(yvec, xvec) = " + Y_UNIT.getAngleCCW(X_UNIT) * 180.0 / Math.PI);
        System.out.println("getAngleCCW(xvec, xvec) = " + X_UNIT.getAngleCCW(X_UNIT) * 180.0 / Math.PI);
        System.out.println("getAngleSmallest(xvec, yvec) = " + X_UNIT.getAngleSmallest(Y_UNIT) * 180.0 / Math.PI);
        System.out.println("getAngleSmallest(yvec, xvec) = " + Y_UNIT.getAngleSmallest(X_UNIT) * 180.0 / Math.PI);
        System.out.println("getAngleSmallest(xvec, xvec) = " + X_UNIT.getAngleSmallest(X_UNIT) * 180.0 / Math.PI);
        Vector2D vec = X_UNIT;
        int i = 0;
        while (i < 12) {
            vec.rotate(0.5235987755982988);
            System.out.println("vec.rotate(Math.PI / 6.): " + vec.x + ", " + vec.y);
            ++i;
        }
    }

    public Vector2D() {
    }

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D(Point2D pnt) {
        this.x = pnt.getX();
        this.y = pnt.getY();
    }

    public Vector2D(Point2D pnt1, Point2D pnt2) {
        this.x = pnt2.getX() - pnt1.getX();
        this.y = pnt2.getY() - pnt1.getY();
    }

    public Vector2D(double x1, double y1, double x2, double y2) {
        this.x = x2 - x1;
        this.y = y2 - y1;
    }

    public Vector2D(Vector2D vec) {
        this.x = vec.getX();
        this.y = vec.getY();
    }

    public Vector2D(double angle) {
        this.x = Math.cos(angle);
        this.y = Math.sin(angle);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double lengthSq() {
        return this.x * this.x + this.y * this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    @Override
    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setLocation(Point2D pnt) {
        this.x = pnt.getX();
        this.y = pnt.getY();
    }

    public void setLocation(Point2D pnt1, Point2D pnt2) {
        this.x = pnt2.getX() - pnt1.getX();
        this.y = pnt2.getY() - pnt1.getY();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public int hashCode() {
        long bits = Double.doubleToLongBits(this.getX());
        return (int)(bits ^= Double.doubleToLongBits(this.getY()) * 31L) ^ (int)(bits >> 32);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Vector2D) {
            Vector2D v2d = (Vector2D)obj;
            return this.getX() == v2d.getX() && this.getY() == v2d.getY();
        }
        return super.equals(obj);
    }

    public Vector2D add(Point2D vec) {
        this.x += vec.getX();
        this.y += vec.getY();
        return this;
    }

    public Vector2D add(double x, double y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2D subtract(Point2D vec) {
        this.x -= vec.getX();
        this.y -= vec.getY();
        return this;
    }

    public Vector2D scaleBy(double factor) {
        this.x *= factor;
        this.y *= factor;
        return this;
    }

    public Vector2D right() {
        double _x = this.x;
        this.x = this.y;
        this.y = -_x;
        return this;
    }

    public Vector2D left() {
        double _x = this.x;
        this.x = -this.y;
        this.y = _x;
        return this;
    }

    public Vector2D rotate(double ang) {
        double cos = Math.cos(-ang);
        double sin = Math.sin(-ang);
        double _x = this.x;
        this.x = this.x * cos + this.y * sin;
        this.y = -_x * sin + this.y * cos;
        return this;
    }

    public Vector2D invert() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2D normalize() throws NullVectorException {
        if (Geo2D.isNull(this)) {
            throw new NullVectorException("Can't normalize a null vector");
        }
        double len = Geo2D.length(this);
        this.x /= len;
        this.y /= len;
        return this;
    }

    public double getScalarProduct(Vector2D vec) {
        return this.x * vec.x + this.y * vec.y;
    }

    public double getAngleCCW(Vector2D vec) throws NullVectorException {
        if (Geo2D.isNull(this) || Geo2D.isNull(vec)) {
            throw new NullVectorException("Can't calculate angle between null vectors");
        }
        double ang1 = Math.atan2(this.getY(), this.getX());
        double ang2 = Math.atan2(vec.getY(), vec.getX());
        double ang = ang2 - ang1 + Math.PI + Math.PI;
        if ((ang %= Math.PI * 2) > Math.PI * 2 - Geo2D.getEps()) {
            ang = 0.0;
        }
        return ang;
    }

    public double getAngleSmallest(Vector2D vec) throws NullVectorException {
        if (Geo2D.isNull(this) || Geo2D.isNull(vec)) {
            throw new NullVectorException("Can't calculate angle between null vectors");
        }
        return Math.acos(this.getScalarProduct(vec) / (Geo2D.length(this) * Geo2D.length(vec)));
    }

    public String toString() {
        return "Vector2D[" + this.x + ", " + this.y + "]";
    }
}

